/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.util.HashMap;
import java.util.Map;
import org.gvnix.flex.addon.metaas.dom.Visibility;
import org.gvnix.flex.addon.metaas.impl.ASTIterator;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.TokenBuilder;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListToken;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

class ModifierUtils {
    private static Map modinfoByTokenType = new HashMap();
    private static Map modinfoByVisibility = new HashMap();

    ModifierUtils() {
    }

    private static void mapMod(int tokenType, Visibility vis, String keyword) {
        ModInfo inf = new ModInfo(tokenType, vis, keyword);
        modinfoByTokenType.put(new Integer(tokenType), inf);
        modinfoByVisibility.put(vis, inf);
    }

    private static ModInfo getModInfo(int tokenType) {
        return (ModInfo)modinfoByTokenType.get(new Integer(tokenType));
    }

    private static ModInfo getModInfo(Visibility vis) {
        ModInfo result = (ModInfo)modinfoByVisibility.get(vis);
        if (result == null) {
            throw new IllegalArgumentException("unknown kind of visibility: " + vis);
        }
        return result;
    }

    public static Visibility getVisibility(LinkedListTree modifiers) {
        ASTIterator i = new ASTIterator(modifiers);
        while (i.hasNext()) {
            LinkedListTree mod = i.next();
            ModInfo modInfo = ModifierUtils.getModInfo(mod.getType());
            if (modInfo == null) continue;
            return modInfo.vis;
        }
        return Visibility.DEFAULT;
    }

    private static boolean hasModifierFlag(LinkedListTree modifiers, int type) {
        ASTIterator i = new ASTIterator(modifiers);
        while (i.hasNext()) {
            LinkedListTree mod = i.next();
            if (mod.getType() != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isDynamic(LinkedListTree modifiers) {
        return ModifierUtils.hasModifierFlag(modifiers, 115);
    }

    public static boolean isFinal(LinkedListTree modifiers) {
        return ModifierUtils.hasModifierFlag(modifiers, 114);
    }

    public static void setDynamic(LinkedListTree modifiers, boolean value) {
        ModifierUtils.setModifierFlag(modifiers, value, 115, "dynamic");
    }

    public static void setFinal(LinkedListTree modifiers, boolean value) {
        ModifierUtils.setModifierFlag(modifiers, value, 114, "final");
    }

    private static void setModifierFlag(LinkedListTree modifiers, boolean flag, int type, String text) {
        ASTIterator i = new ASTIterator(modifiers);
        while (i.hasNext()) {
            LinkedListTree mod = i.next();
            if (mod.getType() != type) continue;
            if (flag) {
                return;
            }
            i.remove();
            if (modifiers.getChildCount() == 0) {
                ModifierUtils.deleteAllChildTokens(modifiers);
            }
            return;
        }
        if (flag) {
            LinkedListTree node = ASTUtils.newAST(type, text);
            node.appendToken(TokenBuilder.newSpace());
            modifiers.addChildWithTokens(node);
        }
    }

    public static void setVisibility(LinkedListTree modifiers, Visibility protection) {
        ModInfo modInfo = ModifierUtils.getModInfo(protection);
        ASTIterator i = new ASTIterator(modifiers);
        while (i.hasNext()) {
            LinkedListTree mod = i.next();
            if (!ModifierUtils.isVisibilityKeyword(mod)) continue;
            if (modInfo.keyword == null) {
                i.remove();
                if (modifiers.getChildCount() == 0) {
                    ModifierUtils.deleteAllChildTokens(modifiers);
                }
            } else {
                mod.token.setType(modInfo.tokenType);
                mod.token.setText(modInfo.keyword);
            }
            return;
        }
        LinkedListTree mod = ASTUtils.newAST(modInfo.tokenType, modInfo.keyword);
        mod.appendToken(TokenBuilder.newSpace());
        modifiers.addChildWithTokens(mod);
    }

    private static boolean isVisibilityKeyword(LinkedListTree mod) {
        return ModifierUtils.getModInfo(mod.getType()) != null;
    }

    private static void deleteAllChildTokens(LinkedListTree modifiers) {
        LinkedListToken tok = modifiers.getStartToken();
        while (tok != null && tok != modifiers.getStopToken()) {
            LinkedListToken next = tok.getNext();
            tok.delete();
            tok = next;
        }
        modifiers.setStartToken(null);
        modifiers.setStopToken(null);
    }

    public static LinkedListTree toModifiers(Visibility visibility) {
        if (Visibility.DEFAULT.equals(visibility)) {
            return ASTUtils.newPlaceholderAST(11);
        }
        LinkedListTree modifiers = ASTUtils.newImaginaryAST(11);
        ModInfo modInfo = ModifierUtils.getModInfo(visibility);
        LinkedListTree mod = ASTUtils.newAST(modInfo.tokenType, modInfo.keyword);
        mod.appendToken(TokenBuilder.newSpace());
        modifiers.addChildWithTokens(mod);
        return modifiers;
    }

    static {
        ModifierUtils.mapMod(107, Visibility.PRIVATE, "private");
        ModifierUtils.mapMod(106, Visibility.PUBLIC, "public");
        ModifierUtils.mapMod(108, Visibility.PROTECTED, "protected");
        ModifierUtils.mapMod(109, Visibility.INTERNAL, "internal");
        ModifierUtils.mapMod(Integer.MIN_VALUE, Visibility.DEFAULT, null);
    }

    private static class ModInfo {
        public int tokenType;
        public Visibility vis;
        public String keyword;

        public ModInfo(int tokenType, Visibility vis, String keyword) {
            this.tokenType = tokenType;
            this.vis = vis;
            this.keyword = keyword;
        }
    }
}

