/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListToken;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;
import org.gvnix.flex.addon.metaas.impl.antlr.TreeTokenListUpdateDelegate;

public class ParentheticListUpdateDelegate
implements TreeTokenListUpdateDelegate {
    private int tokenTypeOpen;
    private int tokenTypeClose;

    public ParentheticListUpdateDelegate(int tokenTypeOpen, int tokenTypeClose) {
        this.tokenTypeOpen = tokenTypeOpen;
        this.tokenTypeClose = tokenTypeClose;
    }

    public void addedChild(LinkedListTree parent, LinkedListTree child) {
        LinkedListToken insert = this.findClose(parent).getPrev();
        ParentheticListUpdateDelegate.insertAfter(insert, insert.getNext(), child.getStartToken(), child.getStopToken());
    }

    private LinkedListToken findOpen(LinkedListTree parent) {
        for (LinkedListToken tok = parent.getStartToken(); tok != null; tok = tok.getNext()) {
            if (tok.getType() != this.tokenTypeOpen) continue;
            return tok;
        }
        return null;
    }

    private LinkedListToken findClose(LinkedListTree parent) {
        for (LinkedListToken tok = parent.getStopToken(); tok != null; tok = tok.getPrev()) {
            if (tok.getType() != this.tokenTypeClose) continue;
            return this.maybeSkiptoLinePreceeding(tok);
        }
        return null;
    }

    private LinkedListToken maybeSkiptoLinePreceeding(LinkedListToken target) {
        block4: for (LinkedListToken tok = target.getPrev(); tok != null; tok = tok.getPrev()) {
            switch (tok.getType()) {
                case 175: {
                    continue block4;
                }
                case 176: {
                    return tok;
                }
                default: {
                    return target;
                }
            }
        }
        return target;
    }

    protected static void insertAfter(LinkedListToken target, LinkedListToken targetNext, LinkedListToken start, LinkedListToken stop) {
        if (target == null && targetNext == null) {
            throw new IllegalArgumentException("At least one of target and targetNext must be non-null");
        }
        if (start != null) {
            if (target != null) {
                target.setNext(start);
            }
            stop.setNext(targetNext);
            if (targetNext != null) {
                targetNext.setPrev(stop);
            }
        }
    }

    public void addedChild(LinkedListTree tree, int index, LinkedListTree child) {
        LinkedListToken targetNext;
        LinkedListToken target;
        if (index == 0) {
            target = this.findOpen(tree);
            targetNext = target.getNext();
        } else {
            LinkedListTree prev = (LinkedListTree)tree.getChild(index - 1);
            target = prev.getStopToken();
            targetNext = target.getNext();
        }
        ParentheticListUpdateDelegate.insertAfter(target, targetNext, child.getStartToken(), child.getStopToken());
    }

    public void appendToken(LinkedListTree parent, LinkedListToken append) {
        LinkedListToken insert = this.findClose(parent).getPrev();
        ParentheticListUpdateDelegate.insertAfter(insert, insert.getNext(), append, append);
    }

    public void addToken(LinkedListTree parent, int index, LinkedListToken append) {
        LinkedListToken targetNext;
        LinkedListToken target;
        if (index == 0) {
            target = this.findOpen(parent);
            targetNext = target.getNext();
        } else {
            LinkedListTree beforeChild = (LinkedListTree)parent.getChild(index);
            targetNext = beforeChild.getStartToken();
            target = targetNext.getPrev();
        }
        ParentheticListUpdateDelegate.insertAfter(target, targetNext, append, append);
    }

    public void deletedChild(LinkedListTree parent, int index, LinkedListTree child) {
        LinkedListToken start = child.getStartToken();
        LinkedListToken stop = child.getStopToken();
        LinkedListToken startPrev = start.getPrev();
        LinkedListToken stopNext = stop.getNext();
        if (startPrev != null) {
            startPrev.setNext(stopNext);
        } else if (stopNext != null) {
            stopNext.setPrev(startPrev);
        }
        start.setPrev(null);
        stop.setNext(null);
    }

    public void replacedChild(LinkedListTree tree, int index, LinkedListTree child, LinkedListTree oldChild) {
        oldChild.getStartToken().getPrev().setNext(child.getStartToken());
        oldChild.getStopToken().getNext().setPrev(child.getStopToken());
        oldChild.getStartToken().setPrev(null);
        oldChild.getStopToken().setNext(null);
    }
}

