/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.gvnix.flex.addon.metaas.impl.ASQName;
import org.gvnix.flex.addon.metaas.impl.ResourceRoot;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SWCResourceRoot
implements ResourceRoot {
    private List qnames = null;
    private static final String CATALOG_FILENAME = "catalog.xml";

    public SWCResourceRoot(String filename) throws IOException {
        ZipFile zip = new ZipFile(filename);
        try {
            ZipEntry entry = zip.getEntry(CATALOG_FILENAME);
            if (entry == null) {
                throw new IllegalArgumentException("No catalog.xml in swc: " + filename);
            }
            this.qnames = this.readCatalog(zip.getInputStream(entry));
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.toString());
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
        catch (XPathExpressionException e) {
            throw new IOException(e.toString());
        }
        finally {
            zip.close();
        }
    }

    private List readCatalog(InputStream in) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        Document doc = this.loadDoc(in);
        XPathFactory fact = XPathFactory.newInstance();
        XPath xpath = fact.newXPath();
        NodeList list = (NodeList)xpath.evaluate("/swc/libraries/library/script/def", doc, XPathConstants.NODESET);
        ArrayList<ASQName> result = new ArrayList<ASQName>();
        for (int i = 0; i < list.getLength(); ++i) {
            Element def = (Element)list.item(i);
            String defined = def.getAttribute("id");
            result.add(this.toQName(defined));
        }
        return result;
    }

    private ASQName toQName(String def) {
        int pos = def.indexOf(58);
        if (pos > 0) {
            return new ASQName(def.substring(0, pos), def.substring(pos + 1));
        }
        return new ASQName(null, def);
    }

    private Document loadDoc(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = fact.newDocumentBuilder();
        InputSource is = new InputSource(in);
        is.setSystemId(CATALOG_FILENAME);
        return builder.parse(is);
    }

    public List getDefinitionQNames() {
        return this.qnames;
    }
}

