/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.gvnix.flex.addon.metaas.dom.ASMetaTag;
import org.gvnix.flex.addon.metaas.impl.ASTASMetaTag;
import org.gvnix.flex.addon.metaas.impl.ASTBuilder;
import org.gvnix.flex.addon.metaas.impl.ASTIterator;
import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.TokenBuilder;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListToken;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;

public class TagUtils {
    public static List getAllMetaTags(LinkedListTree ast) {
        ASTIterator i = TagUtils.iterTags(ast);
        LinkedList<ASTASMetaTag> result = new LinkedList<ASTASMetaTag>();
        while (i.hasNext()) {
            result.add(TagUtils.toMetaTag(i.next()));
        }
        return Collections.unmodifiableList(result);
    }

    public static ASMetaTag getFirstMetaTag(LinkedListTree ast, String name) {
        ASTIterator i = TagUtils.iterTags(ast);
        while (i.hasNext()) {
            ASTASMetaTag tag = TagUtils.toMetaTag(i.next());
            if (!tag.getName().equals(name)) continue;
            return tag;
        }
        return null;
    }

    public static List getMetaTagWithName(LinkedListTree ast, String name) {
        ASTIterator i = TagUtils.iterTags(ast);
        LinkedList<ASTASMetaTag> result = new LinkedList<ASTASMetaTag>();
        while (i.hasNext()) {
            ASTASMetaTag tag = TagUtils.toMetaTag(i.next());
            if (!tag.getName().equals(name)) continue;
            result.add(tag);
        }
        return Collections.unmodifiableList(result);
    }

    public static ASMetaTag newMetaTag(LinkedListTree ast, String name) {
        LinkedListTree tag = ASTBuilder.newMetadataTag(name);
        LinkedListToken trailingnl = TokenBuilder.newNewline();
        tag.getStopToken().afterInsert(trailingnl);
        tag.setStopToken(trailingnl);
        String indent = ASTUtils.findIndent(ast);
        if (indent.length() > 0) {
            LinkedListToken stopToken = tag.getStopToken();
            LinkedListToken indentTok = TokenBuilder.newWhiteSpace(indent);
            stopToken.afterInsert(indentTok);
            tag.setStopToken(indentTok);
        }
        TagUtils.findTags(ast).addChildWithTokens(tag);
        return TagUtils.toMetaTag(tag);
    }

    private static ASTIterator iterTags(LinkedListTree ast) {
        return new ASTIterator(TagUtils.findTags(ast));
    }

    private static LinkedListTree findTags(LinkedListTree ast) {
        return ASTUtils.findChildByType(ast, 8);
    }

    private static ASTASMetaTag toMetaTag(LinkedListTree tag) {
        ASTUtils.assertAS3TokenTypeIs(9, tag.getType());
        return new ASTASMetaTag(tag);
    }
}

