/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.addon.metaas.impl.antlr;

import org.gvnix.flex.addon.metaas.impl.ASTUtils;
import org.gvnix.flex.addon.metaas.impl.TokenBuilder;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListToken;
import org.gvnix.flex.addon.metaas.impl.antlr.LinkedListTree;
import org.gvnix.flex.addon.metaas.impl.antlr.PlaceholderLinkedListToken;
import org.gvnix.flex.addon.metaas.impl.antlr.TreeTokenListUpdateDelegate;

public class BasicListUpdateDelegate
implements TreeTokenListUpdateDelegate {
    public void addedChild(LinkedListTree parent, LinkedListTree child) {
        if (this.isPlaceholder(parent)) {
            if (this.isPlaceholder(child)) {
                throw new IllegalArgumentException("The parent node (" + ASTUtils.tokenName(parent) + ") has only a placeholder token, so a child which also has only a placeholder token (" + ASTUtils.tokenName(child) + ") can't be added yet");
            }
            LinkedListToken placeholder = parent.getStartToken();
            if (placeholder.getPrev() != null) {
                placeholder.getPrev().setNext(child.getStartToken());
            }
            if (placeholder.getNext() != null) {
                placeholder.getNext().setPrev(child.getStopToken());
            }
            parent.setStartToken(child.getStartToken());
            parent.setStopToken(child.getStopToken());
            return;
        }
        LinkedListToken stop = this.findTokenInsertionPointForChildWithinParent(parent, child);
        if (parent.getStartToken() == null) {
            parent.setStartToken(child.getStartToken());
        }
        if (stop != null) {
            BasicListUpdateDelegate.insertAfter(stop, stop.getNext(), child.getStartToken(), child.getStopToken());
        }
        if (child.getStopToken() != null) {
            parent.setStopToken(child.getStopToken());
        }
    }

    private boolean isPlaceholder(LinkedListTree ast) {
        return ast.getStartToken() == ast.getStopToken() && ast.getStartToken() != null && ast.getStartToken().getType() == 57 && ((PlaceholderLinkedListToken)ast.getStartToken()).getHeld() == ast;
    }

    private LinkedListToken findTokenInsertionPointForChildWithinParent(LinkedListTree parent, LinkedListTree child) {
        while (parent != null) {
            int index;
            if (parent.getChildCount() == 1) {
                if (parent.getStopToken() != null) {
                    return parent.getStopToken();
                }
                if (parent.getStartToken() != null) {
                    return parent.getStartToken();
                }
            }
            if ((index = parent.getIndexOfChild(child)) > 0 && index < parent.getChildCount() - 1) {
                LinkedListTree precedent = (LinkedListTree)parent.getChild(index - 1);
                if (precedent.getStopToken() == null) {
                    return this.findTokenInsertionPointForChildWithinParent(parent, precedent);
                }
                return precedent.getStopToken();
            }
            if (index == 0 && parent.getStartToken() != null) {
                return parent.getStartToken();
            }
            if (parent.getStopToken() != null) {
                return parent.getStopToken();
            }
            child = parent;
            parent = parent.getParent();
        }
        return null;
    }

    public void addedChild(LinkedListTree parent, int index, LinkedListTree child) {
        LinkedListToken target;
        LinkedListToken targetNext;
        if (index == 0) {
            LinkedListTree prevFirstChild = (LinkedListTree)parent.getChild(1);
            targetNext = prevFirstChild.getStartToken();
            target = targetNext.getPrev();
            if (targetNext == parent.getStartToken()) {
                parent.setStartToken(child.getStartToken());
            }
        } else {
            target = ((LinkedListTree)parent.getChild(index - 1)).getStopToken();
            targetNext = target.getNext();
        }
        BasicListUpdateDelegate.insertAfter(target, targetNext, child.getStartToken(), child.getStopToken());
    }

    protected static void insertAfter(LinkedListToken target, LinkedListToken targetNext, LinkedListToken start, LinkedListToken stop) {
        if (target == null && targetNext == null) {
            throw new IllegalArgumentException("At least one of target and targetNext must be non-null");
        }
        if (start != null) {
            if (target != null) {
                target.setNext(start);
            }
            stop.setNext(targetNext);
            if (targetNext != null) {
                targetNext.setPrev(stop);
            }
        }
    }

    public void appendToken(LinkedListTree parent, LinkedListToken append) {
        if (parent.getStopToken() == null) {
            parent.setStartToken(append);
            parent.setStopToken(append);
        } else {
            append.setNext(parent.getStopToken().getNext());
            parent.getStopToken().setNext(append);
            append.setPrev(parent.getStopToken());
            parent.setStopToken(append);
        }
    }

    public void addToken(LinkedListTree parent, int index, LinkedListToken append) {
        if (this.isPlaceholder(parent)) {
            LinkedListToken placeholder = parent.getStartToken();
            parent.setStartToken(append);
            parent.setStopToken(append);
            placeholder.setPrev(null);
            placeholder.setNext(null);
        }
        if (parent.getStopToken() == null) {
            parent.setStartToken(append);
            parent.setStopToken(append);
        } else {
            LinkedListToken target;
            LinkedListToken targetNext;
            if (index == 0) {
                targetNext = parent.getStartToken();
                target = targetNext.getPrev();
                parent.setStartToken(append);
            } else if (index == parent.getChildCount()) {
                target = parent.getStopToken();
                targetNext = target.getNext();
                parent.setStopToken(append);
            } else {
                LinkedListTree beforeChild = (LinkedListTree)parent.getChild(index);
                targetNext = beforeChild.getStartToken();
                target = targetNext.getPrev();
            }
            BasicListUpdateDelegate.insertAfter(target, targetNext, append, append);
        }
    }

    public void deletedChild(LinkedListTree parent, int index, LinkedListTree child) {
        LinkedListToken start = child.getStartToken();
        LinkedListToken stop = child.getStopToken();
        LinkedListToken startPrev = start.getPrev();
        LinkedListToken stopNext = stop.getNext();
        if (parent.getChildCount() == 0 && start == parent.getStartToken() && stop == parent.getStopToken()) {
            LinkedListToken placeholder = TokenBuilder.newPlaceholder(parent);
            startPrev.setNext(placeholder);
            stopNext.setPrev(placeholder);
        } else {
            if (startPrev != null) {
                startPrev.setNext(stopNext);
            } else if (stopNext != null) {
                stopNext.setPrev(startPrev);
            }
            if (parent.getStartToken() == start) {
                parent.setStartToken(stopNext);
            }
            if (parent.getStopToken() == stop) {
                parent.setStopToken(startPrev);
            }
        }
        start.setPrev(null);
        stop.setNext(null);
    }

    public void replacedChild(LinkedListTree tree, int index, LinkedListTree child, LinkedListTree oldChild) {
        if (child.getStartToken() == null) {
            throw new IllegalArgumentException("No startToken: " + child);
        }
        if (child.getStopToken() == null) {
            throw new IllegalArgumentException("No stopToken: " + child);
        }
        LinkedListToken oldBefore = this.findOldBeforeToken(tree, index, child, oldChild);
        LinkedListToken oldAfter = this.findOldAfterToken(tree, index, child, oldChild);
        if (oldBefore != null) {
            oldBefore.setNext(child.getStartToken());
        }
        if (oldAfter != null) {
            oldAfter.setPrev(child.getStopToken());
        }
        oldChild.getStartToken().setPrev(null);
        oldChild.getStopToken().setNext(null);
        if (tree.getStartToken() == oldChild.getStartToken()) {
            tree.setStartToken(child.getStartToken());
        }
        if (tree.getStopToken() == oldChild.getStopToken()) {
            tree.setStopToken(child.getStopToken());
        }
    }

    private LinkedListToken findOldBeforeToken(LinkedListTree tree, int index, LinkedListTree child, LinkedListTree oldChild) {
        LinkedListToken oldStart = oldChild.getStartToken();
        if (oldStart == null) {
            throw new IllegalStateException("<" + oldChild + ">, child " + index + " of <" + tree + ">, had no startToken");
        }
        return oldStart.getPrev();
    }

    private LinkedListToken findOldAfterToken(LinkedListTree tree, int index, LinkedListTree child, LinkedListTree oldChild) {
        LinkedListToken oldStop = oldChild.getStopToken();
        if (oldStop == null) {
            throw new IllegalStateException("<" + oldChild + ">, child " + index + " of <" + tree + ">, had no stopToken");
        }
        return oldStop.getNext();
    }
}

