/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.as.classpath;

import org.apache.commons.lang3.Validate;
import org.gvnix.flex.as.model.ActionScriptType;
import org.springframework.roo.metadata.MetadataIdentificationUtils;
import org.springframework.roo.project.LogicalPath;
import org.springframework.roo.project.Path;

public class ASPhysicalTypeIdentifierNamingUtils {
    public static final String createIdentifier(String providesType, ActionScriptType actionScriptType, String path) {
        Validate.notNull((Object)actionScriptType, (String)"ActionScript type required", (Object[])new Object[0]);
        Validate.notNull((Object)path, (String)"Path required", (Object[])new Object[0]);
        return MetadataIdentificationUtils.create((String)providesType, (String)(Path.ROOT + "?" + actionScriptType.getFullyQualifiedTypeName()));
    }

    public static final ActionScriptType getActionScriptType(String providesType, String metadataIdentificationString) {
        Validate.isTrue((boolean)ASPhysicalTypeIdentifierNamingUtils.isValid(providesType, metadataIdentificationString), (String)("Metadata identification string '" + metadataIdentificationString + "' does not appear to be a valid actionscript type identifier"), (Object[])new Object[0]);
        String instance = MetadataIdentificationUtils.getMetadataInstance((String)metadataIdentificationString);
        int index = instance.indexOf("?");
        return new ActionScriptType(instance.substring(index + 1));
    }

    public static final LogicalPath getPath(String providesType, String metadataIdentificationString) {
        Validate.isTrue((boolean)ASPhysicalTypeIdentifierNamingUtils.isValid(providesType, metadataIdentificationString), (String)("Metadata identification string '" + metadataIdentificationString + "' does not appear to be a valid actionscript type identifier"), (Object[])new Object[0]);
        String instance = MetadataIdentificationUtils.getMetadataInstance((String)metadataIdentificationString);
        int index = instance.indexOf("?");
        return LogicalPath.getInstance((String)instance.substring(0, index));
    }

    public static boolean isValid(String providesType, String metadataIdentificationString) {
        if (!MetadataIdentificationUtils.isIdentifyingInstance((String)metadataIdentificationString)) {
            return false;
        }
        if (!MetadataIdentificationUtils.getMetadataClass((String)metadataIdentificationString).equals(providesType)) {
            return false;
        }
        return MetadataIdentificationUtils.getMetadataInstance((String)metadataIdentificationString).contains("?");
    }
}

