/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.as.classpath.as3parser;

import java.io.FileReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.gvnix.flex.addon.metaas.ActionScriptFactory;
import org.gvnix.flex.addon.metaas.dom.ASCompilationUnit;
import org.gvnix.flex.as.classpath.ASPhysicalTypeDetails;
import org.gvnix.flex.as.classpath.ASPhysicalTypeIdentifier;
import org.gvnix.flex.as.classpath.ASPhysicalTypeMetadata;
import org.gvnix.flex.as.classpath.ASPhysicalTypeMetadataProvider;
import org.gvnix.flex.as.classpath.as3parser.As3ParserMutableClassOrInterfaceTypeDetails;
import org.springframework.roo.metadata.AbstractMetadataItem;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.process.manager.ActiveProcessManager;
import org.springframework.roo.process.manager.FileManager;
import org.springframework.roo.process.manager.ProcessManager;
import org.springframework.roo.support.logging.HandlerUtils;

public class As3ParserClassMetadata
extends AbstractMetadataItem
implements ASPhysicalTypeMetadata {
    private static final Logger logger = HandlerUtils.getLogger(As3ParserClassMetadata.class);
    private static final ActionScriptFactory asFactory = new ActionScriptFactory();
    private final String fileIdentifier;
    private ASPhysicalTypeDetails physicalTypeDetails;

    public As3ParserClassMetadata(FileManager fileManager, String fileIdentifier, String metadataIdentificationString, MetadataService metadataService, ASPhysicalTypeMetadataProvider asPhysicalTypeMetadataProvider) {
        super(metadataIdentificationString);
        Validate.isTrue((boolean)ASPhysicalTypeIdentifier.isValid(metadataIdentificationString), (String)("Metadata identification string '" + metadataIdentificationString + "' does not appear to be a valid actionscript type identifier"), (Object[])new Object[0]);
        Validate.notNull((Object)fileManager, (String)"File manager required", (Object[])new Object[0]);
        Validate.notNull((Object)fileIdentifier, (String)"File identifier required", (Object[])new Object[0]);
        Validate.notNull((Object)metadataService, (String)"Metadata service required", (Object[])new Object[0]);
        Validate.notNull((Object)asPhysicalTypeMetadataProvider, (String)"Physical type metadata provider required", (Object[])new Object[0]);
        this.fileIdentifier = fileIdentifier;
        try {
            Validate.isTrue((boolean)fileManager.exists(fileIdentifier), (String)("Path '" + fileIdentifier + "' must exist"), (Object[])new Object[0]);
            FileReader asFileReader = new FileReader(fileManager.readFile(fileIdentifier).getFile());
            ASCompilationUnit compilationUnit = asFactory.newParser().parse(asFileReader);
            this.physicalTypeDetails = new As3ParserMutableClassOrInterfaceTypeDetails(compilationUnit, fileManager, metadataIdentificationString, fileIdentifier, ASPhysicalTypeIdentifier.getActionScriptType(metadataIdentificationString), metadataService, asPhysicalTypeMetadataProvider);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Parsed '" + metadataIdentificationString + "'");
            }
        }
        catch (Exception ex) {
            ProcessManager pm = ActiveProcessManager.getActiveProcessManager();
            if (pm != null && pm.isDevelopmentMode()) {
                ex.printStackTrace();
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Unable to parse '" + metadataIdentificationString + "'", ex);
            }
            this.valid = false;
        }
    }

    @Override
    public ASPhysicalTypeDetails getPhysicalTypeDetails() {
        return this.physicalTypeDetails;
    }

    @Override
    public String getPhysicalLocationCanonicalPath() {
        return this.fileIdentifier;
    }

    public String toString() {
        ToStringBuilder tsc = new ToStringBuilder((Object)this);
        tsc.append("identifier", (Object)this.getId());
        tsc.append("valid", this.valid);
        tsc.append("fileIdentifier", (Object)this.fileIdentifier);
        tsc.append("physicalTypeDetails", (Object)this.physicalTypeDetails);
        return tsc.toString();
    }
}

