/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.as.classpath.as3parser;

import java.io.File;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.gvnix.flex.as.classpath.ASMutablePhysicalTypeMetadataProvider;
import org.gvnix.flex.as.classpath.ASPhysicalTypeCategory;
import org.gvnix.flex.as.classpath.ASPhysicalTypeDetails;
import org.gvnix.flex.as.classpath.ASPhysicalTypeIdentifier;
import org.gvnix.flex.as.classpath.ASPhysicalTypeMetadata;
import org.gvnix.flex.as.classpath.as3parser.As3ParserClassMetadata;
import org.gvnix.flex.as.classpath.as3parser.As3ParserMutableClassOrInterfaceTypeDetails;
import org.gvnix.flex.as.classpath.details.ASClassOrInterfaceTypeDetails;
import org.gvnix.flex.as.model.ActionScriptType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.springframework.roo.file.monitor.event.FileDetails;
import org.springframework.roo.file.monitor.event.FileEvent;
import org.springframework.roo.file.monitor.event.FileEventListener;
import org.springframework.roo.file.monitor.event.FileOperation;
import org.springframework.roo.metadata.MetadataDependencyRegistry;
import org.springframework.roo.metadata.MetadataItem;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.process.manager.FileManager;
import org.springframework.roo.project.LogicalPath;
import org.springframework.roo.project.Path;
import org.springframework.roo.project.PathResolver;
import org.springframework.roo.support.logging.HandlerUtils;

@Component
@Service
public class As3ParserMetadataProvider
implements ASMutablePhysicalTypeMetadataProvider,
FileEventListener {
    protected static final Logger LOGGER = HandlerUtils.getLogger(As3ParserMetadataProvider.class);
    private BundleContext context;
    private FileManager fileManager;
    private MetadataService metadataService;
    private MetadataDependencyRegistry metadataDependencyRegistry;
    private PathResolver pathResolver;

    protected void activate(ComponentContext cContext) {
        this.context = cContext.getBundleContext();
    }

    @Override
    public void createPhysicalType(ASPhysicalTypeMetadata toCreate) {
        Validate.notNull((Object)toCreate, (String)"Metadata to create is required", (Object[])new Object[0]);
        ASPhysicalTypeDetails physicalTypeDetails = toCreate.getPhysicalTypeDetails();
        Validate.notNull((Object)physicalTypeDetails, (String)("Unable to parse '" + toCreate + "'"), (Object[])new Object[0]);
        Validate.isInstanceOf(ASClassOrInterfaceTypeDetails.class, (Object)physicalTypeDetails, (String)"This implementation can only create class or interface types", (Object[])new Object[0]);
        ASClassOrInterfaceTypeDetails cit = (ASClassOrInterfaceTypeDetails)physicalTypeDetails;
        String fileIdentifier = toCreate.getPhysicalLocationCanonicalPath();
        As3ParserMutableClassOrInterfaceTypeDetails.createType(this.getFileManager(), cit, fileIdentifier);
    }

    @Override
    public String findIdentifier(ActionScriptType actionScriptType) {
        Validate.notNull((Object)actionScriptType, (String)"ActionScript type to locate is required", (Object[])new Object[0]);
        String relativePath = actionScriptType.getFullyQualifiedTypeName().replace('.', File.separatorChar) + ".as";
        String fileIdentifier = this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.ROOT, (String)""), "src/main/flex/" + relativePath);
        if (this.getFileManager().exists(fileIdentifier)) {
            return ASPhysicalTypeIdentifier.createIdentifier(actionScriptType, "src/main/flex");
        }
        return null;
    }

    public MetadataItem get(String metadataIdentificationString) {
        ASClassOrInterfaceTypeDetails details;
        Validate.isTrue((boolean)ASPhysicalTypeIdentifier.isValid(metadataIdentificationString), (String)("Metadata identification string '" + metadataIdentificationString + "' is not valid for this metadata provider"), (Object[])new Object[0]);
        String fileIdentifier = this.obtainPathToIdentifier(metadataIdentificationString);
        this.getMetadataDependencyRegistry().deregisterDependencies(metadataIdentificationString);
        if (!this.getFileManager().exists(fileIdentifier)) {
            return null;
        }
        As3ParserClassMetadata result = new As3ParserClassMetadata(this.getFileManager(), fileIdentifier, metadataIdentificationString, this.getMetadataService(), this);
        if (result.getPhysicalTypeDetails() != null && result.getPhysicalTypeDetails() instanceof ASClassOrInterfaceTypeDetails && (details = (ASClassOrInterfaceTypeDetails)result.getPhysicalTypeDetails()).getPhysicalTypeCategory() == ASPhysicalTypeCategory.CLASS && details.getExtendsTypes().size() == 1) {
            if (details.getSuperClass() != null) {
                String superclassId = details.getSuperClass().getDeclaredByMetadataId();
                this.getMetadataDependencyRegistry().registerDependency(superclassId, result.getId());
            } else {
                String possibleSuperclass = ASPhysicalTypeIdentifier.createIdentifier(details.getExtendsTypes().get(0), "src/main/flex");
                this.getMetadataDependencyRegistry().registerDependency(possibleSuperclass, result.getId());
            }
        }
        return result;
    }

    public String getProvidesType() {
        return ASPhysicalTypeIdentifier.getMetadataIdentiferType();
    }

    public void onFileEvent(FileEvent fileEvent) {
        String fileIdentifier = fileEvent.getFileDetails().getCanonicalPath();
        if (fileIdentifier.endsWith(".as") && fileEvent.getOperation() != FileOperation.MONITORING_FINISH) {
            LogicalPath sourcePath = null;
            LogicalPath path = LogicalPath.getInstance((Path)Path.ROOT, (String)"");
            if (new FileDetails(new File(this.getPathResolver().getRoot(path)), null).isParentOf(fileIdentifier)) {
                sourcePath = path;
            }
            if (sourcePath == null) {
                return;
            }
            String relativePath = this.getPathResolver().getRelativeSegment(fileIdentifier);
            StringUtils.isNotBlank((CharSequence)relativePath);
            Validate.isTrue((boolean)relativePath.startsWith(File.separator), (String)("Relative path unexpectedly dropped the '" + File.separator + "' prefix (received '" + relativePath + "' from '" + fileIdentifier + "'"), (Object[])new Object[0]);
            relativePath = relativePath.substring(1);
            Validate.isTrue((boolean)relativePath.endsWith(".as"), (String)("The relative path unexpectedly dropped the .as extension for file '" + fileIdentifier + "'"), (Object[])new Object[0]);
            relativePath = relativePath.substring(0, relativePath.lastIndexOf(".as"));
            ActionScriptType actionScriptType = new ActionScriptType(relativePath.replace(File.separatorChar, '.'));
            String id = ASPhysicalTypeIdentifier.createIdentifier(actionScriptType, "src/main/flex");
            this.getMetadataService().evict(id);
            this.getMetadataDependencyRegistry().notifyDownstream(id);
        }
    }

    private String obtainPathToIdentifier(String physicalTypeIdentifier) {
        Validate.isTrue((boolean)ASPhysicalTypeIdentifier.isValid(physicalTypeIdentifier), (String)("Metadata identification string '" + physicalTypeIdentifier + "' is not valid for this metadata provider"), (Object[])new Object[0]);
        LogicalPath path = ASPhysicalTypeIdentifier.getPath(physicalTypeIdentifier);
        ActionScriptType type = ASPhysicalTypeIdentifier.getActionScriptType(physicalTypeIdentifier);
        String relativePath = type.getFullyQualifiedTypeName().replace('.', File.separatorChar) + ".as";
        String fileIdentifier = this.getPathResolver().getIdentifier(path, relativePath);
        return fileIdentifier;
    }

    public FileManager getFileManager() {
        if (this.fileManager == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(FileManager.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (FileManager)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load FileManager on As3ParserMetadataProvider.");
                return null;
            }
        }
        return this.fileManager;
    }

    public MetadataService getMetadataService() {
        if (this.metadataService == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(MetadataService.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (MetadataService)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load MetadataService on As3ParserMetadataProvider.");
                return null;
            }
        }
        return this.metadataService;
    }

    public MetadataDependencyRegistry getMetadataDependencyRegistry() {
        if (this.metadataDependencyRegistry == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(MetadataDependencyRegistry.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (MetadataDependencyRegistry)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load MetadataDependencyRegistry on As3ParserMetadataProvider.");
                return null;
            }
        }
        return this.metadataDependencyRegistry;
    }

    public PathResolver getPathResolver() {
        if (this.pathResolver == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(PathResolver.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (PathResolver)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load PathResolver on As3ParserMetadataProvider.");
                return null;
            }
        }
        return this.pathResolver;
    }
}

