/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.as.classpath.as3parser;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.gvnix.flex.addon.metaas.ActionScriptFactory;
import org.gvnix.flex.addon.metaas.dom.ASClassType;
import org.gvnix.flex.addon.metaas.dom.ASCompilationUnit;
import org.gvnix.flex.addon.metaas.dom.ASField;
import org.gvnix.flex.addon.metaas.dom.ASInterfaceType;
import org.gvnix.flex.addon.metaas.dom.ASMetaTag;
import org.gvnix.flex.addon.metaas.dom.ASMethod;
import org.gvnix.flex.addon.metaas.dom.ASType;
import org.gvnix.flex.as.classpath.ASPhysicalTypeCategory;
import org.gvnix.flex.as.classpath.ASPhysicalTypeMetadata;
import org.gvnix.flex.as.classpath.ASPhysicalTypeMetadataProvider;
import org.gvnix.flex.as.classpath.as3parser.As3ParserUtils;
import org.gvnix.flex.as.classpath.as3parser.CompilationUnitServices;
import org.gvnix.flex.as.classpath.as3parser.details.As3ParserConstructorMetadata;
import org.gvnix.flex.as.classpath.as3parser.details.As3ParserFieldMetadata;
import org.gvnix.flex.as.classpath.as3parser.details.As3ParserMetaTagMetadata;
import org.gvnix.flex.as.classpath.as3parser.details.As3ParserMethodMetadata;
import org.gvnix.flex.as.classpath.details.ASClassOrInterfaceTypeDetails;
import org.gvnix.flex.as.classpath.details.ASConstructorMetadata;
import org.gvnix.flex.as.classpath.details.ASFieldMetadata;
import org.gvnix.flex.as.classpath.details.ASMethodMetadata;
import org.gvnix.flex.as.classpath.details.ASMutableClassOrInterfaceTypeDetails;
import org.gvnix.flex.as.classpath.details.metatag.ASMetaTagMetadata;
import org.gvnix.flex.as.model.ActionScriptPackage;
import org.gvnix.flex.as.model.ActionScriptSymbolName;
import org.gvnix.flex.as.model.ActionScriptType;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.process.manager.FileManager;
import org.springframework.roo.support.util.CollectionUtils;

public class As3ParserMutableClassOrInterfaceTypeDetails
implements ASMutableClassOrInterfaceTypeDetails,
CompilationUnitServices {
    private final FileManager fileManager;
    private final String fileIdentifier;
    private final String declaredByMetadataId;
    private final ActionScriptType name;
    private ASPhysicalTypeCategory physicalTypeCategory;
    private ASConstructorMetadata declaredConstructor;
    private final List<ASFieldMetadata> declaredFields = new ArrayList<ASFieldMetadata>();
    private final List<ASMethodMetadata> declaredMethods = new ArrayList<ASMethodMetadata>();
    private ASClassOrInterfaceTypeDetails superclass = null;
    private final List<ActionScriptType> extendsTypes = new ArrayList<ActionScriptType>();
    private final List<ActionScriptType> implementsTypes = new ArrayList<ActionScriptType>();
    private final List<ASMetaTagMetadata> typeMetaTags = new ArrayList<ASMetaTagMetadata>();
    private final ASCompilationUnit compilationUnit;
    private final ActionScriptPackage compilationUnitPackage;
    public ASType clazz;
    public boolean isDirty = false;

    public As3ParserMutableClassOrInterfaceTypeDetails(ASCompilationUnit compilationUnit, FileManager fileManager, String declaredByMetadataId, String fileIdentifier, ActionScriptType typeName, MetadataService metadataService, ASPhysicalTypeMetadataProvider physicalTypeMetadataProvider) {
        List metaTagList;
        ASInterfaceType interfaceDef;
        Validate.notNull((Object)compilationUnit, (String)"Compilation unit required", (Object[])new Object[0]);
        Validate.notNull((Object)fileManager, (String)"File manager requried", (Object[])new Object[0]);
        Validate.notNull((Object)declaredByMetadataId, (String)"Declared by metadata ID required", (Object[])new Object[0]);
        Validate.notNull((Object)fileIdentifier, (String)"File identifier (canonical path) required", (Object[])new Object[0]);
        Validate.notNull((Object)typeName, (String)"Name required", (Object[])new Object[0]);
        Validate.notNull((Object)metadataService, (String)"Metadata service required", (Object[])new Object[0]);
        Validate.notNull((Object)physicalTypeMetadataProvider, (String)"Physical type metadata provider required", (Object[])new Object[0]);
        this.name = typeName;
        this.declaredByMetadataId = declaredByMetadataId;
        this.fileManager = fileManager;
        this.fileIdentifier = fileIdentifier;
        this.compilationUnit = compilationUnit;
        this.compilationUnitPackage = typeName.getPackage();
        Validate.notNull((Object)compilationUnit.getType(), (String)"No types in compilation unit, so unable to continue parsing", (Object[])new Object[0]);
        this.clazz = compilationUnit.getType();
        this.physicalTypeCategory = this.clazz instanceof ASInterfaceType ? ASPhysicalTypeCategory.INTERFACE : ASPhysicalTypeCategory.CLASS;
        Validate.isTrue((boolean)this.compilationUnitPackage.equals(this.name.getPackage()), (String)("Compilation unit package '" + this.compilationUnitPackage + "' unexpected for type '" + this.name.getPackage() + "'"), (Object[])new Object[0]);
        if (this.clazz instanceof ASClassType) {
            ASClassType classDef = (ASClassType)this.clazz;
            if (classDef.getSuperclass() != null && classDef.getSuperclass().length() > 0) {
                ActionScriptType superType = As3ParserUtils.getActionScriptType(this.compilationUnitPackage, this.getImports(), classDef.getSuperclass());
                this.extendsTypes.add(superType);
                String superclassId = physicalTypeMetadataProvider.findIdentifier(superType);
                ASPhysicalTypeMetadata superPtm = null;
                if (superclassId != null) {
                    superPtm = (ASPhysicalTypeMetadata)metadataService.get(superclassId);
                }
                if (superPtm != null && superPtm.getPhysicalTypeDetails() != null && superPtm.getPhysicalTypeDetails() instanceof ASClassOrInterfaceTypeDetails) {
                    this.superclass = (ASClassOrInterfaceTypeDetails)superPtm.getPhysicalTypeDetails();
                }
            }
            if (!CollectionUtils.isEmpty((Collection)classDef.getImplementedInterfaces())) {
                List interfaces = classDef.getImplementedInterfaces();
                for (String interfaceName : interfaces) {
                    this.implementsTypes.add(As3ParserUtils.getActionScriptType(this.compilationUnitPackage, this.getImports(), interfaceName));
                }
            }
        } else if (this.clazz instanceof ASInterfaceType && !CollectionUtils.isEmpty((Collection)(interfaceDef = (ASInterfaceType)this.clazz).getSuperInterfaces())) {
            List superInterfaces = interfaceDef.getSuperInterfaces();
            for (String superInterface : superInterfaces) {
                this.extendsTypes.add(As3ParserUtils.getActionScriptType(this.compilationUnitPackage, this.getImports(), superInterface));
            }
        }
        if ((metaTagList = this.clazz.getAllMetaTags()) != null) {
            for (ASMetaTag metaTag : metaTagList) {
                As3ParserMetaTagMetadata md = new As3ParserMetaTagMetadata(metaTag);
                this.typeMetaTags.add(md);
            }
        }
        for (ASMethod method : this.clazz.getMethods()) {
            if (method.getName().equals(this.name.getSimpleTypeName())) {
                Validate.isTrue((this.declaredConstructor == null ? 1 : 0) != 0, (String)"ActionScript classes may only have one constructor method.", (Object[])new Object[0]);
                this.declaredConstructor = new As3ParserConstructorMetadata(declaredByMetadataId, method, this);
                continue;
            }
            this.declaredMethods.add(new As3ParserMethodMetadata(declaredByMetadataId, method, this));
        }
        if (this.physicalTypeCategory == ASPhysicalTypeCategory.CLASS) {
            ASClassType clazzType = (ASClassType)this.clazz;
            for (ASField field : clazzType.getFields()) {
                this.declaredFields.add(new As3ParserFieldMetadata(declaredByMetadataId, field, this));
            }
        }
    }

    @Override
    public void addField(ASFieldMetadata fieldMetadata, boolean flush) {
        Validate.isInstanceOf(ASClassType.class, (Object)this.clazz, (String)"Cannot add a field to an interface", (Object[])new Object[0]);
        As3ParserFieldMetadata.addField(this, (ASClassType)this.clazz, fieldMetadata, flush);
        if (!flush) {
            this.isDirty = true;
        }
    }

    @Override
    public void addMethod(ASMethodMetadata methodMetadata, boolean flush) {
        As3ParserMethodMetadata.addMethod(this, this.clazz, methodMetadata, flush);
        if (!flush) {
            this.isDirty = true;
        }
    }

    @Override
    public void addTypeMetaTag(ASMetaTagMetadata metaTag, boolean flush) {
        As3ParserMetaTagMetadata.addMetaTagToElement(this, metaTag, this.clazz, flush);
        if (!flush) {
            this.isDirty = true;
        }
    }

    @Override
    public void updateField(ASFieldMetadata fieldMetadata, boolean flush) {
        Validate.isInstanceOf(ASClassType.class, (Object)this.clazz, (String)"Cannot update a field on an interface", (Object[])new Object[0]);
        Validate.isTrue((boolean)this.getDeclaredFields().contains(fieldMetadata), (String)"Field does not exist.", (Object[])new Object[0]);
        As3ParserFieldMetadata.updateField(this, (ASClassType)this.clazz, fieldMetadata, flush);
        if (!flush) {
            this.isDirty = true;
        }
    }

    @Override
    public String getDeclaredByMetadataId() {
        return this.declaredByMetadataId;
    }

    @Override
    public ASConstructorMetadata getDeclaredConstructor() {
        return this.declaredConstructor;
    }

    @Override
    public List<ASFieldMetadata> getDeclaredFields() {
        return this.declaredFields;
    }

    @Override
    public List<ASMethodMetadata> getDeclaredMethods() {
        return this.declaredMethods;
    }

    @Override
    public List<ActionScriptType> getExtendsTypes() {
        return this.extendsTypes;
    }

    @Override
    public List<ActionScriptType> getImplementsTypes() {
        return this.implementsTypes;
    }

    @Override
    public List<ASMetaTagMetadata> getTypeMetaTags() {
        return this.typeMetaTags;
    }

    @Override
    public void removeField(ActionScriptSymbolName fieldName, boolean flush) {
        Validate.isInstanceOf(ASClassType.class, (Object)this.clazz, (String)"Cannot remove a field from an interface", (Object[])new Object[0]);
        As3ParserFieldMetadata.removeField(this, (ASClassType)this.clazz, fieldName, flush);
        if (!flush) {
            this.isDirty = true;
        }
    }

    @Override
    public void removeTypeMetaTag(String name, boolean flush) {
        As3ParserMetaTagMetadata.removeMetatagFromElement(this, this.clazz, name, flush);
        if (!flush) {
            this.isDirty = true;
        }
    }

    @Override
    public ActionScriptType getName() {
        return this.name;
    }

    @Override
    public void flush() {
        ActionScriptFactory factory = new ActionScriptFactory();
        StringWriter writer = new StringWriter();
        try {
            factory.newWriter().write(writer, this.compilationUnit);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        StringReader inputStream = null;
        OutputStreamWriter outputStream = null;
        try {
            inputStream = new StringReader(writer.toString());
            outputStream = new OutputStreamWriter(this.fileManager.updateFile(this.fileIdentifier).getOutputStream());
            IOUtils.copy((Reader)inputStream, (Writer)outputStream);
        }
        catch (IOException ioe) {
            try {
                throw new IllegalStateException("Could not update '" + this.fileIdentifier + "'", ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)inputStream);
        IOUtils.closeQuietly((Writer)outputStream);
    }

    @Override
    public ActionScriptPackage getCompilationUnitPackage() {
        return this.compilationUnitPackage;
    }

    @Override
    public List<String> getImports() {
        return this.compilationUnit.getPackage().findImports();
    }

    @Override
    public void addImport(String fullyQualifiedTypeName) {
        this.compilationUnit.getPackage().addImport(fullyQualifiedTypeName);
    }

    @Override
    public ASPhysicalTypeCategory getPhysicalTypeCategory() {
        return this.physicalTypeCategory;
    }

    public static final void createType(FileManager fileManager, ASClassOrInterfaceTypeDetails cit, String fileIdentifier) {
        Validate.notNull((Object)fileManager, (String)"File manager required", (Object[])new Object[0]);
        Validate.notNull((Object)cit, (String)"Class or interface type details required", (Object[])new Object[0]);
        StringUtils.isNotBlank((CharSequence)fileIdentifier);
        String newContents = As3ParserMutableClassOrInterfaceTypeDetails.getOutput(cit);
        fileManager.createOrUpdateTextFileIfRequired(fileIdentifier, newContents, true);
    }

    public static final String getOutput(final ASClassOrInterfaceTypeDetails cit) {
        ActionScriptFactory factory = new ActionScriptFactory();
        final ASCompilationUnit compilationUnit = ASPhysicalTypeCategory.CLASS.equals((Object)cit.getPhysicalTypeCategory()) ? factory.newClass(cit.getName().getFullyQualifiedTypeName()) : factory.newInterface(cit.getName().getFullyQualifiedTypeName());
        CompilationUnitServices compilationUnitServices = new CompilationUnitServices(){

            @Override
            public void flush() {
            }

            @Override
            public ActionScriptPackage getCompilationUnitPackage() {
                return cit.getName().getPackage();
            }

            @Override
            public List<String> getImports() {
                return compilationUnit.getPackage().findImports();
            }

            @Override
            public void addImport(String fullyQualifiedTypeName) {
                compilationUnit.getPackage().addImport(fullyQualifiedTypeName);
            }
        };
        for (ActionScriptType extendsType : cit.getExtendsTypes()) {
            As3ParserUtils.importTypeIfRequired(compilationUnitServices, extendsType);
            if (compilationUnit.getType() instanceof ASClassType) {
                Validate.isTrue((((ASClassType)compilationUnit.getType()).getSuperclass() == null ? 1 : 0) != 0, (String)"An ActionScript class may only extend one type.", (Object[])new Object[0]);
                ((ASClassType)compilationUnit.getType()).setSuperclass(extendsType.getSimpleTypeName());
                continue;
            }
            ((ASInterfaceType)compilationUnit.getType()).addSuperInterface(extendsType.getSimpleTypeName());
        }
        for (ActionScriptType implementsType : cit.getImplementsTypes()) {
            As3ParserUtils.importTypeIfRequired(compilationUnitServices, implementsType);
            ((ASClassType)compilationUnit.getType()).addImplementedInterface(implementsType.getSimpleTypeName());
        }
        for (ASMetaTagMetadata metaTag : cit.getTypeMetaTags()) {
            As3ParserMetaTagMetadata.addMetaTagToElement(compilationUnitServices, metaTag, compilationUnit.getType(), false);
        }
        if (compilationUnit.getType() instanceof ASClassType) {
            for (ASFieldMetadata field : cit.getDeclaredFields()) {
                As3ParserFieldMetadata.addField(compilationUnitServices, (ASClassType)compilationUnit.getType(), field, false);
            }
            if (cit.getDeclaredConstructor() != null) {
                As3ParserConstructorMetadata.addConstructor(compilationUnitServices, compilationUnit.getType(), cit.getDeclaredConstructor(), false);
            }
        }
        for (ASMethodMetadata method : cit.getDeclaredMethods()) {
            As3ParserMethodMetadata.addMethod(compilationUnitServices, compilationUnit.getType(), method, false);
        }
        StringWriter writer = new StringWriter();
        try {
            factory.newWriter().write(writer, compilationUnit);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    @Override
    public ASClassOrInterfaceTypeDetails getSuperClass() {
        return this.superclass;
    }

    @Override
    public void addField(ASFieldMetadata fieldMetadata) {
        this.addField(fieldMetadata, true);
    }

    @Override
    public void addMethod(ASMethodMetadata methodMetadata) {
        this.addMethod(methodMetadata, true);
    }

    @Override
    public void addTypeMetaTag(ASMetaTagMetadata metaTag) {
        this.addTypeMetaTag(metaTag, true);
    }

    @Override
    public void updateField(ASFieldMetadata fieldMetadata) {
        this.addField(fieldMetadata, true);
    }

    @Override
    public void removeField(ActionScriptSymbolName fieldName) {
        this.removeField(fieldName, true);
    }

    @Override
    public void removeTypeMetaTag(String name) {
        this.removeTypeMetaTag(name, true);
    }

    @Override
    public void commit() {
        if (this.isDirty) {
            this.flush();
            this.isDirty = false;
        }
    }
}

