/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.as.classpath.as3parser;

import java.util.List;
import org.apache.commons.lang3.Validate;
import org.gvnix.flex.addon.metaas.dom.ASMetaTag;
import org.gvnix.flex.addon.metaas.dom.ASType;
import org.gvnix.flex.addon.metaas.dom.Visibility;
import org.gvnix.flex.as.classpath.as3parser.CompilationUnitServices;
import org.gvnix.flex.as.classpath.details.metatag.BooleanAttributeValue;
import org.gvnix.flex.as.classpath.details.metatag.IntegerAttributeValue;
import org.gvnix.flex.as.classpath.details.metatag.MetaTagAttributeValue;
import org.gvnix.flex.as.classpath.details.metatag.StringAttributeValue;
import org.gvnix.flex.as.model.ASTypeVisibility;
import org.gvnix.flex.as.model.ActionScriptPackage;
import org.gvnix.flex.as.model.ActionScriptSymbolName;
import org.gvnix.flex.as.model.ActionScriptType;

public class As3ParserUtils {
    public static final ActionScriptType getActionScriptType(ActionScriptPackage compilationUnitPackage, List<String> imports, ASType type) {
        Validate.notNull(imports, (String)"Compilation unit imports required", (Object[])new Object[0]);
        Validate.notNull((Object)compilationUnitPackage, (String)"Compilation unit package required", (Object[])new Object[0]);
        Validate.notNull((Object)type, (String)"ASType required", (Object[])new Object[0]);
        return As3ParserUtils.getActionScriptType(compilationUnitPackage, imports, type.getName());
    }

    public static final ActionScriptType getActionScriptType(ActionScriptPackage compilationUnitPackage, List<String> imports, String nameToFind) {
        Validate.notNull(imports, (String)"Compilation unit imports required", (Object[])new Object[0]);
        Validate.notNull((Object)compilationUnitPackage, (String)"Compilation unit package required", (Object[])new Object[0]);
        Validate.notNull((Object)nameToFind, (String)"Name to find is required", (Object[])new Object[0]);
        int offset = nameToFind.lastIndexOf(46);
        if (offset > -1) {
            return new ActionScriptType(nameToFind);
        }
        if (ActionScriptType.isImplicitType(nameToFind)) {
            return new ActionScriptType(nameToFind);
        }
        String importDeclaration = As3ParserUtils.getImportDeclarationFor(imports, nameToFind);
        if (importDeclaration == null) {
            String name = compilationUnitPackage.getFullyQualifiedPackageName() == "" ? nameToFind : compilationUnitPackage.getFullyQualifiedPackageName() + "." + nameToFind;
            return new ActionScriptType(name);
        }
        return new ActionScriptType(importDeclaration);
    }

    private static final String getImportDeclarationFor(List<String> imports, String typeName) {
        Validate.notNull(imports, (String)"Compilation unit imports required", (Object[])new Object[0]);
        Validate.notNull((Object)typeName, (String)"Type name required", (Object[])new Object[0]);
        for (String candidate : imports) {
            int offset;
            if (!typeName.equals(candidate.substring((offset = candidate.lastIndexOf(46)) + 1))) continue;
            return candidate;
        }
        return null;
    }

    public static void importTypeIfRequired(CompilationUnitServices compilationUnitServices, ActionScriptType typeToImport) {
        Validate.notNull((Object)compilationUnitServices, (String)"Compilation unit services is required", (Object[])new Object[0]);
        Validate.notNull((Object)typeToImport, (String)"ActionScript type to import is required", (Object[])new Object[0]);
        if (ActionScriptType.isImplicitType(typeToImport.getFullyQualifiedTypeName())) {
            return;
        }
        if (typeToImport.isDefaultPackage()) {
            return;
        }
        if (compilationUnitServices.getCompilationUnitPackage().equals(typeToImport.getPackage())) {
            return;
        }
        if (compilationUnitServices.getImports().contains(typeToImport.getFullyQualifiedTypeName())) {
            return;
        }
        compilationUnitServices.addImport(typeToImport.getFullyQualifiedTypeName());
    }

    public static ASTypeVisibility getASTypeVisibility(Visibility as3ParserVisibility) {
        return ASTypeVisibility.valueOf(as3ParserVisibility.toString().replaceAll("\\[|\\]", "").toUpperCase());
    }

    public static Visibility getAs3ParserVisiblity(ASTypeVisibility typeVisibility) {
        switch (typeVisibility) {
            case INTERNAL: {
                return Visibility.INTERNAL;
            }
            case PRIVATE: {
                return Visibility.PRIVATE;
            }
            case PROTECTED: {
                return Visibility.PROTECTED;
            }
            case PUBLIC: {
                return Visibility.PUBLIC;
            }
        }
        return Visibility.DEFAULT;
    }

    public static MetaTagAttributeValue<?> getMetaTagAttributeValue(ASMetaTag.Param param) {
        if (param.getValue() instanceof Boolean) {
            return new BooleanAttributeValue(new ActionScriptSymbolName(param.getName()), (Boolean)param.getValue());
        }
        if (param.getValue() instanceof Integer) {
            return new IntegerAttributeValue(new ActionScriptSymbolName(param.getName()), (Integer)param.getValue());
        }
        return new StringAttributeValue(new ActionScriptSymbolName(param.getName()), String.valueOf(param.getValue()));
    }
}

