/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.as.classpath.as3parser.details;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.gvnix.flex.addon.metaas.dom.ASArg;
import org.gvnix.flex.addon.metaas.dom.ASMetaTag;
import org.gvnix.flex.addon.metaas.dom.ASMethod;
import org.gvnix.flex.addon.metaas.dom.ASType;
import org.gvnix.flex.addon.metaas.dom.Statement;
import org.gvnix.flex.as.classpath.as3parser.As3ParserUtils;
import org.gvnix.flex.as.classpath.as3parser.CompilationUnitServices;
import org.gvnix.flex.as.classpath.as3parser.details.As3ParserMetaTagMetadata;
import org.gvnix.flex.as.classpath.details.ASConstructorMetadata;
import org.gvnix.flex.as.classpath.details.metatag.ASMetaTagMetadata;
import org.gvnix.flex.as.model.ASTypeVisibility;
import org.gvnix.flex.as.model.ActionScriptSymbolName;
import org.gvnix.flex.as.model.ActionScriptType;

public class As3ParserConstructorMetadata
implements ASConstructorMetadata {
    private final String declaredByMetadataId;
    private final String methodBody;
    private final List<ASMetaTagMetadata> metaTags = new ArrayList<ASMetaTagMetadata>();
    private final Map<ActionScriptSymbolName, ActionScriptType> params = new LinkedHashMap<ActionScriptSymbolName, ActionScriptType>();
    private final ASTypeVisibility visibility;

    public As3ParserConstructorMetadata(String declaredByMetadataId, ASMethod method, CompilationUnitServices compilationUnitServices) {
        Validate.notNull((Object)declaredByMetadataId, (String)"Declared by metadata ID required", (Object[])new Object[0]);
        Validate.notNull((Object)method, (String)"Method declaration required", (Object[])new Object[0]);
        Validate.notNull((Object)compilationUnitServices, (String)"Compilation unit services required", (Object[])new Object[0]);
        this.declaredByMetadataId = declaredByMetadataId;
        StringBuffer bodyBuf = new StringBuffer();
        for (Statement statement : method.getStatementList()) {
            bodyBuf.append(statement.toString());
        }
        this.methodBody = bodyBuf.toString();
        List metaTagList = method.getAllMetaTags();
        if (metaTagList != null) {
            for (ASMetaTag metaTag : metaTagList) {
                As3ParserMetaTagMetadata md = new As3ParserMetaTagMetadata(metaTag);
                this.metaTags.add(md);
            }
        }
        List args = method.getArgs();
        for (ASArg arg : args) {
            ActionScriptType paramType = As3ParserUtils.getActionScriptType(compilationUnitServices.getCompilationUnitPackage(), compilationUnitServices.getImports(), arg.getType());
            this.params.put(new ActionScriptSymbolName(arg.getName()), paramType);
        }
        this.visibility = As3ParserUtils.getASTypeVisibility(method.getVisibility());
    }

    @Override
    public String getBody() {
        return this.methodBody;
    }

    @Override
    public List<ASMetaTagMetadata> getMetaTags() {
        return this.metaTags;
    }

    @Override
    public List<ActionScriptSymbolName> getParameterNames() {
        return new ArrayList<ActionScriptSymbolName>(this.params.keySet());
    }

    @Override
    public List<ActionScriptType> getParameterTypes() {
        return new ArrayList<ActionScriptType>(this.params.values());
    }

    @Override
    public String getDeclaredByMetadataId() {
        return this.declaredByMetadataId;
    }

    @Override
    public ASTypeVisibility getVisibility() {
        return this.visibility;
    }

    public static void addConstructor(CompilationUnitServices compilationUnitServices, ASType type, ASConstructorMetadata declaredConstructor, boolean permitFlush) {
        Validate.isTrue((type.getMethod(type.getName()) == null ? 1 : 0) != 0, (String)"ActionScript classes may only have one constructor method.", (Object[])new Object[0]);
        ASMethod constructor = type.newMethod(type.getName(), As3ParserUtils.getAs3ParserVisiblity(declaredConstructor.getVisibility()), null);
        for (ASMetaTagMetadata metaTag : declaredConstructor.getMetaTags()) {
            As3ParserMetaTagMetadata.addMetaTagToElement(compilationUnitServices, metaTag, constructor, false);
        }
        for (int x = 0; x < declaredConstructor.getParameterNames().size(); ++x) {
            ActionScriptSymbolName argName = declaredConstructor.getParameterNames().get(x);
            ActionScriptType argType = declaredConstructor.getParameterTypes().get(x);
            As3ParserUtils.importTypeIfRequired(compilationUnitServices, argType);
            constructor.addParam(argName.getSymbolName(), argType.getSimpleTypeName());
        }
        if (permitFlush) {
            compilationUnitServices.flush();
        }
    }
}

