/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.as.classpath.as3parser.details;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.gvnix.flex.addon.metaas.dom.ASClassType;
import org.gvnix.flex.addon.metaas.dom.ASField;
import org.gvnix.flex.addon.metaas.dom.ASMetaTag;
import org.gvnix.flex.as.classpath.as3parser.As3ParserUtils;
import org.gvnix.flex.as.classpath.as3parser.CompilationUnitServices;
import org.gvnix.flex.as.classpath.as3parser.details.As3ParserMetaTagMetadata;
import org.gvnix.flex.as.classpath.details.ASFieldMetadata;
import org.gvnix.flex.as.classpath.details.AbstractASFieldMetadata;
import org.gvnix.flex.as.classpath.details.metatag.ASMetaTagMetadata;
import org.gvnix.flex.as.model.ASTypeVisibility;
import org.gvnix.flex.as.model.ActionScriptSymbolName;
import org.gvnix.flex.as.model.ActionScriptType;

public class As3ParserFieldMetadata
extends AbstractASFieldMetadata {
    private final ActionScriptType fieldType;
    private ActionScriptSymbolName fieldName;
    private final ASTypeVisibility visibility;
    private final String fieldInitializer;
    private final List<ASMetaTagMetadata> metaTags = new ArrayList<ASMetaTagMetadata>();
    private String declaredByMetadataId;

    public As3ParserFieldMetadata(String declaredByMetadataId, ASField field, CompilationUnitServices compilationUnitServices) {
        Validate.notNull((Object)declaredByMetadataId, (String)"Declared by metadata ID required", (Object[])new Object[0]);
        Validate.notNull((Object)field, (String)"ActionScript field is required", (Object[])new Object[0]);
        Validate.notNull((Object)compilationUnitServices, (String)"Compilation unit services are required", (Object[])new Object[0]);
        this.setDeclaredByMetadataId(declaredByMetadataId);
        this.fieldType = As3ParserUtils.getActionScriptType(compilationUnitServices.getCompilationUnitPackage(), compilationUnitServices.getImports(), field.getType());
        this.setFieldName(new ActionScriptSymbolName(field.getName()));
        this.visibility = As3ParserUtils.getASTypeVisibility(field.getVisibility());
        this.fieldInitializer = field.getInitializer() != null ? field.getInitializer().toString() : null;
        for (ASMetaTag metaTag : field.getAllMetaTags()) {
            this.metaTags.add(new As3ParserMetaTagMetadata(metaTag));
        }
    }

    @Override
    public String getDeclaredByMetadataId() {
        return this.declaredByMetadataId;
    }

    @Override
    public ActionScriptSymbolName getFieldName() {
        return this.fieldName;
    }

    @Override
    public ActionScriptType getFieldType() {
        return this.fieldType;
    }

    @Override
    public List<ASMetaTagMetadata> getMetaTags() {
        return this.metaTags;
    }

    @Override
    public ASTypeVisibility getVisibility() {
        return this.visibility;
    }

    @Override
    public String getFieldInitializer() {
        return this.fieldInitializer;
    }

    public static void addField(CompilationUnitServices compilationUnitServices, ASClassType clazz, ASFieldMetadata field, boolean permitFlush) {
        Validate.notNull((Object)compilationUnitServices, (String)"Compilation unit services required", (Object[])new Object[0]);
        Validate.notNull((Object)clazz, (String)"Class required", (Object[])new Object[0]);
        Validate.notNull((Object)field, (String)"Field required", (Object[])new Object[0]);
        As3ParserUtils.importTypeIfRequired(compilationUnitServices, field.getFieldType());
        ASField newField = clazz.newField(field.getFieldName().getSymbolName(), As3ParserUtils.getAs3ParserVisiblity(field.getVisibility()), field.getFieldType().getSimpleTypeName());
        if (field.getFieldInitializer() != null) {
            newField.setInitializer(field.getFieldInitializer());
        }
        for (ASMetaTagMetadata metaTag : field.getMetaTags()) {
            As3ParserMetaTagMetadata.addMetaTagToElement(compilationUnitServices, metaTag, newField, false);
        }
        if (permitFlush) {
            compilationUnitServices.flush();
        }
    }

    public static void updateField(CompilationUnitServices compilationUnitServices, ASClassType clazz, ASFieldMetadata field, boolean permitFlush) {
        Validate.notNull((Object)compilationUnitServices, (String)"Compilation unit services required", (Object[])new Object[0]);
        Validate.notNull((Object)clazz, (String)"Class required", (Object[])new Object[0]);
        Validate.notNull((Object)field, (String)"Field required", (Object[])new Object[0]);
        As3ParserUtils.importTypeIfRequired(compilationUnitServices, field.getFieldType());
        ASField existingField = clazz.getField(field.getFieldName().getSymbolName());
        existingField.setVisibility(As3ParserUtils.getAs3ParserVisiblity(field.getVisibility()));
        existingField.setType(field.getFieldType().getSimpleTypeName());
        if (field.getFieldInitializer() != null) {
            existingField.setInitializer(field.getFieldInitializer());
        }
        for (ASMetaTagMetadata metaTag : field.getMetaTags()) {
            if (existingField.getFirstMetatag(metaTag.getName()) == null) continue;
            As3ParserMetaTagMetadata.addMetaTagToElement(compilationUnitServices, metaTag, existingField, false);
        }
    }

    public static void removeField(CompilationUnitServices compilationUnitServices, ASClassType clazz, ActionScriptSymbolName fieldName, boolean permitFlush) {
        Validate.notNull((Object)compilationUnitServices, (String)"Compilation unit services required", (Object[])new Object[0]);
        Validate.notNull((Object)clazz, (String)"Class required", (Object[])new Object[0]);
        Validate.notNull((Object)fieldName, (String)"Field name required", (Object[])new Object[0]);
        Validate.notNull((Object)clazz.getField(fieldName.getSymbolName()), (String)("Could not locate field '" + fieldName + "' to delete"), (Object[])new Object[0]);
        clazz.removeField(fieldName.getSymbolName());
        if (permitFlush) {
            compilationUnitServices.flush();
        }
    }

    private void setDeclaredByMetadataId(String declaredByMetadataId) {
        this.declaredByMetadataId = declaredByMetadataId;
    }

    private void setFieldName(ActionScriptSymbolName fieldName) {
        this.fieldName = fieldName;
    }
}

