/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.as.classpath.as3parser.details;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.gvnix.flex.addon.metaas.dom.ASMetaTag;
import org.gvnix.flex.addon.metaas.dom.MetaTagable;
import org.gvnix.flex.as.classpath.as3parser.As3ParserUtils;
import org.gvnix.flex.as.classpath.as3parser.CompilationUnitServices;
import org.gvnix.flex.as.classpath.details.metatag.ASMetaTagMetadata;
import org.gvnix.flex.as.classpath.details.metatag.BooleanAttributeValue;
import org.gvnix.flex.as.classpath.details.metatag.IntegerAttributeValue;
import org.gvnix.flex.as.classpath.details.metatag.MetaTagAttributeValue;
import org.gvnix.flex.as.classpath.details.metatag.StringAttributeValue;
import org.gvnix.flex.as.model.ActionScriptSymbolName;

public class As3ParserMetaTagMetadata
implements ASMetaTagMetadata {
    private final String name;
    private final Map<ActionScriptSymbolName, MetaTagAttributeValue<?>> attributes = new LinkedHashMap();

    public As3ParserMetaTagMetadata(ASMetaTag metaTag) {
        Validate.notNull((Object)metaTag, (String)"Meta Tag required", (Object[])new Object[0]);
        this.name = metaTag.getName();
        for (ASMetaTag.Param param : metaTag.getParams()) {
            MetaTagAttributeValue<?> attr = As3ParserUtils.getMetaTagAttributeValue(param);
            this.attributes.put(attr.getName(), attr);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MetaTagAttributeValue<?> getAttribute(ActionScriptSymbolName attributeName) {
        Validate.notNull((Object)attributeName, (String)"Attribute name required", (Object[])new Object[0]);
        return this.attributes.get(attributeName);
    }

    @Override
    public List<ActionScriptSymbolName> getAttributeNames() {
        return new ArrayList<ActionScriptSymbolName>(this.attributes.keySet());
    }

    public static void addMetaTagToElement(CompilationUnitServices compilationUnitServices, ASMetaTagMetadata metaTag, MetaTagable element, boolean permitFlush) {
        Validate.notNull((Object)compilationUnitServices, (String)"Compilation unit services required", (Object[])new Object[0]);
        Validate.notNull((Object)metaTag, (String)"Metatag required", (Object[])new Object[0]);
        Validate.notNull((Object)element, (String)"Element required", (Object[])new Object[0]);
        for (ASMetaTag existingTag : element.getAllMetaTags()) {
            Validate.isTrue((!metaTag.getName().equals(existingTag.getName()) ? 1 : 0) != 0, (String)("Found an existing meta tag of type '" + metaTag.getName() + "'"), (Object[])new Object[0]);
        }
        ASMetaTag newMetaTag = element.newMetaTag(metaTag.getName());
        for (ActionScriptSymbolName attrName : metaTag.getAttributeNames()) {
            MetaTagAttributeValue<?> value = metaTag.getAttribute(attrName);
            if (value instanceof BooleanAttributeValue) {
                newMetaTag.addParam(attrName.getSymbolName(), ((BooleanAttributeValue)value).getValue());
                continue;
            }
            if (value instanceof IntegerAttributeValue) {
                newMetaTag.addParam(attrName.getSymbolName(), ((IntegerAttributeValue)value).getValue());
                continue;
            }
            if (value instanceof StringAttributeValue) {
                newMetaTag.addParam(attrName.getSymbolName(), ((StringAttributeValue)value).getValue());
                continue;
            }
            throw new IllegalArgumentException("Cannot add uknown meta tag attribute type.");
        }
        if (permitFlush) {
            compilationUnitServices.flush();
        }
    }

    public static void removeMetatagFromElement(CompilationUnitServices compilationUnitServices, MetaTagable element, String name, boolean permitFlush) {
        Validate.notNull((Object)compilationUnitServices, (String)"Compilation unit services required", (Object[])new Object[0]);
        Validate.notNull((Object)name, (String)"Name required", (Object[])new Object[0]);
        Validate.notNull((Object)element, (String)"Element required", (Object[])new Object[0]);
        ASMetaTag tag = element.getFirstMetatag(name);
        Validate.notNull((Object)tag, (String)("Could not locate metatag '" + name + "' to delete"), (Object[])new Object[0]);
        element.getAllMetaTags().remove(tag);
        if (permitFlush) {
            compilationUnitServices.flush();
        }
    }
}

