/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.as.classpath.as3parser.details;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.gvnix.flex.addon.metaas.dom.ASArg;
import org.gvnix.flex.addon.metaas.dom.ASMetaTag;
import org.gvnix.flex.addon.metaas.dom.ASMethod;
import org.gvnix.flex.addon.metaas.dom.ASType;
import org.gvnix.flex.addon.metaas.dom.Statement;
import org.gvnix.flex.as.classpath.as3parser.As3ParserUtils;
import org.gvnix.flex.as.classpath.as3parser.CompilationUnitServices;
import org.gvnix.flex.as.classpath.as3parser.details.As3ParserMetaTagMetadata;
import org.gvnix.flex.as.classpath.details.ASMethodMetadata;
import org.gvnix.flex.as.classpath.details.metatag.ASMetaTagMetadata;
import org.gvnix.flex.as.model.ASTypeVisibility;
import org.gvnix.flex.as.model.ActionScriptSymbolName;
import org.gvnix.flex.as.model.ActionScriptType;

public class As3ParserMethodMetadata
implements ASMethodMetadata {
    private final ActionScriptSymbolName methodName;
    private final ActionScriptType returnType;
    private final String declaredByMetadataId;
    private final List<ASMetaTagMetadata> metaTags = new ArrayList<ASMetaTagMetadata>();
    private String body = "";
    private final Map<ActionScriptSymbolName, ActionScriptType> params = new LinkedHashMap<ActionScriptSymbolName, ActionScriptType>();
    private final ASTypeVisibility visibility;

    public As3ParserMethodMetadata(String declaredByMetadataId, ASMethod method, CompilationUnitServices compilationUnitServices) {
        Validate.notNull((Object)declaredByMetadataId, (String)"Declared by metadata ID required", (Object[])new Object[0]);
        Validate.notNull((Object)method, (String)"Method declaration required", (Object[])new Object[0]);
        Validate.notNull((Object)compilationUnitServices, (String)"Compilation unit services required", (Object[])new Object[0]);
        this.declaredByMetadataId = declaredByMetadataId;
        this.methodName = new ActionScriptSymbolName(method.getName());
        this.returnType = As3ParserUtils.getActionScriptType(compilationUnitServices.getCompilationUnitPackage(), compilationUnitServices.getImports(), method.getType());
        this.visibility = As3ParserUtils.getASTypeVisibility(method.getVisibility());
        List metaTagList = method.getAllMetaTags();
        if (metaTagList != null) {
            for (ASMetaTag metaTag : metaTagList) {
                As3ParserMetaTagMetadata md = new As3ParserMetaTagMetadata(metaTag);
                this.metaTags.add(md);
            }
        }
        List statements = method.getStatementList();
        for (Statement statement : statements) {
            this.body = this.body + statement.toString();
        }
        List args = method.getArgs();
        for (ASArg arg : args) {
            ActionScriptType paramType = As3ParserUtils.getActionScriptType(compilationUnitServices.getCompilationUnitPackage(), compilationUnitServices.getImports(), arg.getType());
            this.params.put(new ActionScriptSymbolName(arg.getName()), paramType);
        }
    }

    @Override
    public ActionScriptSymbolName getMethodName() {
        return this.methodName;
    }

    @Override
    public ActionScriptType getReturnType() {
        return this.returnType;
    }

    @Override
    public List<ASMetaTagMetadata> getMetaTags() {
        return this.metaTags;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public List<ActionScriptSymbolName> getParameterNames() {
        return new ArrayList<ActionScriptSymbolName>(this.params.keySet());
    }

    @Override
    public List<ActionScriptType> getParameterTypes() {
        return new ArrayList<ActionScriptType>(this.params.values());
    }

    @Override
    public String getDeclaredByMetadataId() {
        return this.declaredByMetadataId;
    }

    @Override
    public ASTypeVisibility getVisibility() {
        return this.visibility;
    }

    public static void addMethod(CompilationUnitServices compilationUnitServices, ASType type, ASMethodMetadata declaredMethod, boolean permitFlush) {
        Validate.isTrue((type.getMethod(declaredMethod.getMethodName().getSymbolName()) == null ? 1 : 0) != 0, (String)("Method with name " + declaredMethod.getMethodName().getSymbolName() + " already exists and ActionScript does not allow method overloading."), (Object[])new Object[0]);
        As3ParserUtils.importTypeIfRequired(compilationUnitServices, declaredMethod.getReturnType());
        ASMethod method = type.newMethod(declaredMethod.getMethodName().getSymbolName(), As3ParserUtils.getAs3ParserVisiblity(declaredMethod.getVisibility()), declaredMethod.getReturnType().getSimpleTypeName());
        for (ASMetaTagMetadata metaTag : declaredMethod.getMetaTags()) {
            As3ParserMetaTagMetadata.addMetaTagToElement(compilationUnitServices, metaTag, method, false);
        }
        for (int x = 0; x < declaredMethod.getParameterNames().size(); ++x) {
            ActionScriptSymbolName argName = declaredMethod.getParameterNames().get(x);
            ActionScriptType argType = declaredMethod.getParameterTypes().get(x);
            As3ParserUtils.importTypeIfRequired(compilationUnitServices, argType);
            method.addParam(argName.getSymbolName(), argType.getSimpleTypeName());
        }
        if (permitFlush) {
            compilationUnitServices.flush();
        }
    }
}

