/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.as.model;

import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvnix.flex.as.classpath.details.ASFieldMetadata;
import org.gvnix.flex.as.classpath.details.DefaultASFieldMetadata;
import org.gvnix.flex.as.model.ASDataType;
import org.gvnix.flex.as.model.ASTypeVisibility;
import org.gvnix.flex.as.model.ActionScriptPackage;
import org.gvnix.flex.as.model.ActionScriptSymbolName;
import org.gvnix.flex.as.model.ActionScriptType;
import org.springframework.roo.classpath.details.FieldMetadata;
import org.springframework.roo.classpath.details.FieldMetadataBuilder;
import org.springframework.roo.classpath.details.annotations.AnnotationMetadata;
import org.springframework.roo.model.DataType;
import org.springframework.roo.model.JavaPackage;
import org.springframework.roo.model.JavaSymbolName;
import org.springframework.roo.model.JavaType;

public abstract class ActionScriptMappingUtils {
    private static final Map<JavaType, ActionScriptType> javaToAmfTypeMap = new HashMap<JavaType, ActionScriptType>();
    private static final Map<ActionScriptType, JavaType> amfToJavaTypeMap = new HashMap<ActionScriptType, JavaType>();

    public static ActionScriptType toActionScriptType(FieldMetadata javaField) {
        ActionScriptType asType = ActionScriptMappingUtils.toActionScriptType(javaField.getFieldType());
        if (asType.isNumeric()) {
            boolean isVersion = false;
            for (AnnotationMetadata annotation : javaField.getAnnotations()) {
                if (!annotation.getAnnotationType().getFullyQualifiedTypeName().equals("javax.persistence.Version")) continue;
                isVersion = true;
            }
            if (isVersion) {
                return ActionScriptType.NUMBER_TYPE;
            }
        }
        return asType;
    }

    public static ActionScriptType toActionScriptType(JavaType javaType) {
        if (javaToAmfTypeMap.containsKey(javaType)) {
            return javaToAmfTypeMap.get(javaType);
        }
        if (javaType.isCommonCollectionType()) {
            if (javaType.getSimpleTypeName().endsWith("Map")) {
                if (javaType.isArray()) {
                    return ActionScriptType.ARRAY_TYPE;
                }
                return ActionScriptType.OBJECT_TYPE;
            }
            return new ActionScriptType("mx.collections.ArrayCollection");
        }
        return new ActionScriptType(javaType.getFullyQualifiedTypeName(), javaType.isArray() ? 1 : 0, ASDataType.TYPE);
    }

    public static JavaType toJavaType(ActionScriptType asType) {
        if (amfToJavaTypeMap.containsKey(asType)) {
            return amfToJavaTypeMap.get(asType);
        }
        return new JavaType(asType.getFullyQualifiedTypeName());
    }

    public static ActionScriptSymbolName toActionScriptSymbolName(JavaSymbolName name) {
        return new ActionScriptSymbolName(name.getSymbolName());
    }

    private static JavaSymbolName toJavaSymbolName(ActionScriptSymbolName fieldName) {
        return new JavaSymbolName(fieldName.getSymbolName());
    }

    public static ActionScriptPackage toActionScriptPackage(JavaPackage javaPackage) {
        return new ActionScriptPackage(javaPackage.getFullyQualifiedPackageName());
    }

    public static JavaPackage toJavaPackage(ActionScriptPackage asPackage) {
        return new JavaPackage(asPackage.getFullyQualifiedPackageName());
    }

    public static ASTypeVisibility toASTypeVisibility(int mod) {
        if (Modifier.isPublic(mod)) {
            return ASTypeVisibility.PUBLIC;
        }
        if (Modifier.isProtected(mod)) {
            return ASTypeVisibility.PROTECTED;
        }
        if (Modifier.isPrivate(mod)) {
            return ASTypeVisibility.PRIVATE;
        }
        return ASTypeVisibility.DEFAULT;
    }

    private static int toJavaModifier(ASTypeVisibility visibility) {
        switch (visibility) {
            case PUBLIC: {
                return 1;
            }
            case PRIVATE: {
                return 2;
            }
            case PROTECTED: {
                return 4;
            }
            case INTERNAL: {
                return 2;
            }
        }
        return 0;
    }

    public static ASFieldMetadata toASFieldMetadata(String asEntityId, FieldMetadata javaField, boolean makePublic) {
        return new DefaultASFieldMetadata(asEntityId, ActionScriptMappingUtils.toActionScriptType(javaField), ActionScriptMappingUtils.toActionScriptSymbolName(javaField.getFieldName()), makePublic ? ASTypeVisibility.PUBLIC : ActionScriptMappingUtils.toASTypeVisibility(javaField.getModifier()), null, null);
    }

    public static FieldMetadata toFieldMetadata(String javaEntityId, ASFieldMetadata asField, boolean makePrivate) {
        return new FieldMetadataBuilder(javaEntityId, makePrivate ? 2 : ActionScriptMappingUtils.toJavaModifier(asField.getVisibility()), ActionScriptMappingUtils.toJavaSymbolName(asField.getFieldName()), ActionScriptMappingUtils.toJavaType(asField.getFieldType()), null).build();
    }

    public static boolean isMappableType(ActionScriptType fieldType) {
        if (ActionScriptType.isImplicitType(fieldType.getFullyQualifiedTypeName())) {
            return false;
        }
        return !fieldType.getFullyQualifiedTypeName().startsWith("flash.") && !fieldType.getFullyQualifiedTypeName().startsWith("mx.");
    }

    static {
        javaToAmfTypeMap.put(new JavaType(Enum.class.getName()), ActionScriptType.STRING_TYPE);
        javaToAmfTypeMap.put(JavaType.STRING_OBJECT, ActionScriptType.STRING_TYPE);
        javaToAmfTypeMap.put(JavaType.BOOLEAN_OBJECT, ActionScriptType.BOOLEAN_TYPE);
        javaToAmfTypeMap.put(JavaType.BOOLEAN_PRIMITIVE, ActionScriptType.BOOLEAN_TYPE);
        javaToAmfTypeMap.put(JavaType.INT_OBJECT, ActionScriptType.INT_TYPE);
        javaToAmfTypeMap.put(JavaType.INT_PRIMITIVE, ActionScriptType.INT_TYPE);
        javaToAmfTypeMap.put(JavaType.SHORT_OBJECT, ActionScriptType.INT_TYPE);
        javaToAmfTypeMap.put(JavaType.SHORT_PRIMITIVE, ActionScriptType.INT_TYPE);
        javaToAmfTypeMap.put(JavaType.BYTE_OBJECT, ActionScriptType.INT_TYPE);
        javaToAmfTypeMap.put(new JavaType(Byte.class.getName(), 1, DataType.PRIMITIVE, null, null), ActionScriptType.INT_TYPE);
        javaToAmfTypeMap.put(new JavaType(Byte.class.getName(), 1, DataType.TYPE, null, null), new ActionScriptType("flash.utils.ByteArray"));
        javaToAmfTypeMap.put(JavaType.DOUBLE_OBJECT, ActionScriptType.NUMBER_TYPE);
        javaToAmfTypeMap.put(JavaType.DOUBLE_PRIMITIVE, ActionScriptType.NUMBER_TYPE);
        javaToAmfTypeMap.put(JavaType.LONG_OBJECT, ActionScriptType.NUMBER_TYPE);
        javaToAmfTypeMap.put(JavaType.LONG_PRIMITIVE, ActionScriptType.NUMBER_TYPE);
        javaToAmfTypeMap.put(JavaType.FLOAT_OBJECT, ActionScriptType.NUMBER_TYPE);
        javaToAmfTypeMap.put(JavaType.FLOAT_PRIMITIVE, ActionScriptType.NUMBER_TYPE);
        javaToAmfTypeMap.put(JavaType.CHAR_OBJECT, ActionScriptType.STRING_TYPE);
        javaToAmfTypeMap.put(JavaType.CHAR_PRIMITIVE, ActionScriptType.STRING_TYPE);
        javaToAmfTypeMap.put(new JavaType(Character.class.getName(), 1, DataType.TYPE, null, null), ActionScriptType.STRING_TYPE);
        javaToAmfTypeMap.put(new JavaType(Character.class.getName(), 1, DataType.PRIMITIVE, null, null), ActionScriptType.STRING_TYPE);
        javaToAmfTypeMap.put(new JavaType(BigInteger.class.getName(), 0, DataType.TYPE, null, null), ActionScriptType.STRING_TYPE);
        javaToAmfTypeMap.put(new JavaType(BigDecimal.class.getName(), 0, DataType.TYPE, null, null), ActionScriptType.STRING_TYPE);
        javaToAmfTypeMap.put(new JavaType(Calendar.class.getName(), 0, DataType.TYPE, null, null), ActionScriptType.DATE_TYPE);
        javaToAmfTypeMap.put(new JavaType(Date.class.getName(), 0, DataType.TYPE, null, null), ActionScriptType.DATE_TYPE);
        amfToJavaTypeMap.put(ActionScriptType.STRING_TYPE, JavaType.STRING_OBJECT);
        amfToJavaTypeMap.put(ActionScriptType.BOOLEAN_TYPE, JavaType.BOOLEAN_OBJECT);
        amfToJavaTypeMap.put(ActionScriptType.INT_TYPE, JavaType.INT_OBJECT);
        amfToJavaTypeMap.put(ActionScriptType.NUMBER_TYPE, JavaType.DOUBLE_OBJECT);
        amfToJavaTypeMap.put(ActionScriptType.DATE_TYPE, new JavaType(Date.class.getName(), 0, DataType.TYPE, null, null));
        amfToJavaTypeMap.put(new ActionScriptType("flash.utils.ByteArray"), new JavaType(Byte.class.getName(), 1, DataType.TYPE, null, null));
        amfToJavaTypeMap.put(new ActionScriptType("mx.collections.ArrayCollection"), new JavaType(List.class.getName(), 0, DataType.TYPE, null, null));
        amfToJavaTypeMap.put(ActionScriptType.ARRAY_TYPE, new JavaType(List.class.getName(), 0, DataType.TYPE, null, null));
        amfToJavaTypeMap.put(ActionScriptType.OBJECT_TYPE, new JavaType(Map.class.getName(), 0, DataType.TYPE, null, null));
    }
}

