/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.as.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class ActionScriptSymbolName
implements Comparable<ActionScriptSymbolName> {
    private final String symbolName;

    public ActionScriptSymbolName(String symbolName) {
        StringUtils.isNotBlank((CharSequence)symbolName);
        ActionScriptSymbolName.assertActionScriptNameLegal(symbolName);
        this.symbolName = symbolName;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public String getSymbolNameCapitalisedFirstLetter() {
        return StringUtils.capitalize((String)this.symbolName);
    }

    public String getReadableSymbolName() {
        Pattern p = Pattern.compile("[A-Z][^A-Z]*");
        Matcher m = p.matcher(StringUtils.capitalize((String)this.symbolName));
        StringBuilder string = new StringBuilder();
        while (m.find()) {
            string.append(m.group()).append(" ");
        }
        return string.toString().trim();
    }

    public final int hashCode() {
        return this.symbolName.hashCode();
    }

    public final boolean equals(Object obj) {
        return obj != null && obj instanceof ActionScriptSymbolName && this.symbolName.equals(((ActionScriptSymbolName)obj).symbolName);
    }

    @Override
    public final int compareTo(ActionScriptSymbolName o) {
        if (o == null) {
            return -1;
        }
        return this.symbolName.compareTo(o.symbolName);
    }

    public final String toString() {
        return this.symbolName;
    }

    public static void assertActionScriptNameLegal(String fullyQualifiedTypeName) {
    }
}

