/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.entity;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.gvnix.flex.as.classpath.ASMutablePhysicalTypeMetadataProvider;
import org.gvnix.flex.as.classpath.ASPhysicalTypeCategory;
import org.gvnix.flex.as.classpath.ASPhysicalTypeIdentifier;
import org.gvnix.flex.as.classpath.ASPhysicalTypeMetadata;
import org.gvnix.flex.as.classpath.details.ASFieldMetadata;
import org.gvnix.flex.as.classpath.details.ASMutableClassOrInterfaceTypeDetails;
import org.gvnix.flex.as.classpath.details.DefaultASClassOrInterfaceTypeDetails;
import org.gvnix.flex.as.classpath.details.DefaultASPhysicalTypeMetadata;
import org.gvnix.flex.as.classpath.details.metatag.ASMetaTagMetadata;
import org.gvnix.flex.as.classpath.details.metatag.DefaultASMetaTagMetadata;
import org.gvnix.flex.as.classpath.details.metatag.MetaTagAttributeValue;
import org.gvnix.flex.as.classpath.details.metatag.StringAttributeValue;
import org.gvnix.flex.as.model.ActionScriptMappingUtils;
import org.gvnix.flex.as.model.ActionScriptSymbolName;
import org.gvnix.flex.as.model.ActionScriptType;
import org.gvnix.flex.entity.ActionScriptEntityMetadata;
import org.gvnix.flex.entity.TypeMapping;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.springframework.roo.classpath.PhysicalTypeIdentifier;
import org.springframework.roo.classpath.PhysicalTypeMetadata;
import org.springframework.roo.classpath.TypeManagementService;
import org.springframework.roo.classpath.details.BeanInfoUtils;
import org.springframework.roo.classpath.details.ClassOrInterfaceTypeDetails;
import org.springframework.roo.classpath.details.ClassOrInterfaceTypeDetailsBuilder;
import org.springframework.roo.classpath.details.FieldMetadata;
import org.springframework.roo.classpath.details.FieldMetadataBuilder;
import org.springframework.roo.classpath.details.MemberFindingUtils;
import org.springframework.roo.classpath.details.MethodMetadata;
import org.springframework.roo.classpath.scanner.MemberDetails;
import org.springframework.roo.classpath.scanner.MemberDetailsScanner;
import org.springframework.roo.metadata.MetadataDependencyRegistry;
import org.springframework.roo.metadata.MetadataIdentificationUtils;
import org.springframework.roo.metadata.MetadataItem;
import org.springframework.roo.metadata.MetadataNotificationListener;
import org.springframework.roo.metadata.MetadataProvider;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.model.JavaSymbolName;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.project.LogicalPath;
import org.springframework.roo.project.Path;
import org.springframework.roo.project.PathResolver;
import org.springframework.roo.support.logging.HandlerUtils;
import org.springframework.roo.support.util.CollectionUtils;

@Component
@Service
public class ActionScriptEntityMetadataProvider
implements MetadataProvider,
MetadataNotificationListener {
    protected static final Logger LOGGER = HandlerUtils.getLogger(ActionScriptEntityMetadataProvider.class);
    private BundleContext context;
    private static final String REMOTE_CLASS_TAG = "RemoteClass";
    private static final String ALIAS_ATTR = "alias";
    private PathResolver pathResolver;
    private MetadataService metadataService;
    private MetadataDependencyRegistry metadataDependencyRegistry;
    private ASMutablePhysicalTypeMetadataProvider asPhysicalTypeProvider;
    protected MemberDetailsScanner memberDetailsScanner;
    protected TypeManagementService typeManagementService;

    protected void activate(ComponentContext cContext) {
        this.context = cContext.getBundleContext();
        this.getMetadataDependencyRegistry().registerDependency(PhysicalTypeIdentifier.getMetadataIdentiferType(), this.getProvidesType());
        this.getMetadataDependencyRegistry().registerDependency(ASPhysicalTypeIdentifier.getMetadataIdentiferType(), this.getProvidesType());
    }

    protected void deactivate(ComponentContext context) {
        this.getMetadataDependencyRegistry().deregisterDependency(PhysicalTypeIdentifier.getMetadataIdentiferType(), this.getProvidesType());
        this.getMetadataDependencyRegistry().deregisterDependency(ASPhysicalTypeIdentifier.getMetadataIdentiferType(), this.getProvidesType());
    }

    public MetadataItem get(String metadataId) {
        JavaType javaType = ActionScriptEntityMetadata.getJavaType(metadataId);
        ActionScriptType asType = ActionScriptMappingUtils.toActionScriptType(javaType);
        String asEntityId = this.getAsPhysicalTypeProvider().findIdentifier(asType);
        if (StringUtils.isNotBlank((CharSequence)asEntityId)) {
            return new ActionScriptEntityMetadata(metadataId, asType, javaType);
        }
        asEntityId = ASPhysicalTypeIdentifier.createIdentifier(asType, "src/main/flex");
        this.createActionScriptMirrorClass(asEntityId, asType, javaType);
        ActionScriptEntityMetadata asEntityMetadata = new ActionScriptEntityMetadata(metadataId, asType, javaType);
        return asEntityMetadata;
    }

    public String getProvidesType() {
        return ActionScriptEntityMetadata.getMetadataIdentiferType();
    }

    public void notify(String upstreamDependency, String downstreamDependency) {
        if (MetadataIdentificationUtils.getMetadataClass((String)upstreamDependency).equals(MetadataIdentificationUtils.getMetadataClass((String)PhysicalTypeIdentifier.getMetadataIdentiferType()))) {
            this.processJavaTypeChanged(upstreamDependency);
        } else if (MetadataIdentificationUtils.getMetadataClass((String)upstreamDependency).equals(MetadataIdentificationUtils.getMetadataClass((String)ASPhysicalTypeIdentifier.getMetadataIdentiferType()))) {
            this.processActionScriptTypeChanged(upstreamDependency);
        }
    }

    private void createActionScriptMirrorClass(String asEntityId, ActionScriptType asType, JavaType javaType) {
        LinkedList<TypeMapping> relatedTypes = new LinkedList<TypeMapping>();
        ArrayList attributes = new ArrayList();
        attributes.add(new StringAttributeValue(new ActionScriptSymbolName(ALIAS_ATTR), javaType.getFullyQualifiedTypeName()));
        DefaultASMetaTagMetadata remoteClassTag = new DefaultASMetaTagMetadata(REMOTE_CLASS_TAG, attributes);
        ArrayList<ASMetaTagMetadata> typeMetaTags = new ArrayList<ASMetaTagMetadata>();
        typeMetaTags.add(remoteClassTag);
        ArrayList<ASFieldMetadata> declaredFields = new ArrayList<ASFieldMetadata>();
        MemberDetails memberDetails = this.getMemberDetails(javaType);
        for (MethodMetadata method : MemberFindingUtils.getMethods((MemberDetails)memberDetails)) {
            if (!BeanInfoUtils.isAccessorMethod((MethodMetadata)method)) continue;
            JavaSymbolName propertyName = BeanInfoUtils.getPropertyNameForJavaBeanMethod((MethodMetadata)method);
            FieldMetadata javaField = BeanInfoUtils.getFieldForPropertyName((MemberDetails)memberDetails, (JavaSymbolName)propertyName);
            ASFieldMetadata asField = ActionScriptMappingUtils.toASFieldMetadata(asEntityId, javaField, true);
            relatedTypes.addAll(this.findRequiredMappings(javaField, asField));
            declaredFields.add(asField);
        }
        DefaultASClassOrInterfaceTypeDetails asDetails = new DefaultASClassOrInterfaceTypeDetails(asEntityId, asType, ASPhysicalTypeCategory.CLASS, declaredFields, null, null, null, null, null, typeMetaTags);
        DefaultASPhysicalTypeMetadata asMetadata = new DefaultASPhysicalTypeMetadata(asEntityId, this.getPhysicalLocationCanonicalPath(asEntityId), asDetails);
        this.getAsPhysicalTypeProvider().createPhysicalType(asMetadata);
        while (!relatedTypes.isEmpty()) {
            TypeMapping mapping = (TypeMapping)relatedTypes.poll();
            this.createActionScriptMirrorClass(mapping.getMetadataId(), mapping.getAsType(), mapping.getJavaType());
        }
    }

    private ClassOrInterfaceTypeDetails getClassDetails(String metadataId) {
        PhysicalTypeMetadata metadata = (PhysicalTypeMetadata)this.getMetadataService().get(metadataId);
        if (metadata == null) {
            return null;
        }
        Validate.isInstanceOf(ClassOrInterfaceTypeDetails.class, (Object)metadata.getMemberHoldingTypeDetails(), (String)"Java entity must be a class or interface.", (Object[])new Object[0]);
        return (ClassOrInterfaceTypeDetails)metadata.getMemberHoldingTypeDetails();
    }

    private ASMutableClassOrInterfaceTypeDetails getASClassDetails(String metadataId) {
        ASPhysicalTypeMetadata metadata = (ASPhysicalTypeMetadata)this.getMetadataService().get(metadataId);
        if (metadata == null) {
            return null;
        }
        Validate.isInstanceOf(ASMutableClassOrInterfaceTypeDetails.class, (Object)metadata.getPhysicalTypeDetails(), (String)"ActionScript entity must be a class or interface.", (Object[])new Object[0]);
        return (ASMutableClassOrInterfaceTypeDetails)metadata.getPhysicalTypeDetails();
    }

    private String getPhysicalLocationCanonicalPath(String physicalTypeIdentifier) {
        Validate.isTrue((boolean)ASPhysicalTypeIdentifier.isValid(physicalTypeIdentifier), (String)"Physical type identifier is invalid", (Object[])new Object[0]);
        Validate.notNull((Object)this.getPathResolver(), (String)"Cannot computed metadata ID of a type because the path resolver is presently unavailable", (Object[])new Object[0]);
        ActionScriptType asType = ASPhysicalTypeIdentifier.getActionScriptType(physicalTypeIdentifier);
        LogicalPath path = ASPhysicalTypeIdentifier.getPath(physicalTypeIdentifier);
        String relativePath = asType.getFullyQualifiedTypeName().replace('.', File.separatorChar) + ".as";
        String physicalLocationCanonicalPath = this.getPathResolver().getIdentifier(path, "src/main/flex/" + relativePath);
        return physicalLocationCanonicalPath;
    }

    private void processActionScriptTypeChanged(String asEntityId) {
        ArrayList<String> processedFields = new ArrayList<String>();
        ActionScriptType asType = ASPhysicalTypeIdentifier.getActionScriptType(asEntityId);
        JavaType javaType = ActionScriptMappingUtils.toJavaType(asType);
        String javaEntityId = PhysicalTypeIdentifier.createIdentifier((JavaType)javaType, (LogicalPath)LogicalPath.getInstance((Path)Path.SRC_MAIN_JAVA, (String)""));
        ClassOrInterfaceTypeDetails javaTypeDetails = this.getClassDetails(javaEntityId);
        if (javaTypeDetails == null) {
            return;
        }
        ASMutableClassOrInterfaceTypeDetails asTypeDetails = this.getASClassDetails(asEntityId);
        if (asTypeDetails == null) {
            return;
        }
        if (!this.isRemotingClass(javaType, asTypeDetails)) {
            return;
        }
        ArrayList<String> javaFieldNames = new ArrayList<String>();
        for (FieldMetadata javaField : javaTypeDetails.getDeclaredFields()) {
            javaFieldNames.add(javaField.getFieldName().getSymbolName());
        }
        ArrayList<String> javaPropertyNames = new ArrayList<String>();
        MemberDetails memberDetails = this.scanForMemberDetails(javaTypeDetails);
        for (MethodMetadata method : MemberFindingUtils.getMethods((MemberDetails)memberDetails)) {
            if (!BeanInfoUtils.isAccessorMethod((MethodMetadata)method)) continue;
            javaPropertyNames.add(StringUtils.uncapitalize((String)BeanInfoUtils.getPropertyNameForJavaBeanMethod((MethodMetadata)method).getSymbolName()));
        }
        ClassOrInterfaceTypeDetailsBuilder mutableTypeDetailsBuilder = new ClassOrInterfaceTypeDetailsBuilder(javaTypeDetails);
        ArrayList<FieldMetadataBuilder> fields = new ArrayList<FieldMetadataBuilder>();
        for (ASFieldMetadata asField : asTypeDetails.getDeclaredFields()) {
            String fieldName = asField.getFieldName().getSymbolName();
            if (!javaPropertyNames.contains(fieldName)) {
                fields.add(new FieldMetadataBuilder(ActionScriptMappingUtils.toFieldMetadata(javaEntityId, asField, true)));
            }
            processedFields.add(fieldName);
        }
        for (String javaFieldName : javaFieldNames) {
            if (processedFields.contains(javaFieldName)) continue;
            for (FieldMetadataBuilder fieldMetadata : fields) {
                if (!fieldMetadata.getFieldName().getSymbolName().equals(javaFieldName)) continue;
                fields.remove(fieldMetadata);
            }
        }
        fields.addAll(mutableTypeDetailsBuilder.getDeclaredFields());
        mutableTypeDetailsBuilder.setDeclaredFields(fields);
        this.getTypeManagementService().createOrUpdateTypeOnDisk(mutableTypeDetailsBuilder.build());
    }

    private void processJavaTypeChanged(String javaEntityId) {
        LinkedList<TypeMapping> relatedTypes = new LinkedList<TypeMapping>();
        ArrayList<ASFieldMetadata> processedProperties = new ArrayList<ASFieldMetadata>();
        JavaType javaType = PhysicalTypeIdentifier.getJavaType((String)javaEntityId);
        ActionScriptType asType = ActionScriptMappingUtils.toActionScriptType(javaType);
        String asEntityId = ASPhysicalTypeIdentifier.createIdentifier(asType, "src/main/flex");
        ASMutableClassOrInterfaceTypeDetails asTypeDetails = this.getASClassDetails(asEntityId);
        if (asTypeDetails == null) {
            return;
        }
        if (!this.isRemotingClass(javaType, asTypeDetails)) {
            return;
        }
        List<ASFieldMetadata> declaredFields = asTypeDetails.getDeclaredFields();
        MemberDetails memberDetails = this.getMemberDetails(javaType);
        if (memberDetails == null) {
            return;
        }
        for (MethodMetadata method : MemberFindingUtils.getMethods((MemberDetails)memberDetails)) {
            if (!BeanInfoUtils.isMutatorMethod((MethodMetadata)method)) continue;
            JavaSymbolName propertyName = BeanInfoUtils.getPropertyNameForJavaBeanMethod((MethodMetadata)method);
            FieldMetadata javaField = BeanInfoUtils.getFieldForPropertyName((MemberDetails)memberDetails, (JavaSymbolName)propertyName);
            ASFieldMetadata asField = ActionScriptMappingUtils.toASFieldMetadata(asEntityId, javaField, true);
            int existingIndex = declaredFields.indexOf(asField);
            if (existingIndex > -1) {
                ASFieldMetadata existingField = declaredFields.get(existingIndex);
                if (!existingField.getFieldType().equals(asField.getFieldType())) {
                    asTypeDetails.updateField(asField, false);
                }
            } else {
                asTypeDetails.addField(asField, false);
            }
            relatedTypes.addAll(this.findRequiredMappings(javaField, asField));
            processedProperties.add(asField);
        }
        for (ASFieldMetadata asField : asTypeDetails.getDeclaredFields()) {
            if (processedProperties.contains(asField)) continue;
            asTypeDetails.removeField(asField.getFieldName());
        }
        asTypeDetails.commit();
        while (!relatedTypes.isEmpty()) {
            TypeMapping mapping = (TypeMapping)relatedTypes.poll();
            this.createActionScriptMirrorClass(mapping.getMetadataId(), mapping.getAsType(), mapping.getJavaType());
        }
    }

    private boolean isRemotingClass(JavaType javaType, ASMutableClassOrInterfaceTypeDetails asTypeDetails) {
        boolean isRemotingClass = false;
        for (ASMetaTagMetadata metaTag : asTypeDetails.getTypeMetaTags()) {
            MetaTagAttributeValue<?> value;
            if (!metaTag.getName().equals(REMOTE_CLASS_TAG) || (value = metaTag.getAttribute(new ActionScriptSymbolName(ALIAS_ATTR))) == null || !(value instanceof StringAttributeValue) || !javaType.getFullyQualifiedTypeName().equals(value.getValue())) continue;
            isRemotingClass = true;
            break;
        }
        return isRemotingClass;
    }

    private List<TypeMapping> findRequiredMappings(FieldMetadata javaField, ASFieldMetadata asField) {
        ArrayList<TypeMapping> relatedTypes;
        block3: {
            block2: {
                relatedTypes = new ArrayList<TypeMapping>();
                if (!ActionScriptMappingUtils.isMappableType(asField.getFieldType())) break block2;
                if (StringUtils.isNotBlank((CharSequence)this.getAsPhysicalTypeProvider().findIdentifier(asField.getFieldType()))) break block3;
                String relatedEntityId = ASPhysicalTypeIdentifier.createIdentifier(asField.getFieldType(), "src/main/flex");
                if (asField.getDeclaredByMetadataId().equals(relatedEntityId)) break block3;
                relatedTypes.add(new TypeMapping(relatedEntityId, asField.getFieldType(), javaField.getFieldType()));
                break block3;
            }
            if (javaField.getFieldType().isCommonCollectionType() && !CollectionUtils.isEmpty((Collection)javaField.getFieldType().getParameters())) {
                for (JavaType javaParamType : javaField.getFieldType().getParameters()) {
                    ActionScriptType asParamType = ActionScriptMappingUtils.toActionScriptType(javaParamType);
                    if (StringUtils.isNotBlank((CharSequence)this.getAsPhysicalTypeProvider().findIdentifier(asField.getFieldType()))) continue;
                    String relatedEntityId = ASPhysicalTypeIdentifier.createIdentifier(asParamType, "src/main/flex");
                    if (asField.getDeclaredByMetadataId().equals(relatedEntityId)) continue;
                    relatedTypes.add(new TypeMapping(relatedEntityId, asParamType, javaParamType));
                }
            }
        }
        return relatedTypes;
    }

    private MemberDetails getMemberDetails(JavaType entityType) {
        PhysicalTypeMetadata entityPhysicalTypeMetadata = (PhysicalTypeMetadata)this.getMetadataService().get(PhysicalTypeIdentifier.createIdentifier((JavaType)entityType, (LogicalPath)LogicalPath.getInstance((Path)Path.SRC_MAIN_JAVA, (String)"")));
        Validate.notNull((Object)entityPhysicalTypeMetadata, (String)("Unable to obtain physical type metdata for type " + entityType.getFullyQualifiedTypeName()), (Object[])new Object[0]);
        ClassOrInterfaceTypeDetails entityClassOrInterfaceDetails = (ClassOrInterfaceTypeDetails)entityPhysicalTypeMetadata.getMemberHoldingTypeDetails();
        return this.scanForMemberDetails(entityClassOrInterfaceDetails);
    }

    private MemberDetails scanForMemberDetails(ClassOrInterfaceTypeDetails entityClassOrInterfaceDetails) {
        return this.getMemberDetailsScanner().getMemberDetails(this.getClass().getName(), entityClassOrInterfaceDetails);
    }

    public MetadataDependencyRegistry getMetadataDependencyRegistry() {
        if (this.metadataDependencyRegistry == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(MetadataDependencyRegistry.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (MetadataDependencyRegistry)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load MetadataDependencyRegistry on ActionScriptEntityMetadataProvider.");
                return null;
            }
        }
        return this.metadataDependencyRegistry;
    }

    public PathResolver getPathResolver() {
        if (this.pathResolver == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(PathResolver.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (PathResolver)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load PathResolver on ActionScriptEntityMetadataProvider.");
                return null;
            }
        }
        return this.pathResolver;
    }

    public MetadataService getMetadataService() {
        if (this.metadataService == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(MetadataService.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (MetadataService)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load MetadataService on ActionScriptEntityMetadataProvider.");
                return null;
            }
        }
        return this.metadataService;
    }

    public ASMutablePhysicalTypeMetadataProvider getAsPhysicalTypeProvider() {
        if (this.asPhysicalTypeProvider == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(ASMutablePhysicalTypeMetadataProvider.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (ASMutablePhysicalTypeMetadataProvider)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load ASMutablePhysicalTypeMetadataProvider on ActionScriptEntityMetadataProvider.");
                return null;
            }
        }
        return this.asPhysicalTypeProvider;
    }

    public MemberDetailsScanner getMemberDetailsScanner() {
        if (this.memberDetailsScanner == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(MemberDetailsScanner.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (MemberDetailsScanner)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load MemberDetailsScanner on ActionScriptEntityMetadataProvider.");
                return null;
            }
        }
        return this.memberDetailsScanner;
    }

    public TypeManagementService getTypeManagementService() {
        if (this.typeManagementService == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(TypeManagementService.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (TypeManagementService)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load TypeManagementService on ActionScriptEntityMetadataProvider.");
                return null;
            }
        }
        return this.typeManagementService;
    }
}

