/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.ui;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.gvnix.flex.FlexOperations;
import org.gvnix.flex.FlexScaffoldMetadata;
import org.gvnix.flex.addon.antlr.stringtemplate.StringTemplate;
import org.gvnix.flex.addon.antlr.stringtemplate.StringTemplateGroup;
import org.gvnix.flex.as.classpath.ASMutablePhysicalTypeMetadataProvider;
import org.gvnix.flex.as.classpath.ASPhysicalTypeIdentifier;
import org.gvnix.flex.as.classpath.ASPhysicalTypeMetadata;
import org.gvnix.flex.as.classpath.details.ASFieldMetadata;
import org.gvnix.flex.as.classpath.details.ASMutableClassOrInterfaceTypeDetails;
import org.gvnix.flex.as.model.ActionScriptMappingUtils;
import org.gvnix.flex.as.model.ActionScriptType;
import org.gvnix.flex.ui.FlexUIMetadata;
import org.gvnix.flex.ui.MxmlRoundTripUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.springframework.roo.classpath.PhysicalTypeIdentifier;
import org.springframework.roo.classpath.PhysicalTypeMetadata;
import org.springframework.roo.classpath.details.BeanInfoUtils;
import org.springframework.roo.classpath.details.ClassOrInterfaceTypeDetails;
import org.springframework.roo.classpath.details.FieldMetadata;
import org.springframework.roo.classpath.details.MemberFindingUtils;
import org.springframework.roo.classpath.details.MethodMetadata;
import org.springframework.roo.classpath.details.annotations.AnnotationAttributeValue;
import org.springframework.roo.classpath.details.annotations.AnnotationMetadata;
import org.springframework.roo.classpath.scanner.MemberDetails;
import org.springframework.roo.classpath.scanner.MemberDetailsScanner;
import org.springframework.roo.metadata.MetadataDependencyRegistry;
import org.springframework.roo.metadata.MetadataIdentificationUtils;
import org.springframework.roo.metadata.MetadataItem;
import org.springframework.roo.metadata.MetadataNotificationListener;
import org.springframework.roo.metadata.MetadataProvider;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.model.JavaSymbolName;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.process.manager.FileManager;
import org.springframework.roo.process.manager.MutableFile;
import org.springframework.roo.project.LogicalPath;
import org.springframework.roo.project.Path;
import org.springframework.roo.project.PathResolver;
import org.springframework.roo.project.ProjectMetadata;
import org.springframework.roo.project.ProjectOperations;
import org.springframework.roo.support.logging.HandlerUtils;
import org.springframework.roo.support.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Component
@Service
public class FlexUIMetadataProvider
implements MetadataProvider,
MetadataNotificationListener {
    protected static final Logger LOGGER = HandlerUtils.getLogger(FlexUIMetadataProvider.class);
    private BundleContext context;
    private PathResolver pathResolver;
    private MetadataDependencyRegistry metadataDependencyRegistry;
    private FileManager fileManager;
    private MetadataService metadataService;
    private ASMutablePhysicalTypeMetadataProvider asPhysicalTypeProvider;
    private FlexOperations flexOperations;
    private MemberDetailsScanner memberDetailsScanner;
    private ProjectOperations projectOperations;
    private StringTemplateGroup templateGroup;

    protected void activate(ComponentContext cContext) {
        this.context = cContext.getBundleContext();
        this.getMetadataDependencyRegistry().registerDependency(FlexScaffoldMetadata.getMetadataIdentiferType(), this.getProvidesType());
        this.templateGroup = new StringTemplateGroup("flexUIMetadataTemplateGroup");
    }

    protected void deactivate(ComponentContext context) {
        this.getMetadataDependencyRegistry().deregisterDependency(FlexScaffoldMetadata.getMetadataIdentiferType(), this.getProvidesType());
    }

    public MetadataItem get(String metadataId) {
        JavaType javaType = FlexUIMetadata.getJavaType(metadataId);
        LogicalPath path = FlexUIMetadata.getPath(metadataId);
        String flexScaffoldMetadataKey = FlexScaffoldMetadata.createIdentifier(javaType, path);
        FlexScaffoldMetadata flexScaffoldMetadata = (FlexScaffoldMetadata)this.getMetadataService().get(flexScaffoldMetadataKey);
        ProjectMetadata projectMetadata = (ProjectMetadata)this.getMetadataService().get(ProjectMetadata.getProjectIdentifier((String)this.getProjectOperations().getFocusedModuleName()));
        if (flexScaffoldMetadata == null || !flexScaffoldMetadata.isValid() || projectMetadata == null || !projectMetadata.isValid()) {
            return null;
        }
        String presentationPackage = this.getProjectOperations().getTopLevelPackage(this.getProjectOperations().getFocusedModuleName()) + ".presentation";
        String entityPresentationPackage = presentationPackage + "." + flexScaffoldMetadata.getEntityReference().toLowerCase();
        String scaffoldAppFileId = this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.ROOT, (String)""), "src/main/flex/" + this.getProjectOperations().getProjectName(this.getProjectOperations().getFocusedModuleName()) + "_scaffold.mxml");
        if (!this.getFileManager().exists(scaffoldAppFileId)) {
            this.getFlexOperations().createScaffoldApp();
        }
        this.updateScaffoldIfNecessary(scaffoldAppFileId, flexScaffoldMetadata);
        String flexConfigFileId = this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.ROOT, (String)""), "src/main/flex/" + this.getProjectOperations().getProjectName(this.getProjectOperations().getFocusedModuleName()) + "_scaffold-config.xml");
        if (!this.getFileManager().exists(flexConfigFileId)) {
            this.getFlexOperations().createFlexCompilerConfig();
        }
        this.updateCompilerConfigIfNecessary(flexConfigFileId, entityPresentationPackage, flexScaffoldMetadata);
        ActionScriptType entityEventType = new ActionScriptType(entityPresentationPackage + "." + flexScaffoldMetadata.getEntity().getSimpleTypeName() + "Event");
        if (!StringUtils.isNotBlank((CharSequence)this.getAsPhysicalTypeProvider().findIdentifier(entityEventType))) {
            this.createEntityEventType(entityEventType, flexScaffoldMetadata);
        }
        String listViewRelativePath = (entityPresentationPackage + "." + flexScaffoldMetadata.getEntity().getSimpleTypeName() + "View").replace('.', File.separatorChar) + ".mxml";
        String listViewPath = this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.ROOT, (String)""), "src/main/flex/" + listViewRelativePath);
        this.writeToDiskIfNecessary(listViewPath, this.buildListViewDocument(flexScaffoldMetadata, this.getElegibleListFields(projectMetadata, flexScaffoldMetadata)));
        String formRelativePath = (entityPresentationPackage + "." + flexScaffoldMetadata.getEntity().getSimpleTypeName() + "Form").replace('.', File.separatorChar) + ".mxml";
        String formPath = this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.ROOT, (String)""), "src/main/flex/" + formRelativePath);
        this.writeToDiskIfNecessary(formPath, this.buildFormDocument(flexScaffoldMetadata, this.getElegibleFormFields(projectMetadata, flexScaffoldMetadata)));
        return new FlexUIMetadata(metadataId);
    }

    private void updateScaffoldIfNecessary(String scaffoldAppFileId, FlexScaffoldMetadata flexScaffoldMetadata) {
        Document scaffoldDoc;
        MutableFile scaffoldMutableFile = null;
        try {
            scaffoldMutableFile = this.getFileManager().updateFile(scaffoldAppFileId);
            scaffoldDoc = XmlUtils.getDocumentBuilder().parse(scaffoldMutableFile.getInputStream());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        String entityName = flexScaffoldMetadata.getEntity().getSimpleTypeName();
        if (XmlUtils.findFirstElement((String)("/Application/Declarations/ArrayList[@id='entities' and String='" + entityName + "']"), (Node)scaffoldDoc.getDocumentElement()) != null) {
            return;
        }
        Element entitiesElement = XmlUtils.findFirstElement((String)"/Application/Declarations/ArrayList[@id='entities']", (Node)scaffoldDoc.getDocumentElement());
        Validate.notNull((Object)entitiesElement, (String)"Could not find the entities element in the main scaffold mxml.", (Object[])new Object[0]);
        Element entityElement = scaffoldDoc.createElement("fx:String");
        entityElement.setTextContent(entityName);
        entitiesElement.appendChild(entityElement);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlUtils.writeXml((Transformer)XmlUtils.createIndentingTransformer(), (OutputStream)byteArrayOutputStream, (Document)scaffoldDoc);
        String mxmlContent = byteArrayOutputStream.toString();
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = IOUtils.toInputStream((String)mxmlContent);
            outputStream = scaffoldMutableFile.getOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    private void updateCompilerConfigIfNecessary(String flexConfigFileId, String entityPresentationPackage, FlexScaffoldMetadata flexScaffoldMetadata) {
        Document flexConfigDoc;
        MutableFile flexConfigMutableFile = null;
        try {
            flexConfigMutableFile = this.getFileManager().updateFile(flexConfigFileId);
            flexConfigDoc = XmlUtils.getDocumentBuilder().parse(flexConfigMutableFile.getInputStream());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        String viewName = entityPresentationPackage + "." + flexScaffoldMetadata.getEntity().getSimpleTypeName() + "View";
        if (XmlUtils.findFirstElement((String)("/flex-config/includes[symbol='" + viewName + "']"), (Node)flexConfigDoc.getDocumentElement()) != null) {
            return;
        }
        Element includesElement = XmlUtils.findFirstElement((String)"/flex-config/includes", (Node)flexConfigDoc.getDocumentElement());
        Validate.notNull((Object)includesElement, (String)"Could not find the includes element in the flex compiler config.", (Object[])new Object[0]);
        Element entityElement = flexConfigDoc.createElement("symbol");
        entityElement.setTextContent(viewName);
        includesElement.appendChild(entityElement);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XmlUtils.writeXml((Transformer)XmlUtils.createIndentingTransformer(), (OutputStream)byteArrayOutputStream, (Document)flexConfigDoc);
        String mxmlContent = byteArrayOutputStream.toString();
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = IOUtils.toInputStream((String)mxmlContent);
            outputStream = flexConfigMutableFile.getOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    public String getProvidesType() {
        return FlexUIMetadata.getMetadataIdentifierType();
    }

    public void notify(String upstreamDependency, String downstreamDependency) {
        if (MetadataIdentificationUtils.isIdentifyingClass((String)downstreamDependency)) {
            Validate.isTrue((boolean)MetadataIdentificationUtils.getMetadataClass((String)upstreamDependency).equals(MetadataIdentificationUtils.getMetadataClass((String)FlexScaffoldMetadata.getMetadataIdentiferType())), (String)("Expected class-level notifications only for web scaffold metadata (not '" + upstreamDependency + "')"), (Object[])new Object[0]);
            JavaType javaType = FlexScaffoldMetadata.getJavaType(upstreamDependency);
            LogicalPath path = FlexScaffoldMetadata.getPath(upstreamDependency);
            downstreamDependency = FlexUIMetadata.createIdentifier(javaType, path);
            if (this.getMetadataDependencyRegistry().getDownstream(upstreamDependency).contains(downstreamDependency)) {
                return;
            }
        }
        Validate.isTrue((boolean)MetadataIdentificationUtils.getMetadataClass((String)downstreamDependency).equals(MetadataIdentificationUtils.getMetadataClass((String)this.getProvidesType())), (String)("Unexpected downstream notification for '" + downstreamDependency + "' to this provider (which uses '" + this.getProvidesType() + "'"), (Object[])new Object[0]);
        this.getMetadataService().evict(downstreamDependency);
        if (this.get(downstreamDependency) != null) {
            this.getMetadataDependencyRegistry().notifyDownstream(downstreamDependency);
        }
    }

    private void createEntityEventType(ActionScriptType entityEventType, FlexScaffoldMetadata flexScaffoldMetadata) {
        ActionScriptType entityType = ActionScriptMappingUtils.toActionScriptType(flexScaffoldMetadata.getEntity());
        StringTemplate entityEventTemplate = this.templateGroup.getInstanceOf("org/gvnix/flex/roo/addon/ui/entity_event");
        entityEventTemplate.setAttribute("entityEventType", entityEventType);
        entityEventTemplate.setAttribute("entityType", entityType);
        entityEventTemplate.setAttribute("flexScaffoldMetadata", (Object)flexScaffoldMetadata);
        String relativePath = entityEventType.getFullyQualifiedTypeName().replace('.', File.separatorChar) + ".as";
        String fileIdentifier = this.getPathResolver().getIdentifier(LogicalPath.getInstance((Path)Path.ROOT, (String)""), "src/main/flex/" + relativePath);
        this.getFileManager().createOrUpdateTextFileIfRequired(fileIdentifier, entityEventTemplate.toString(), true);
    }

    private Document buildListViewDocument(FlexScaffoldMetadata flexScaffoldMetadata, List<FieldMetadata> elegibleFields) {
        ActionScriptType entityType = ActionScriptMappingUtils.toActionScriptType(flexScaffoldMetadata.getEntity());
        StringTemplate listViewTemplate = this.templateGroup.getInstanceOf("org/gvnix/flex/roo/addon/ui/entity_list_view");
        listViewTemplate.setAttribute("entityType", entityType);
        listViewTemplate.setAttribute("flexScaffoldMetadata", (Object)flexScaffoldMetadata);
        listViewTemplate.setAttribute("fields", elegibleFields);
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(listViewTemplate.toString().getBytes("UTF-8"));
            return XmlUtils.getDocumentBuilder().parse(stream);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to build list view document", e);
        }
    }

    private Document buildFormDocument(FlexScaffoldMetadata flexScaffoldMetadata, List<FieldMetadata> elegibleFields) {
        ActionScriptType entityType = ActionScriptMappingUtils.toActionScriptType(flexScaffoldMetadata.getEntity());
        StringTemplate listViewTemplate = this.templateGroup.getInstanceOf("org/gvnix/flex/roo/addon/ui/entity_form");
        listViewTemplate.setAttribute("entityType", entityType);
        listViewTemplate.setAttribute("flexScaffoldMetadata", (Object)flexScaffoldMetadata);
        listViewTemplate.setAttribute("fields", FlexUIMetadataProvider.wrapFields(elegibleFields));
        Set<RelatedTypeWrapper> relatedTypes = this.findRelatedTypes(flexScaffoldMetadata, elegibleFields);
        listViewTemplate.setAttribute("relatedTypes", relatedTypes);
        listViewTemplate.setAttribute("labelFields", this.calculateLabelFields(relatedTypes));
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(listViewTemplate.toString().getBytes("UTF-8"));
            return XmlUtils.getDocumentBuilder().parse(stream);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to build list view document", e);
        }
    }

    private Map<String, String> calculateLabelFields(Set<RelatedTypeWrapper> relatedTypes) {
        HashMap<String, String> labelFields = new HashMap<String, String>();
        for (RelatedTypeWrapper relatedType : relatedTypes) {
            String labelField = "id";
            String asPhysicalTypeMetadataKey = ASPhysicalTypeIdentifier.createIdentifier(relatedType.getType(), "src/main/flex");
            ASMutableClassOrInterfaceTypeDetails details = this.getASClassDetails(asPhysicalTypeMetadataKey);
            if (details == null) continue;
            for (ASFieldMetadata asField : details.getDeclaredFields()) {
                if (!asField.getFieldType().equals(ActionScriptType.STRING_TYPE)) continue;
                labelField = asField.getFieldName().getSymbolName();
                break;
            }
            for (FieldMetadata fieldOfType : relatedType.fieldsOfType) {
                labelFields.put(fieldOfType.getFieldName().getSymbolName(), labelField);
            }
        }
        return labelFields;
    }

    private ASMutableClassOrInterfaceTypeDetails getASClassDetails(String metadataId) {
        ASPhysicalTypeMetadata metadata = (ASPhysicalTypeMetadata)this.getMetadataService().get(metadataId);
        if (metadata == null) {
            return null;
        }
        Validate.isInstanceOf(ASMutableClassOrInterfaceTypeDetails.class, (Object)metadata.getPhysicalTypeDetails(), (String)"ActionScript entity must be a class or interface.", (Object[])new Object[0]);
        return (ASMutableClassOrInterfaceTypeDetails)metadata.getPhysicalTypeDetails();
    }

    private Set<RelatedTypeWrapper> findRelatedTypes(FlexScaffoldMetadata flexScaffoldMetadata, List<FieldMetadata> elegibleFields) {
        LinkedHashSet<RelatedTypeWrapper> relatedTypes = new LinkedHashSet<RelatedTypeWrapper>();
        MemberDetails memberDetails = this.getMemberDetails(flexScaffoldMetadata.getEntity());
        for (MethodMetadata method : MemberFindingUtils.getMethods((MemberDetails)memberDetails)) {
            ActionScriptType asType;
            JavaSymbolName propertyName;
            FieldMetadata javaField;
            if (!BeanInfoUtils.isAccessorMethod((MethodMetadata)method) || null == MemberFindingUtils.getAnnotationOfType((List)(javaField = BeanInfoUtils.getFieldForPropertyName((MemberDetails)memberDetails, (JavaSymbolName)(propertyName = BeanInfoUtils.getPropertyNameForJavaBeanMethod((MethodMetadata)method)))).getAnnotations(), (JavaType)new JavaType("javax.persistence.OneToOne")) && null == MemberFindingUtils.getAnnotationOfType((List)javaField.getAnnotations(), (JavaType)new JavaType("javax.persistence.ManyToOne"))) continue;
            relatedTypes.add(new RelatedTypeWrapper(asType, elegibleFields, !(asType = ActionScriptMappingUtils.toActionScriptType(javaField.getFieldType())).getFullyQualifiedTypeName().equals(flexScaffoldMetadata.getEntity().getFullyQualifiedTypeName())));
        }
        return relatedTypes;
    }

    protected static List<FormFieldWrapper> wrapFields(List<FieldMetadata> elegibleFields) {
        ArrayList<FormFieldWrapper> wrappedFields = new ArrayList<FormFieldWrapper>();
        for (FieldMetadata field : elegibleFields) {
            wrappedFields.add(new FormFieldWrapper(field));
        }
        return wrappedFields;
    }

    private List<FieldMetadata> getElegibleListFields(ProjectMetadata projectMetadata, FlexScaffoldMetadata flexScaffoldMetadata) {
        ArrayList<FieldMetadata> eligibleFields = new ArrayList<FieldMetadata>();
        MemberDetails memberDetails = this.getMemberDetails(flexScaffoldMetadata.getEntity());
        for (MethodMetadata method : MemberFindingUtils.getMethods((MemberDetails)memberDetails)) {
            JavaSymbolName propertyName;
            FieldMetadata javaField;
            if (!BeanInfoUtils.isAccessorMethod((MethodMetadata)method) || (javaField = BeanInfoUtils.getFieldForPropertyName((MemberDetails)memberDetails, (JavaSymbolName)(propertyName = BeanInfoUtils.getPropertyNameForJavaBeanMethod((MethodMetadata)method)))).getFieldType().isCommonCollectionType() || javaField.getFieldType().isArray() || javaField.getFieldType().getPackage().getFullyQualifiedPackageName().startsWith(this.getProjectOperations().getTopLevelPackage(this.getProjectOperations().getFocusedModuleName()).getFullyQualifiedPackageName()) || MemberFindingUtils.getAnnotationOfType((List)javaField.getAnnotations(), (JavaType)new JavaType("javax.persistence.Id")) != null || MemberFindingUtils.getAnnotationOfType((List)javaField.getAnnotations(), (JavaType)new JavaType("javax.persistence.Version")) != null) continue;
            eligibleFields.add(javaField);
        }
        return eligibleFields;
    }

    private List<FieldMetadata> getElegibleFormFields(ProjectMetadata projectMetadata, FlexScaffoldMetadata flexScaffoldMetadata) {
        ArrayList<FieldMetadata> eligibleFields = new ArrayList<FieldMetadata>();
        MemberDetails memberDetails = this.getMemberDetails(flexScaffoldMetadata.getEntity());
        for (MethodMetadata method : MemberFindingUtils.getMethods((MemberDetails)memberDetails)) {
            JavaSymbolName propertyName;
            FieldMetadata javaField;
            if (!BeanInfoUtils.isAccessorMethod((MethodMetadata)method) || (javaField = BeanInfoUtils.getFieldForPropertyName((MemberDetails)memberDetails, (JavaSymbolName)(propertyName = BeanInfoUtils.getPropertyNameForJavaBeanMethod((MethodMetadata)method)))).getFieldType().isCommonCollectionType() || javaField.getFieldType().isArray() || MemberFindingUtils.getAnnotationOfType((List)javaField.getAnnotations(), (JavaType)new JavaType("javax.persistence.Id")) != null || MemberFindingUtils.getAnnotationOfType((List)javaField.getAnnotations(), (JavaType)new JavaType("javax.persistence.Version")) != null) continue;
            eligibleFields.add(javaField);
        }
        return eligibleFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeToDiskIfNecessary(String mxmlFilename, Document proposed) {
        block10: {
            MutableFile mutableFile;
            Document original;
            block14: {
                block12: {
                    original = null;
                    mutableFile = null;
                    if (!this.getFileManager().exists(mxmlFilename)) break block12;
                    InputStream inStream = null;
                    try {
                        inStream = this.getFileManager().getInputStream(mxmlFilename);
                        original = XmlUtils.getDocumentBuilder().parse(inStream);
                    }
                    catch (Exception e) {
                        try {
                            throw new IllegalStateException("Could not parse file: ".concat(mxmlFilename));
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(inStream);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)inStream);
                    Validate.notNull((Object)original, (String)"Unable to parse ".concat(mxmlFilename), (Object[])new Object[0]);
                    if (MxmlRoundTripUtils.compareDocuments(original, proposed)) {
                        mutableFile = this.getFileManager().updateFile(mxmlFilename);
                    }
                    break block14;
                }
                original = proposed;
                mutableFile = this.getFileManager().createFile(mxmlFilename);
                Validate.notNull((Object)mutableFile, (String)"Could not create MXML file '".concat(mxmlFilename).concat("'"), (Object[])new Object[0]);
            }
            try {
                if (mutableFile == null) break block10;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                XmlUtils.writeXml((Transformer)XmlUtils.createIndentingTransformer(), (OutputStream)byteArrayOutputStream, (Document)original);
                String mxmlContent = byteArrayOutputStream.toString();
                InputStream inputStream = null;
                OutputStream outputStream = null;
                try {
                    inputStream = IOUtils.toInputStream((String)mxmlContent);
                    outputStream = mutableFile.getOutputStream();
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                    IOUtils.closeQuietly((OutputStream)outputStream);
                }
                return true;
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Could not output '".concat(mutableFile.getCanonicalPath()).concat("'"), ioe);
            }
        }
        return false;
    }

    private MemberDetails getMemberDetails(JavaType entityType) {
        PhysicalTypeMetadata entityPhysicalTypeMetadata = (PhysicalTypeMetadata)this.getMetadataService().get(PhysicalTypeIdentifier.createIdentifier((JavaType)entityType, (LogicalPath)LogicalPath.getInstance((Path)Path.SRC_MAIN_JAVA, (String)"")));
        Validate.notNull((Object)entityPhysicalTypeMetadata, (String)"Unable to obtain physical type metdata for type ".concat(entityType.getFullyQualifiedTypeName()), (Object[])new Object[0]);
        ClassOrInterfaceTypeDetails entityClassOrInterfaceDetails = (ClassOrInterfaceTypeDetails)entityPhysicalTypeMetadata.getMemberHoldingTypeDetails();
        return this.scanForMemberDetails(entityClassOrInterfaceDetails);
    }

    private MemberDetails scanForMemberDetails(ClassOrInterfaceTypeDetails entityClassOrInterfaceDetails) {
        return this.getMemberDetailsScanner().getMemberDetails(this.getClass().getName(), entityClassOrInterfaceDetails);
    }

    protected static Map<String, String> buildValidationsForField(FieldMetadata field) {
        AnnotationAttributeValue regexp;
        AnnotationAttributeValue max;
        AnnotationAttributeValue min;
        HashMap<String, String> validations = new HashMap<String, String>();
        AnnotationMetadata annotationMetadata = MemberFindingUtils.getAnnotationOfType((List)field.getAnnotations(), (JavaType)new JavaType("javax.validation.constraints.Min"));
        if (null != annotationMetadata && (min = annotationMetadata.getAttribute(new JavaSymbolName("value"))) != null) {
            validations.put("minValue", min.getValue().toString());
        }
        if (null != (annotationMetadata = MemberFindingUtils.getAnnotationOfType((List)field.getAnnotations(), (JavaType)new JavaType("javax.validation.constraints.Max"))) && (max = annotationMetadata.getAttribute(new JavaSymbolName("value"))) != null) {
            validations.put("maxValue", max.getValue().toString());
        }
        if (null != (annotationMetadata = MemberFindingUtils.getAnnotationOfType((List)field.getAnnotations(), (JavaType)new JavaType("javax.validation.constraints.Pattern"))) && (regexp = annotationMetadata.getAttribute(new JavaSymbolName("regexp"))) != null) {
            validations.put("expression", regexp.getValue().toString());
        }
        if (null != (annotationMetadata = MemberFindingUtils.getAnnotationOfType((List)field.getAnnotations(), (JavaType)new JavaType("javax.validation.constraints.Size")))) {
            AnnotationAttributeValue min2;
            max = annotationMetadata.getAttribute(new JavaSymbolName("max"));
            if (max != null) {
                validations.put("maxLength", max.getValue().toString());
            }
            if ((min2 = annotationMetadata.getAttribute(new JavaSymbolName("min"))) != null) {
                validations.put("minLength", min2.getValue().toString());
            }
        }
        if (null != (annotationMetadata = MemberFindingUtils.getAnnotationOfType((List)field.getAnnotations(), (JavaType)new JavaType("javax.validation.constraints.NotNull")))) {
            validations.put("required", "true");
        }
        return validations.size() > 0 ? validations : null;
    }

    public PathResolver getPathResolver() {
        if (this.pathResolver == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(PathResolver.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (PathResolver)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load PathResolver on FlexUIMetadataProvider.");
                return null;
            }
        }
        return this.pathResolver;
    }

    public MetadataDependencyRegistry getMetadataDependencyRegistry() {
        if (this.metadataDependencyRegistry == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(MetadataDependencyRegistry.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (MetadataDependencyRegistry)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load MetadataDependencyRegistry on FlexUIMetadataProvider.");
                return null;
            }
        }
        return this.metadataDependencyRegistry;
    }

    public FileManager getFileManager() {
        if (this.fileManager == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(FileManager.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (FileManager)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load FileManager on FlexUIMetadataProvider.");
                return null;
            }
        }
        return this.fileManager;
    }

    public MetadataService getMetadataService() {
        if (this.metadataService == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(MetadataService.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (MetadataService)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load MetadataService on FlexUIMetadataProvider.");
                return null;
            }
        }
        return this.metadataService;
    }

    public ASMutablePhysicalTypeMetadataProvider getAsPhysicalTypeProvider() {
        if (this.asPhysicalTypeProvider == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(ASMutablePhysicalTypeMetadataProvider.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (ASMutablePhysicalTypeMetadataProvider)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load ASMutablePhysicalTypeMetadataProvider on FlexUIMetadataProvider.");
                return null;
            }
        }
        return this.asPhysicalTypeProvider;
    }

    public FlexOperations getFlexOperations() {
        if (this.flexOperations == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(FlexOperations.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (FlexOperations)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load FlexOperations on FlexUIMetadataProvider.");
                return null;
            }
        }
        return this.flexOperations;
    }

    public MemberDetailsScanner getMemberDetailsScanner() {
        if (this.memberDetailsScanner == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(MemberDetailsScanner.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (MemberDetailsScanner)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load MemberDetailsScanner on FlexUIMetadataProvider.");
                return null;
            }
        }
        return this.memberDetailsScanner;
    }

    public ProjectOperations getProjectOperations() {
        if (this.projectOperations == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(ProjectOperations.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (ProjectOperations)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load ProjectOperations on FlexUIMetadataProvider.");
                return null;
            }
        }
        return this.projectOperations;
    }

    public static final class RelatedTypeWrapper {
        private final ActionScriptType asType;
        private final List<FieldMetadata> fieldsOfType = new ArrayList<FieldMetadata>();
        private final boolean importRequired;

        public RelatedTypeWrapper(ActionScriptType asType, List<FieldMetadata> elegibleFields, boolean importRequired) {
            this.asType = asType;
            this.importRequired = importRequired;
            for (FieldMetadata field : elegibleFields) {
                if (!field.getFieldType().getFullyQualifiedTypeName().equals(asType.getFullyQualifiedTypeName())) continue;
                this.fieldsOfType.add(field);
            }
        }

        public String getServiceReference() {
            return StringUtils.uncapitalize((String)this.asType.getSimpleTypeName()) + "Service";
        }

        public List<FieldMetadata> getFieldsOfType() {
            return this.fieldsOfType;
        }

        public ActionScriptType getType() {
            return this.asType;
        }

        public String getTypeName() {
            return this.asType.getSimpleTypeName();
        }

        public String getTypeReference() {
            return StringUtils.uncapitalize((String)this.asType.getSimpleTypeName());
        }

        public Boolean isImportRequired() {
            return this.importRequired;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.asType == null ? 0 : this.asType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RelatedTypeWrapper other = (RelatedTypeWrapper)obj;
            return !(this.asType == null ? other.asType != null : !this.asType.equals(other.asType));
        }
    }

    public static final class FormFieldWrapper {
        private final FieldMetadata metadata;
        private final Map<String, String> validations;

        public FormFieldWrapper(FieldMetadata metadata) {
            this.metadata = metadata;
            this.validations = FlexUIMetadataProvider.buildValidationsForField(metadata);
        }

        public FieldMetadata getMetadata() {
            return this.metadata;
        }

        public Map<String, String> getValidations() {
            return this.validations;
        }

        public Boolean isDate() {
            return ActionScriptMappingUtils.toActionScriptType(this.metadata.getFieldType()).equals(ActionScriptType.DATE_TYPE);
        }

        public Boolean isBoolean() {
            return ActionScriptMappingUtils.toActionScriptType(this.metadata.getFieldType()).equals(ActionScriptType.BOOLEAN_TYPE);
        }

        public Boolean isNumber() {
            return ActionScriptMappingUtils.toActionScriptType(this.metadata.getFieldType()).isNumeric();
        }

        public Boolean isSingleEndedRelationship() {
            if (ActionScriptMappingUtils.isMappableType(ActionScriptMappingUtils.toActionScriptType(this.metadata.getFieldType()))) {
                return null != MemberFindingUtils.getAnnotationOfType((List)this.metadata.getAnnotations(), (JavaType)new JavaType("javax.persistence.OneToOne")) || null != MemberFindingUtils.getAnnotationOfType((List)this.metadata.getAnnotations(), (JavaType)new JavaType("javax.persistence.ManyToOne"));
            }
            return false;
        }
    }
}

