/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.flex.ui;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.Validate;
import org.springframework.roo.support.util.XmlUtils;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class MxmlRoundTripUtils {
    private static MessageDigest digest;

    public static String calculateUniqueKeyFor(Element element) {
        StringBuilder sb = new StringBuilder();
        sb.append(element.getTagName());
        NamedNodeMap attributes = element.getAttributes();
        SortedMap<String, String> attrKVStore = Collections.synchronizedSortedMap(new TreeMap());
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attr = attributes.item(i);
            if ("z".equals(attr.getNodeName()) || attr.getNodeName().startsWith("_")) continue;
            attrKVStore.put(attr.getNodeName(), attr.getNodeValue());
        }
        for (Map.Entry entry : attrKVStore.entrySet()) {
            sb.append((String)entry.getKey()).append((String)entry.getValue());
        }
        return MxmlRoundTripUtils.base64(MxmlRoundTripUtils.sha1(sb.toString().getBytes()));
    }

    public static boolean compareDocuments(Document original, Document proposed) {
        boolean originalDocumentAdjusted = false;
        originalDocumentAdjusted = MxmlRoundTripUtils.checkNamespaces(original, proposed, originalDocumentAdjusted);
        originalDocumentAdjusted = MxmlRoundTripUtils.updateScriptBlock(original.getDocumentElement(), proposed.getDocumentElement(), originalDocumentAdjusted);
        originalDocumentAdjusted = MxmlRoundTripUtils.addOrUpdateElements(original.getDocumentElement(), proposed.getDocumentElement(), originalDocumentAdjusted);
        originalDocumentAdjusted = MxmlRoundTripUtils.removeElements(original.getDocumentElement(), proposed.getDocumentElement(), originalDocumentAdjusted);
        return originalDocumentAdjusted;
    }

    private static boolean updateScriptBlock(Element original, Element proposed, boolean originalDocumentAdjusted) {
        Element originalScriptBlock = XmlUtils.findFirstElementByName((String)"fx:Script", (Element)original);
        Element proposedScriptBlock = XmlUtils.findFirstElementByName((String)"fx:Script", (Element)proposed);
        if (originalScriptBlock != null && proposedScriptBlock != null) {
            if (originalScriptBlock.getTextContent() != null && !originalScriptBlock.getTextContent().equals(proposedScriptBlock.getTextContent())) {
                originalScriptBlock.setTextContent(proposedScriptBlock.getTextContent());
                originalDocumentAdjusted = true;
            } else if (originalScriptBlock.getChildNodes().getLength() > 0 && proposedScriptBlock.getChildNodes().getLength() > 0) {
                int i;
                CDATASection originalCDATA = null;
                CharacterData proposedCDATA = null;
                for (i = 0; i < originalScriptBlock.getChildNodes().getLength(); ++i) {
                    if (originalScriptBlock.getChildNodes().item(i).getNodeType() != 4) continue;
                    originalCDATA = (CDATASection)originalScriptBlock.getChildNodes().item(i);
                    break;
                }
                for (i = 0; i < proposedScriptBlock.getChildNodes().getLength(); ++i) {
                    if (proposedScriptBlock.getChildNodes().item(i).getNodeType() != 4) continue;
                    proposedCDATA = (CDATASection)proposedScriptBlock.getChildNodes().item(i);
                    break;
                }
                if (originalCDATA == null || proposedCDATA == null) {
                    return originalDocumentAdjusted;
                }
                if (originalCDATA.getData() != null && !originalCDATA.getData().equals(proposedCDATA.getData())) {
                    originalCDATA.setData(proposedCDATA.getData());
                    originalDocumentAdjusted = true;
                }
            }
        }
        return originalDocumentAdjusted;
    }

    private static boolean checkNamespaces(Document original, Document proposed, boolean originalDocumentChanged) {
        NamedNodeMap nsNodes = proposed.getDocumentElement().getAttributes();
        for (int i = 0; i < nsNodes.getLength(); ++i) {
            if (0 != original.getDocumentElement().getAttribute(nsNodes.item(i).getNodeName()).length()) continue;
            original.getDocumentElement().setAttribute(nsNodes.item(i).getNodeName(), nsNodes.item(i).getNodeValue());
            originalDocumentChanged = true;
        }
        return originalDocumentChanged;
    }

    private static boolean addOrUpdateElements(Element original, Element proposed, boolean originalDocumentChanged) {
        NodeList proposedChildren = proposed.getChildNodes();
        for (int i = 0; i < proposedChildren.getLength(); ++i) {
            Node node = proposedChildren.item(i);
            if (node.getNodeType() != 1) continue;
            Element proposedElement = (Element)node;
            String proposedId = proposedElement.getAttribute("id");
            if (proposedId.length() != 0) {
                Element originalElement = XmlUtils.findFirstElement((String)("//*[@id='" + proposedId + "']"), (Node)original);
                if (null == originalElement) {
                    Element placeHolder = XmlUtils.findFirstElementByName((String)"util:placeholder", (Element)original);
                    if (placeHolder != null) {
                        placeHolder.getParentNode().insertBefore(original.getOwnerDocument().importNode(proposedElement, false), placeHolder);
                    } else if (proposed.getAttribute("id").length() != 0 || proposed.getTagName().substring(2).matches(":[a-z].*") || proposed.getTagName().equals("fx:Declarations")) {
                        Element originalParent = XmlUtils.findFirstElement((String)("//*[@id='" + proposed.getAttribute("id") + "']"), (Node)original);
                        if (originalParent != null) {
                            originalParent.appendChild(original.getOwnerDocument().importNode(proposedElement, false));
                        } else if (proposed.getTagName().equals("fx:Declarations")) {
                            originalParent = XmlUtils.findFirstElementByName((String)"fx:Declarations", (Element)original);
                            originalParent.appendChild(original.getOwnerDocument().importNode(proposedElement, true));
                        } else if (proposed.getTagName().substring(2).matches(":[a-z].*")) {
                            Element proposedParent;
                            Element element = proposedParent = proposed.getParentNode().getNodeType() == 1 ? (Element)proposed.getParentNode() : null;
                            if (proposedParent != null && proposedParent.getAttribute("id").length() != 0) {
                                String attrTag = proposed.getTagName().substring(proposed.getTagName().indexOf(":") + 1);
                                originalParent = XmlUtils.findFirstElement((String)("//*[@id='" + proposedParent.getAttribute("id") + "']/" + attrTag), (Node)original);
                                if (originalParent != null) {
                                    originalParent.appendChild(original.getOwnerDocument().importNode(proposedElement, false));
                                }
                            }
                        }
                    }
                    originalDocumentChanged = true;
                } else {
                    String originalElementHashCode = originalElement.getAttribute("z");
                    if (originalElementHashCode.length() > 0) {
                        if ("?".equals(originalElementHashCode) || originalElementHashCode.equals(MxmlRoundTripUtils.calculateUniqueKeyFor(originalElement))) {
                            if (!MxmlRoundTripUtils.equalElements(originalElement, proposedElement)) {
                                originalElement.getParentNode().replaceChild(original.getOwnerDocument().importNode(proposedElement, false), originalElement);
                                originalDocumentChanged = true;
                            }
                            if ("?".equals(originalElementHashCode)) {
                                originalElement.setAttribute("z", MxmlRoundTripUtils.calculateUniqueKeyFor(proposedElement));
                                originalDocumentChanged = true;
                            }
                        } else if (!originalElementHashCode.equals("user-managed")) {
                            originalElement.setAttribute("z", "user-managed");
                            originalDocumentChanged = true;
                        }
                    }
                }
            }
            originalDocumentChanged = MxmlRoundTripUtils.addOrUpdateElements(original, proposedElement, originalDocumentChanged);
        }
        return originalDocumentChanged;
    }

    private static boolean removeElements(Element original, Element proposed, boolean originalDocumentChanged) {
        NodeList originalChildren = original.getChildNodes();
        for (int i = 0; i < originalChildren.getLength(); ++i) {
            Element proposedElement;
            Node node = originalChildren.item(i);
            if (node.getNodeType() != 1) continue;
            Element originalElement = (Element)node;
            String originalId = originalElement.getAttribute("id");
            if (originalId.length() != 0 && null == (proposedElement = XmlUtils.findFirstElement((String)("//*[@id='" + originalId + "']"), (Node)proposed)) && (originalElement.getAttribute("z").equals(MxmlRoundTripUtils.calculateUniqueKeyFor(originalElement)) || originalElement.getAttribute("z").equals("?"))) {
                originalElement.getParentNode().removeChild(originalElement);
                originalDocumentChanged = true;
            }
            originalDocumentChanged = MxmlRoundTripUtils.removeElements(originalElement, proposed, originalDocumentChanged);
        }
        return originalDocumentChanged;
    }

    private static boolean equalElements(Element a, Element b) {
        if (!a.getTagName().equals(b.getTagName())) {
            return false;
        }
        if (a.getAttributes().getLength() != b.getAttributes().getLength()) {
            return false;
        }
        NamedNodeMap attributes = a.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            if (node.getNodeName().equals("z") || node.getNodeName().startsWith("_") || b.getAttribute(node.getNodeName()).length() != 0 && b.getAttribute(node.getNodeName()).equals(node.getNodeValue())) continue;
            return false;
        }
        return true;
    }

    private static byte[] sha1(byte[] data) {
        Validate.notNull((Object)digest, (String)"Could not create hash key for identifier", (Object[])new Object[0]);
        return digest.digest(data);
    }

    private static String base64(byte[] data) {
        return Base64.encodeBase64String((byte[])data);
    }

    static {
        try {
            digest = MessageDigest.getInstance("sha-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not create hash key for identifier");
        }
    }
}

