/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.occ.roo.addon.addon;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.gvnix.occ.roo.addon.addon.OCCChecksumOperations;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.shell.CliAvailabilityIndicator;
import org.springframework.roo.shell.CliCommand;
import org.springframework.roo.shell.CliOption;
import org.springframework.roo.shell.CommandMarker;

@Component
@Service
public class OCCChecksumCommands
implements CommandMarker {
    @Reference
    private OCCChecksumOperations operations;

    @CliAvailabilityIndicator(value={"occ checksum set", "occ checksum all"})
    public boolean isOCCChecksumAvailable() {
        return this.operations.isOCCChecksumAvailable();
    }

    @CliCommand(value={"occ checksum set"}, help="Add the gvNIX Optimistic Concurrecy Control Checksum based behaivor to a Entity")
    public void addOCCChecksumToEntity(@CliOption(key={"entity"}, mandatory=false, unspecifiedDefaultValue="*", optionContext="update,project", help="The name of the entity object to add OCC") JavaType entity, @CliOption(key={"fieldName"}, mandatory=false, help="The name of the field to use to store de checksum value") String fieldName, @CliOption(key={"digestMethod"}, mandatory=false, help="The name of the type of digest method to compute the checksum") String digestMethod) {
        this.operations.addOccToEntity(entity, fieldName, digestMethod);
    }

    @CliCommand(value={"occ checksum all"}, help="Add the gvNIX Optimistic Concurrecy Control Checksum based behaivor to all entities in project")
    public void addOCCChecksumAll(@CliOption(key={"fieldName"}, mandatory=false, help="The name of the field to use to store de checksum value") String fieldName, @CliOption(key={"digestMethod"}, mandatory=false, help="The name of the type of digest method to compute the checksum") String digestMethod) {
        this.operations.addOccAll(fieldName, digestMethod);
    }

    protected void bindOperations(OCCChecksumOperations oCCChecksumOperations) {
        this.operations = oCCChecksumOperations;
    }

    protected void unbindOperations(OCCChecksumOperations oCCChecksumOperations) {
        if (this.operations == oCCChecksumOperations) {
            this.operations = null;
        }
    }
}

