/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.occ.roo.addon.addon;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.gvnix.occ.roo.addon.annotations.GvNIXEntityOCCChecksum;
import org.springframework.roo.addon.jpa.activerecord.JpaActiveRecordMetadata;
import org.springframework.roo.classpath.PhysicalTypeIdentifier;
import org.springframework.roo.classpath.PhysicalTypeIdentifierNamingUtils;
import org.springframework.roo.classpath.PhysicalTypeMetadata;
import org.springframework.roo.classpath.TypeManagementService;
import org.springframework.roo.classpath.details.BeanInfoUtils;
import org.springframework.roo.classpath.details.ClassOrInterfaceTypeDetails;
import org.springframework.roo.classpath.details.ClassOrInterfaceTypeDetailsBuilder;
import org.springframework.roo.classpath.details.FieldMetadata;
import org.springframework.roo.classpath.details.FieldMetadataBuilder;
import org.springframework.roo.classpath.details.IdentifiableAnnotatedJavaStructure;
import org.springframework.roo.classpath.details.ItdTypeDetails;
import org.springframework.roo.classpath.details.MemberFindingUtils;
import org.springframework.roo.classpath.details.MemberHoldingTypeDetails;
import org.springframework.roo.classpath.details.MethodMetadata;
import org.springframework.roo.classpath.details.MethodMetadataBuilder;
import org.springframework.roo.classpath.details.annotations.AnnotatedJavaType;
import org.springframework.roo.classpath.details.annotations.AnnotationMetadata;
import org.springframework.roo.classpath.details.annotations.AnnotationMetadataBuilder;
import org.springframework.roo.classpath.details.annotations.populator.AutoPopulate;
import org.springframework.roo.classpath.details.annotations.populator.AutoPopulationUtils;
import org.springframework.roo.classpath.itd.InvocableMemberBodyBuilder;
import org.springframework.roo.classpath.itd.ItdTypeDetailsProvidingMetadataItem;
import org.springframework.roo.classpath.persistence.PersistenceMemberLocator;
import org.springframework.roo.classpath.scanner.MemberDetails;
import org.springframework.roo.classpath.scanner.MemberDetailsScanner;
import org.springframework.roo.metadata.AbstractMetadataItem;
import org.springframework.roo.metadata.MetadataIdentificationUtils;
import org.springframework.roo.model.JavaSymbolName;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.project.LogicalPath;
import org.springframework.roo.support.logging.HandlerUtils;

public class OCCChecksumMetadata
extends AbstractMetadataItem
implements ItdTypeDetailsProvidingMetadataItem {
    private static final Logger LOGGER = HandlerUtils.getLogger(OCCChecksumMetadata.class);
    private ClassOrInterfaceTypeDetails governorTypeDetails;
    private final JavaType destination;
    private final JavaType aspectName;
    private final PhysicalTypeMetadata governorPhysicalTypeMetadata;
    private static final String PROVIDES_TYPE_STRING = OCCChecksumMetadata.class.getName();
    private static final String PROVIDES_TYPE = MetadataIdentificationUtils.create((String)PROVIDES_TYPE_STRING);
    private static final String ITD_TEMPLATE_CLASS_START = "Entity_gvnix_persistence_occ.aj_template1";
    private static final String METHOD_GET_MESSAGE_DIGEST = "Entity_gvnix_persistence_occ.aj_template2";
    private static final String ITD_TEMPLATE_METHOD_REMOVE = "Entity_gvnix_persistence_occ.aj_template3";
    private static final String ITD_TEMPLATE_METHOD_MERGE = "Entity_gvnix_persistence_occ.aj_template4";
    private static final String METHOD_CHECK_CONCURRENCY = "Entity_gvnix_persistence_occ.aj_template5";
    private static final String METHOD_LOAD_CHECKSUM = "Entity_gvnix_persistence_occ.aj_template6";
    private static final String METHOD_CHECKSUM_DIGEST = "Entity_gvnix_persistence_occ.aj_template7";
    private static final String ITD_TEMPLATE_CLASS_END = "Entity_gvnix_persistence_occ.aj_template8";
    private static final String PROPERTY_KEY = "${property}";
    private static final String CODE_FORMAT_PRIMITIVE = "\tsb.append((String.valueOf(${property}).equals(\"null\") ? nullstr : String.valueOf(${property})) + separator);\n";
    private static final String CODE_FORMAT = "\tsb.append((${property} == null ? nullstr : String.valueOf(${property})) + separator);\n";
    private static final String GET_ID_KEY = "${getId}";
    private static final String MANY_TO_ONE_CODE_FORMAT = "\tsb.append((${property} == null ? nullstr : String.valueOf(${property}.${getId}())) + separator);\n";
    private JpaActiveRecordMetadata entityMetadata;
    private final MemberDetailsScanner memberDetailsScanner;
    private final PersistenceMemberLocator persistenceMemberLocator;
    private String itdFileContents = null;
    @AutoPopulate
    private final String fieldName = "occChecksum";
    @AutoPopulate
    private final String digestMethod = "md5";
    private FieldMetadata idField;
    private FieldMetadata versionField;

    public OCCChecksumMetadata(String identifier, JavaType aspectName, PhysicalTypeMetadata governorPhysicalTypeMetadata, JpaActiveRecordMetadata entityMetadata, MemberDetailsScanner memberDetailsScanner, TypeManagementService typeManagementService, PersistenceMemberLocator persistenceMemberLocator, FieldMetadata idField, FieldMetadata versionField) {
        super(identifier);
        Validate.notNull((Object)aspectName, (String)"Aspect name required", (Object[])new Object[0]);
        Validate.notNull((Object)governorPhysicalTypeMetadata, (String)"Governor physical type metadata required", (Object[])new Object[0]);
        this.aspectName = aspectName;
        this.governorPhysicalTypeMetadata = governorPhysicalTypeMetadata;
        this.memberDetailsScanner = memberDetailsScanner;
        this.persistenceMemberLocator = persistenceMemberLocator;
        this.idField = idField;
        this.versionField = versionField;
        MemberHoldingTypeDetails physicalTypeDetails = governorPhysicalTypeMetadata.getMemberHoldingTypeDetails();
        if (!(physicalTypeDetails instanceof ClassOrInterfaceTypeDetails)) {
            this.valid = false;
        } else {
            this.governorTypeDetails = (ClassOrInterfaceTypeDetails)physicalTypeDetails;
        }
        this.destination = this.governorTypeDetails.getName();
        Validate.isTrue((boolean)OCCChecksumMetadata.isValid(identifier), (String)("Metadata identification string '" + identifier + "' does not appear to be a valid"), (Object[])new Object[0]);
        if (entityMetadata != null) {
            this.entityMetadata = entityMetadata;
            if (!this.isValid()) {
                return;
            }
            AnnotationMetadata annotation = MemberFindingUtils.getDeclaredTypeAnnotation((IdentifiableAnnotatedJavaStructure)this.governorTypeDetails, (JavaType)new JavaType(GvNIXEntityOCCChecksum.class.getName()));
            if (annotation != null) {
                AutoPopulationUtils.populate((Object)((Object)this), (AnnotationMetadata)annotation);
            }
            FieldMetadata field = this.getChecksumField();
            MethodMetadata getter = this.getChecksumAccessor();
            MethodMetadata setter = this.getChecksumMutator();
            this.addChecksumFieldToEntity(field, getter, setter, typeManagementService);
            this.itdFileContents = this.generateITDContents(field, persistenceMemberLocator);
        }
    }

    private String generateITDContents(FieldMetadata checksumField, PersistenceMemberLocator persistenceMemberLocator) {
        StringBuilder contents = new StringBuilder();
        Map<String, String> params = this.prepareParamsMap(checksumField);
        contents.append(this.generateITDContent(ITD_TEMPLATE_CLASS_START, checksumField, persistenceMemberLocator, params));
        if (MemberFindingUtils.getDeclaredMethod((MemberHoldingTypeDetails)this.governorTypeDetails, (JavaSymbolName)new JavaSymbolName("getMessageDigest"), null) == null) {
            contents.append(this.generateITDContent(METHOD_GET_MESSAGE_DIGEST, checksumField, persistenceMemberLocator, params));
        }
        if (MemberFindingUtils.getDeclaredMethod((MemberHoldingTypeDetails)this.governorTypeDetails, (JavaSymbolName)new JavaSymbolName("remove"), null) == null) {
            contents.append(this.generateITDContent(ITD_TEMPLATE_METHOD_REMOVE, checksumField, persistenceMemberLocator, params));
        }
        if (MemberFindingUtils.getDeclaredMethod((MemberHoldingTypeDetails)this.governorTypeDetails, (JavaSymbolName)new JavaSymbolName("merge"), null) == null) {
            contents.append(this.generateITDContent(ITD_TEMPLATE_METHOD_MERGE, checksumField, persistenceMemberLocator, params));
        }
        ArrayList<JavaType> parameters = new ArrayList<JavaType>();
        parameters.add(new JavaType(this.governorTypeDetails.getName().getSimpleTypeName()));
        if (MemberFindingUtils.getDeclaredMethod((MemberHoldingTypeDetails)this.governorTypeDetails, (JavaSymbolName)new JavaSymbolName("checkConcurrency")) == null) {
            contents.append(this.generateITDContent(METHOD_CHECK_CONCURRENCY, checksumField, persistenceMemberLocator, params));
        }
        if (MemberFindingUtils.getDeclaredMethod((MemberHoldingTypeDetails)this.governorTypeDetails, (JavaSymbolName)new JavaSymbolName("loadChecksum"), null) == null) {
            contents.append(this.generateITDContent(METHOD_LOAD_CHECKSUM, checksumField, persistenceMemberLocator, params));
        }
        if (MemberFindingUtils.getDeclaredMethod((MemberHoldingTypeDetails)this.governorTypeDetails, (JavaSymbolName)new JavaSymbolName("checksumDigest"), null) == null) {
            contents.append(this.generateITDContent(METHOD_CHECKSUM_DIGEST, checksumField, persistenceMemberLocator, params));
        }
        contents.append(this.generateITDContent(ITD_TEMPLATE_CLASS_END, checksumField, persistenceMemberLocator, params));
        return contents.toString();
    }

    private String generateITDContent(String templateName, FieldMetadata checksumField, PersistenceMemberLocator persistenceMemberLocator, Map<String, String> params) {
        String template;
        try {
            template = IOUtils.toString((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(templateName)));
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unable load " + templateName, ioe);
        }
        return this.replaceParams(template, params);
    }

    private Map<String, String> prepareParamsMap(FieldMetadata checksumField) {
        HashMap<String, String> params = new HashMap<String, String>(10);
        params.put("digest_method", this.digestMethod);
        params.put("entity_package", this.governorTypeDetails.getName().getPackage().getFullyQualifiedPackageName());
        params.put("entity_class", this.governorTypeDetails.getName().getSimpleTypeName());
        params.put("findById_method", this.entityMetadata.getFindMethod().getMethodName().getSymbolName());
        params.put("id_field", this.idField.getFieldName().getSymbolName());
        params.put("checksum_field", checksumField.getFieldName().getSymbolName());
        params.put("local_fields_to_String", this.getCodeToTranformFieldsToString());
        return params;
    }

    private String getCodeToTranformFieldsToString() {
        MemberDetails members = this.memberDetailsScanner.getMemberDetails(this.governorTypeDetails.getClass().getName(), this.governorTypeDetails);
        return this.getToStringCodeForRooBean(members, null);
    }

    private String getToStringCodeForRooBean(MemberDetails members, String prefix) {
        StringBuilder strb = new StringBuilder();
        for (MemberHoldingTypeDetails memberHoldingTypeDetails : members.getDetails()) {
            for (MethodMetadata method : memberHoldingTypeDetails.getDeclaredMethods()) {
                JavaSymbolName propertyName;
                FieldMetadata field;
                if (!BeanInfoUtils.isAccessorMethod((MethodMetadata)method) || (field = BeanInfoUtils.getFieldForPropertyName((MemberDetails)members, (JavaSymbolName)(propertyName = BeanInfoUtils.getPropertyNameForJavaBeanMethod((MethodMetadata)method)))) == null || MemberFindingUtils.getAnnotationOfType((List)field.getAnnotations(), (JavaType)new JavaType("javax.persistence.Version")) != null || MemberFindingUtils.getAnnotationOfType((List)field.getAnnotations(), (JavaType)new JavaType("javax.persistence.Transient")) != null || Modifier.isTransient(field.getModifier()) || MemberFindingUtils.getAnnotationOfType((List)field.getAnnotations(), (JavaType)new JavaType("javax.persistence.ManyToMany")) != null || MemberFindingUtils.getAnnotationOfType((List)field.getAnnotations(), (JavaType)new JavaType("javax.persistence.OneToMany")) != null) continue;
                if (MemberFindingUtils.getAnnotationOfType((List)field.getAnnotations(), (JavaType)new JavaType("javax.persistence.ManyToOne")) != null) {
                    strb.append(this.getToStringManyToOneProperty(method, field, prefix));
                    continue;
                }
                if (MemberFindingUtils.getAnnotationOfType((List)field.getAnnotations(), (JavaType)new JavaType("javax.persistence.EmbeddedId")) != null) continue;
                strb.append(this.getToStringCodeForBaseField(prefix, method.getMethodName(), field));
            }
        }
        return strb.toString();
    }

    private String getToStringCodeForBaseField(String prefix, JavaSymbolName fieldAccessorName, FieldMetadata field) {
        String formatStringToUse = CODE_FORMAT;
        if (field.getFieldType().isPrimitive()) {
            formatStringToUse = CODE_FORMAT_PRIMITIVE;
        }
        return StringUtils.replace((String)formatStringToUse, (String)PROPERTY_KEY, (String)this.getPropertyAccesorExpression(prefix, fieldAccessorName, field.getFieldName()));
    }

    private Object getToStringManyToOneProperty(MethodMetadata propAccessor, FieldMetadata field, String prefix) {
        JavaType propertyType = field.getFieldType();
        MethodMetadata idAccesor = this.persistenceMemberLocator.getIdentifierAccessor(propertyType);
        if (idAccesor == null) {
            return "";
        }
        JavaType reltatedObjecIdType = idAccesor.getReturnType();
        String propAccessExpression = this.getPropertyAccesorExpression(prefix, propAccessor.getMethodName(), field.getFieldName());
        if (reltatedObjecIdType.isCoreType() || reltatedObjecIdType.isPrimitive()) {
            return StringUtils.replaceEach((String)MANY_TO_ONE_CODE_FORMAT, (String[])new String[]{PROPERTY_KEY, GET_ID_KEY}, (String[])new String[]{propAccessExpression, idAccesor.getMethodName().toString()});
        }
        List embeddedFields = this.persistenceMemberLocator.getEmbeddedIdentifierFields(propertyType);
        StringBuilder strb = new StringBuilder();
        propAccessExpression = this.getPropertyAccesorExpression(propAccessExpression, idAccesor.getMethodName(), field.getFieldName());
        for (FieldMetadata embeddedField : embeddedFields) {
            JavaSymbolName embeddedAccessorName = BeanInfoUtils.getAccessorMethodName((FieldMetadata)embeddedField);
            strb.append(this.getToStringCodeForBaseField(propAccessExpression, embeddedAccessorName, embeddedField));
        }
        return strb.toString();
    }

    private String getPropertyAccesorExpression(String prefix, JavaSymbolName propAccessorName, JavaSymbolName fieldName) {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            return fieldName.toString();
        }
        return String.format("%s.%s()", prefix, propAccessorName);
    }

    private String replaceParams(String template, Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            template = StringUtils.replace((String)template, (String)("${" + entry.getKey() + "}"), (String)entry.getValue());
        }
        return template;
    }

    private void addChecksumFieldToEntity(FieldMetadata field, MethodMetadata getter, MethodMetadata setter, TypeManagementService typeManagementService) {
        MemberHoldingTypeDetails ptd = this.governorPhysicalTypeMetadata.getMemberHoldingTypeDetails();
        Validate.isInstanceOf(ClassOrInterfaceTypeDetails.class, (Object)ptd, (String)("Java source code is immutable for type " + PhysicalTypeIdentifier.getFriendlyName((String)this.governorPhysicalTypeMetadata.getId())), (Object[])new Object[0]);
        ClassOrInterfaceTypeDetailsBuilder mutableTypeDetails = new ClassOrInterfaceTypeDetailsBuilder((ClassOrInterfaceTypeDetails)ptd);
        try {
            if (!this.fieldExist(mutableTypeDetails, field)) {
                mutableTypeDetails.addField(new FieldMetadataBuilder(this.governorTypeDetails.getDeclaredByMetadataId(), field));
            }
            if (!this.methodExists(mutableTypeDetails, getter)) {
                mutableTypeDetails.addMethod(getter);
            }
            if (!this.methodExists(mutableTypeDetails, setter)) {
                mutableTypeDetails.addMethod(setter);
            }
            typeManagementService.createOrUpdateTypeOnDisk(mutableTypeDetails.build());
        }
        catch (IllegalArgumentException e) {
            LOGGER.finest("Problem adding version field: ".concat(e.toString()));
        }
    }

    private boolean methodExists(ClassOrInterfaceTypeDetailsBuilder mutableTypeDetails, MethodMetadata method) {
        if (method == null) {
            return false;
        }
        for (MethodMetadataBuilder methodBuilder : mutableTypeDetails.getDeclaredMethods()) {
            if (!methodBuilder.getReturnType().equals((Object)method.getReturnType()) || !methodBuilder.getMethodName().equals((Object)method.getMethodName()) || methodBuilder.getParameterTypes().size() != method.getParameterTypes().size()) continue;
            Iterator builderParamTypeIter = methodBuilder.getParameterTypes().iterator();
            Iterator paramTypeIter = method.getParameterTypes().iterator();
            boolean match = true;
            while (builderParamTypeIter.hasNext()) {
                AnnotatedJavaType paramType;
                AnnotatedJavaType builderParamType = (AnnotatedJavaType)builderParamTypeIter.next();
                if (builderParamType.equals(paramType = (AnnotatedJavaType)paramTypeIter.next())) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    private boolean fieldExist(ClassOrInterfaceTypeDetailsBuilder mutableTypeDetails, FieldMetadata field) {
        boolean found = false;
        for (FieldMetadataBuilder fieldBuilder : mutableTypeDetails.getDeclaredFields()) {
            if (!fieldBuilder.getFieldType().equals((Object)field.getFieldType()) || !fieldBuilder.getFieldName().equals((Object)field.getFieldName()) || fieldBuilder.getAnnotations() != null && field.getAnnotations() == null || fieldBuilder.getAnnotations() == null && field.getAnnotations() != null || fieldBuilder.getAnnotations().size() != field.getAnnotations().size()) continue;
            found = true;
            for (AnnotationMetadataBuilder annotation : fieldBuilder.getAnnotations()) {
                boolean annotationFound = false;
                for (AnnotationMetadata fieldAnnotation : field.getAnnotations()) {
                    if (!annotation.getAnnotationType().equals((Object)fieldAnnotation.getAnnotationType())) continue;
                    annotationFound = true;
                    break;
                }
                if (annotationFound) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        ToStringBuilder tsc = new ToStringBuilder((Object)this);
        tsc.append("identifier", (Object)this.getId());
        tsc.append("valid", this.valid);
        tsc.append("aspectName", (Object)this.aspectName);
        tsc.append("destinationType", (Object)this.destination);
        tsc.append("governor", (Object)this.governorPhysicalTypeMetadata.getId());
        return tsc.toString();
    }

    public static final String getMetadataIdentiferType() {
        return PROVIDES_TYPE;
    }

    public static boolean isValid(String metadataIdentificationString) {
        return PhysicalTypeIdentifierNamingUtils.isValid((String)PROVIDES_TYPE_STRING, (String)metadataIdentificationString);
    }

    public FieldMetadata getChecksumField() {
        List found = MemberFindingUtils.getFieldsWithAnnotation((MemberHoldingTypeDetails)this.governorTypeDetails, (JavaType)new JavaType("javax.persistence.Version"));
        if (found.size() > 0) {
            Validate.isTrue((found.size() == 1 ? 1 : 0) != 0, (String)("More than 1 field was annotated with @javax.persistence.Version in '" + this.governorTypeDetails.getName().getFullyQualifiedTypeName() + "'"), (Object[])new Object[0]);
            FieldMetadata field = (FieldMetadata)found.get(0);
            Validate.isTrue((boolean)field.getFieldType().equals((Object)new JavaType(String.class.getName())), (String)("Field '" + field.getFieldName().getSymbolName() + "' must be java.lang.String"), (Object[])new Object[0]);
            Validate.isTrue((MemberFindingUtils.getAnnotationOfType((List)field.getAnnotations(), (JavaType)new JavaType("javax.persistence.Transient")) != null ? 1 : 0) != 0, (String)("Field '" + field.getFieldName().getSymbolName() + "' must have @Transient annotation"), (Object[])new Object[0]);
            if (!field.getFieldName().getSymbolName().equals("occChecksum")) {
                LOGGER.warning(this.governorTypeDetails.getName().getFullyQualifiedTypeName() + ": The @Version field name (" + field.getFieldName().getSymbolName() + ") does not match with @GvNIXEntityOCCChecksum.fieldName (" + "occChecksum" + ")");
            }
            return field;
        }
        StringBuilder fieldNameBuilder = new StringBuilder();
        JavaSymbolName checksumField = null;
        while (MemberFindingUtils.getField((MemberHoldingTypeDetails)this.governorTypeDetails, (JavaSymbolName)(checksumField = new JavaSymbolName(fieldNameBuilder.toString().concat(this.fieldName)))) != null) {
            fieldNameBuilder.append('_');
        }
        ArrayList<AnnotationMetadataBuilder> annotations = new ArrayList<AnnotationMetadataBuilder>();
        AnnotationMetadataBuilder idAnnotation = new AnnotationMetadataBuilder(new JavaType("javax.persistence.Version"), new ArrayList());
        annotations.add(idAnnotation);
        idAnnotation = new AnnotationMetadataBuilder(new JavaType("javax.persistence.Transient"), new ArrayList());
        annotations.add(idAnnotation);
        FieldMetadata field = new FieldMetadataBuilder(this.getId(), 2, annotations, checksumField, JavaType.STRING).build();
        return field;
    }

    public MethodMetadata getChecksumAccessor() {
        FieldMetadata checksum = this.getChecksumField();
        String requiredAccessorName = "get" + StringUtils.capitalize((String)checksum.getFieldName().getSymbolName());
        if (!this.getId().equals(checksum.getDeclaredByMetadataId())) {
            MethodMetadata method = MemberFindingUtils.getMethod((MemberHoldingTypeDetails)this.governorTypeDetails, (JavaSymbolName)new JavaSymbolName(requiredAccessorName), new ArrayList());
            return method;
        }
        InvocableMemberBodyBuilder bodyBuilder = new InvocableMemberBodyBuilder();
        bodyBuilder.appendFormalLine("return this." + checksum.getFieldName().getSymbolName() + ";");
        return new MethodMetadataBuilder(this.getId(), 1, new JavaSymbolName(requiredAccessorName), checksum.getFieldType(), new ArrayList(), new ArrayList(), bodyBuilder).build();
    }

    public MethodMetadata getChecksumMutator() {
        FieldMetadata chekcsum = this.getChecksumField();
        if (chekcsum == null) {
            return null;
        }
        String requiredMutatorName = "set" + StringUtils.capitalize((String)chekcsum.getFieldName().getSymbolName());
        ArrayList<JavaType> paramTypes = new ArrayList<JavaType>();
        paramTypes.add(chekcsum.getFieldType());
        ArrayList<JavaSymbolName> paramNames = new ArrayList<JavaSymbolName>();
        paramNames.add(new JavaSymbolName("checksum"));
        if (!this.getId().equals(chekcsum.getDeclaredByMetadataId())) {
            MethodMetadata method = MemberFindingUtils.getMethod((MemberHoldingTypeDetails)this.governorTypeDetails, (JavaSymbolName)new JavaSymbolName(requiredMutatorName), paramTypes);
            return method;
        }
        InvocableMemberBodyBuilder bodyBuilder = new InvocableMemberBodyBuilder();
        bodyBuilder.appendFormalLine("this." + chekcsum.getFieldName().getSymbolName() + " = checksum;");
        return new MethodMetadataBuilder(this.getId(), 1, new JavaSymbolName(requiredMutatorName), JavaType.VOID_PRIMITIVE, AnnotatedJavaType.convertFromJavaTypes(paramTypes), paramNames, bodyBuilder).build();
    }

    public static final String createIdentifier(JavaType javaType, LogicalPath path) {
        return PhysicalTypeIdentifierNamingUtils.createIdentifier((String)PROVIDES_TYPE_STRING, (JavaType)javaType, (LogicalPath)path);
    }

    public static final JavaType getJavaType(String metadataIdentificationString) {
        return PhysicalTypeIdentifierNamingUtils.getJavaType((String)PROVIDES_TYPE_STRING, (String)metadataIdentificationString);
    }

    public static final LogicalPath getPath(String metadataIdentificationString) {
        return PhysicalTypeIdentifierNamingUtils.getPath((String)PROVIDES_TYPE_STRING, (String)metadataIdentificationString);
    }

    public String getItdFileContents() {
        return this.itdFileContents;
    }

    public ItdTypeDetails getMemberHoldingTypeDetails() {
        return null;
    }
}

