/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.occ.roo.addon.addon;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.gvnix.occ.roo.addon.addon.OCCChecksumMetadata;
import org.gvnix.occ.roo.addon.annotations.GvNIXEntityOCCChecksum;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.springframework.roo.addon.finder.FinderOperationsImpl;
import org.springframework.roo.addon.jpa.activerecord.JpaActiveRecordMetadata;
import org.springframework.roo.classpath.PhysicalTypeCategory;
import org.springframework.roo.classpath.PhysicalTypeIdentifier;
import org.springframework.roo.classpath.PhysicalTypeMetadata;
import org.springframework.roo.classpath.TypeManagementService;
import org.springframework.roo.classpath.details.ClassOrInterfaceTypeDetails;
import org.springframework.roo.classpath.details.FieldMetadata;
import org.springframework.roo.classpath.details.IdentifiableAnnotatedJavaStructure;
import org.springframework.roo.classpath.details.MemberFindingUtils;
import org.springframework.roo.classpath.itd.ItdMetadataProvider;
import org.springframework.roo.classpath.itd.ItdTriggerBasedMetadataProvider;
import org.springframework.roo.classpath.persistence.PersistenceMemberLocator;
import org.springframework.roo.classpath.scanner.MemberDetailsScanner;
import org.springframework.roo.metadata.MetadataDependencyRegistry;
import org.springframework.roo.metadata.MetadataIdentificationUtils;
import org.springframework.roo.metadata.MetadataItem;
import org.springframework.roo.metadata.MetadataNotificationListener;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.process.manager.FileManager;
import org.springframework.roo.process.manager.MutableFile;
import org.springframework.roo.project.LogicalPath;
import org.springframework.roo.project.Path;
import org.springframework.roo.support.logging.HandlerUtils;

@Component
@Service
public class OCCChecksumMetadataProvider
implements ItdTriggerBasedMetadataProvider,
MetadataNotificationListener {
    private BundleContext context;
    private static final Logger LOGGER = HandlerUtils.getLogger(FinderOperationsImpl.class);
    private boolean governorTypeDetail = true;
    private boolean governorBeingAClass = true;
    private MetadataService metadataService;
    private MetadataDependencyRegistry metadataDependencyRegistry;
    private FileManager fileManager;
    private MemberDetailsScanner memberDetailsScanner;
    private PersistenceMemberLocator persistenceMemberLocator;
    private TypeManagementService typeManagementService;
    private final List<JavaType> metadataTriggers = new ArrayList<JavaType>();
    private boolean ignoreTriggerAnnotations = false;

    protected void activate(ComponentContext cContext) {
        this.context = cContext.getBundleContext();
        this.getMetadataDependencyRegistry().registerDependency(PhysicalTypeIdentifier.getMetadataIdentiferType(), this.getProvidesType());
        this.addMetadataTrigger(new JavaType(GvNIXEntityOCCChecksum.class.getName()));
    }

    protected void deactivate(ComponentContext context) {
    }

    protected String createLocalIdentifier(JavaType javaType, LogicalPath path) {
        return OCCChecksumMetadata.createIdentifier(javaType, path);
    }

    public String getItdUniquenessFilenameSuffix() {
        return "gvNIX_occChecksum";
    }

    public String getProvidesType() {
        return OCCChecksumMetadata.getMetadataIdentiferType();
    }

    protected String getGovernorPhysicalTypeIdentifier(String metadataIdentificationString) {
        JavaType javaType = OCCChecksumMetadata.getJavaType(metadataIdentificationString);
        LogicalPath path = OCCChecksumMetadata.getPath(metadataIdentificationString);
        String physicalTypeIdentifier = PhysicalTypeIdentifier.createIdentifier((JavaType)javaType, (LogicalPath)path);
        return physicalTypeIdentifier;
    }

    protected OCCChecksumMetadata getMetadata(String metadataIdentificationString, JavaType aspectName, PhysicalTypeMetadata governorPhysicalTypeMetadata, String itdFilename) {
        List idFields;
        Path path = Path.SRC_MAIN_JAVA;
        JavaType entityType = ((ClassOrInterfaceTypeDetails)governorPhysicalTypeMetadata.getMemberHoldingTypeDetails()).getName();
        String entityMetadataKey = JpaActiveRecordMetadata.createIdentifier((JavaType)entityType, (LogicalPath)LogicalPath.getInstance((Path)path, (String)""));
        JpaActiveRecordMetadata entityMetadata = (JpaActiveRecordMetadata)this.getMetadataService().get(entityMetadataKey);
        if (entityMetadata == null) {
            return null;
        }
        FieldMetadata versionField = this.getPersistenceMemberLocator().getVersionField(entityType);
        if (versionField != null) {
            String declaredByType = entityMetadataKey.substring(entityMetadataKey.lastIndexOf(63) + 1);
            if (!versionField.getDeclaredByMetadataId().endsWith(declaredByType)) {
                throw new IllegalStateException("You are trying to apply OCC Checksum on an Entity ".concat("that extends of another one with a ").concat("@javax.persistence.Version field. ").concat("You should to apply OCC Checksum ").concat("over that Entity in your class: ").concat(declaredByType));
            }
        }
        if ((idFields = this.getPersistenceMemberLocator().getIdentifierFields(entityType)).isEmpty()) {
            return null;
        }
        FieldMetadata idField = (FieldMetadata)idFields.get(0);
        OCCChecksumMetadata metadata = new OCCChecksumMetadata(metadataIdentificationString, aspectName, governorPhysicalTypeMetadata, entityMetadata, this.getMemberDetailsScanner(), this.getTypeManagementService(), this.getPersistenceMemberLocator(), idField, versionField);
        return metadata;
    }

    public final void notify(String upstreamDependency, String downstreamDependency) {
        if (MetadataIdentificationUtils.isIdentifyingClass((String)downstreamDependency)) {
            Validate.isTrue((boolean)MetadataIdentificationUtils.getMetadataClass((String)upstreamDependency).equals(MetadataIdentificationUtils.getMetadataClass((String)PhysicalTypeIdentifier.getMetadataIdentiferType())), (String)("Expected class-level notifications only for physical Java types (not '" + upstreamDependency + "')"), (Object[])new Object[0]);
            JavaType javaType = PhysicalTypeIdentifier.getJavaType((String)upstreamDependency);
            LogicalPath path = PhysicalTypeIdentifier.getPath((String)upstreamDependency);
            downstreamDependency = this.createLocalIdentifier(javaType, path);
            if (this.getMetadataDependencyRegistry().getDownstream(upstreamDependency).contains(downstreamDependency)) {
                return;
            }
        }
        Validate.isTrue((boolean)MetadataIdentificationUtils.getMetadataClass((String)downstreamDependency).equals(MetadataIdentificationUtils.getMetadataClass((String)this.getProvidesType())), (String)("Unexpected downstream notification for '" + downstreamDependency + "' to this provider (which uses '" + this.getProvidesType() + "'"), (Object[])new Object[0]);
        this.getMetadataService().evict(downstreamDependency);
        if (this.get(downstreamDependency) != null) {
            this.getMetadataDependencyRegistry().notifyDownstream(downstreamDependency);
        }
    }

    public void addMetadataTrigger(JavaType javaType) {
        Validate.notNull((Object)javaType, (String)"Java type required for metadata trigger registration", (Object[])new Object[0]);
        this.metadataTriggers.add(javaType);
    }

    public void removeMetadataTrigger(JavaType javaType) {
        Validate.notNull((Object)javaType, (String)"Java type required for metadata trigger deregistration", (Object[])new Object[0]);
        this.metadataTriggers.remove(javaType);
    }

    protected boolean isIgnoreTriggerAnnotations() {
        return this.ignoreTriggerAnnotations;
    }

    protected void setIgnoreTriggerAnnotations(boolean ignoreTriggerAnnotations) {
        this.ignoreTriggerAnnotations = ignoreTriggerAnnotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MetadataItem get(String metadataIdentificationString) {
        Validate.isTrue((boolean)MetadataIdentificationUtils.getMetadataClass((String)metadataIdentificationString).equals(MetadataIdentificationUtils.getMetadataClass((String)this.getProvidesType())), (String)("Unexpected request for '" + metadataIdentificationString + "' to this provider (which uses '" + this.getProvidesType() + "'"), (Object[])new Object[0]);
        this.getMetadataDependencyRegistry().deregisterDependencies(metadataIdentificationString);
        String governorPhysicalTypeIdentifier = this.getGovernorPhysicalTypeIdentifier(metadataIdentificationString);
        PhysicalTypeMetadata governorPhysicalTypeMetadata = (PhysicalTypeMetadata)this.getMetadataService().get(governorPhysicalTypeIdentifier);
        if (governorPhysicalTypeMetadata == null || !governorPhysicalTypeMetadata.isValid()) {
            return null;
        }
        String itdFilename = governorPhysicalTypeMetadata.getItdCanoncialPath((ItdMetadataProvider)this);
        JavaType aspectName = governorPhysicalTypeMetadata.getItdJavaType((ItdMetadataProvider)this);
        boolean produceMetadata = false;
        ClassOrInterfaceTypeDetails cid = null;
        if (governorPhysicalTypeMetadata.getMemberHoldingTypeDetails() != null && governorPhysicalTypeMetadata.getMemberHoldingTypeDetails() instanceof ClassOrInterfaceTypeDetails) {
            cid = (ClassOrInterfaceTypeDetails)governorPhysicalTypeMetadata.getMemberHoldingTypeDetails();
            for (JavaType trigger : this.metadataTriggers) {
                if (MemberFindingUtils.getDeclaredTypeAnnotation((IdentifiableAnnotatedJavaStructure)cid, (JavaType)trigger) == null) continue;
                produceMetadata = true;
                break;
            }
        }
        if (this.ignoreTriggerAnnotations) {
            produceMetadata = true;
        }
        if (this.governorTypeDetail && cid == null) {
            produceMetadata = false;
        }
        if (cid != null && this.governorBeingAClass && cid.getPhysicalTypeCategory() != PhysicalTypeCategory.CLASS) {
            produceMetadata = false;
        }
        if (produceMetadata) {
            String itd;
            OCCChecksumMetadata metadata = this.getMetadata(metadataIdentificationString, aspectName, governorPhysicalTypeMetadata, itdFilename);
            this.getMetadataDependencyRegistry().registerDependency(governorPhysicalTypeMetadata.getId(), metadataIdentificationString);
            if (metadata == null) {
                return null;
            }
            if (metadata.getItdFileContents() != null && (itd = metadata.getItdFileContents()).length() > 0) {
                block19: {
                    MutableFile mutableFile = null;
                    if (this.getFileManager().exists(itdFilename)) {
                        File newFile = new File(itdFilename);
                        String existing = null;
                        try {
                            existing = IOUtils.toString((Reader)new FileReader(newFile));
                        }
                        catch (IOException ignoreAndJustOverwriteIt) {
                            LOGGER.finest("Problem writting ".concat(newFile.getAbsolutePath()).concat(": ") + ignoreAndJustOverwriteIt);
                        }
                        if (!itd.equals(existing)) {
                            mutableFile = this.getFileManager().updateFile(itdFilename);
                        }
                    } else {
                        mutableFile = this.getFileManager().createFile(itdFilename);
                        Validate.notNull((Object)mutableFile, (String)("Could not create ITD file '" + itdFilename + "'"), (Object[])new Object[0]);
                    }
                    try {
                        if (mutableFile == null) break block19;
                        InputStream inputStream = null;
                        OutputStream outputStream = null;
                        try {
                            inputStream = IOUtils.toInputStream((String)itd);
                            outputStream = mutableFile.getOutputStream();
                            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)inputStream);
                            IOUtils.closeQuietly((OutputStream)outputStream);
                        }
                    }
                    catch (IOException ioe) {
                        throw new IllegalStateException("Could not output '".concat(mutableFile.getCanonicalPath()).concat("'"), ioe);
                    }
                }
                return metadata;
            }
            return metadata;
        }
        return null;
    }

    public final String getIdForPhysicalJavaType(String physicalJavaTypeIdentifier) {
        Validate.isTrue((boolean)MetadataIdentificationUtils.getMetadataClass((String)physicalJavaTypeIdentifier).equals(MetadataIdentificationUtils.getMetadataClass((String)PhysicalTypeIdentifier.getMetadataIdentiferType())), (String)("Expected a valid physical Java type instance identifier (not '" + physicalJavaTypeIdentifier + "')"), (Object[])new Object[0]);
        JavaType javaType = PhysicalTypeIdentifier.getJavaType((String)physicalJavaTypeIdentifier);
        LogicalPath path = PhysicalTypeIdentifier.getPath((String)physicalJavaTypeIdentifier);
        return this.createLocalIdentifier(javaType, path);
    }

    public void setDependsOnGovernorTypeDetailAvailability(boolean governorTypeDetail) {
        this.governorTypeDetail = governorTypeDetail;
    }

    public void setDependsOnGovernorBeingAClass(boolean governorBeingAClass) {
        this.governorBeingAClass = governorBeingAClass;
    }

    public MetadataDependencyRegistry getMetadataDependencyRegistry() {
        if (this.metadataDependencyRegistry == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(MetadataDependencyRegistry.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (MetadataDependencyRegistry)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load MetadataDependencyRegistry on OCCChecksumMetadataProvider.");
                return null;
            }
        }
        return this.metadataDependencyRegistry;
    }

    public MetadataService getMetadataService() {
        if (this.metadataService == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(MetadataService.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (MetadataService)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load MetadataService on OCCChecksumMetadataProvider.");
                return null;
            }
        }
        return this.metadataService;
    }

    public FileManager getFileManager() {
        if (this.fileManager == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(FileManager.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (FileManager)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load FileManager on OCCChecksumMetadataProvider.");
                return null;
            }
        }
        return this.fileManager;
    }

    public MemberDetailsScanner getMemberDetailsScanner() {
        if (this.memberDetailsScanner == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(MemberDetailsScanner.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (MemberDetailsScanner)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load MemberDetailsScanner on OCCChecksumMetadataProvider.");
                return null;
            }
        }
        return this.memberDetailsScanner;
    }

    public PersistenceMemberLocator getPersistenceMemberLocator() {
        if (this.persistenceMemberLocator == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(PersistenceMemberLocator.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (PersistenceMemberLocator)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load PersistenceMemberLocator on OCCChecksumMetadataProvider.");
                return null;
            }
        }
        return this.persistenceMemberLocator;
    }

    public TypeManagementService getTypeManagementService() {
        if (this.typeManagementService == null) {
            try {
                ServiceReference[] references;
                ServiceReference[] arr$ = references = this.context.getAllServiceReferences(TypeManagementService.class.getName(), null);
                int len$ = arr$.length;
                int i$ = 0;
                if (i$ < len$) {
                    ServiceReference ref = arr$[i$];
                    return (TypeManagementService)this.context.getService(ref);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                LOGGER.warning("Cannot load TypeManagementService on OCCChecksumMetadataProvider.");
                return null;
            }
        }
        return this.typeManagementService;
    }
}

