/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.occ.roo.addon.addon;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.gvnix.occ.roo.addon.addon.OCCChecksumOperations;
import org.gvnix.occ.roo.addon.annotations.GvNIXEntityOCCChecksum;
import org.gvnix.support.dependenciesmanager.DependenciesVersionManager;
import org.osgi.service.component.ComponentContext;
import org.springframework.roo.addon.jpa.JpaOperations;
import org.springframework.roo.addon.jpa.activerecord.JpaActiveRecordMetadata;
import org.springframework.roo.addon.jpa.activerecord.RooJpaActiveRecord;
import org.springframework.roo.classpath.TypeLocationService;
import org.springframework.roo.classpath.TypeManagementService;
import org.springframework.roo.classpath.details.ClassOrInterfaceTypeDetails;
import org.springframework.roo.classpath.details.ClassOrInterfaceTypeDetailsBuilder;
import org.springframework.roo.classpath.details.FieldMetadata;
import org.springframework.roo.classpath.details.MemberFindingUtils;
import org.springframework.roo.classpath.details.annotations.AnnotationMetadata;
import org.springframework.roo.classpath.details.annotations.AnnotationMetadataBuilder;
import org.springframework.roo.classpath.details.annotations.StringAttributeValue;
import org.springframework.roo.classpath.persistence.PersistenceMemberLocator;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.model.JavaSymbolName;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.project.LogicalPath;
import org.springframework.roo.project.Path;
import org.springframework.roo.project.ProjectOperations;
import org.springframework.roo.project.Property;
import org.springframework.roo.project.Repository;
import org.springframework.roo.support.logging.HandlerUtils;
import org.springframework.roo.support.util.XmlUtils;
import org.w3c.dom.Element;

@Component
@Service
public class OCCChecksumOperationsImpl
implements OCCChecksumOperations {
    private static final Logger logger = HandlerUtils.getLogger(OCCChecksumOperationsImpl.class);
    @Reference
    private MetadataService metadataService;
    @Reference
    private ProjectOperations projectOperations;
    @Reference
    private JpaOperations entityOperations;
    @Reference
    private TypeLocationService typeLocationService;
    @Reference
    private PersistenceMemberLocator persistenceMemberLocator;
    @Reference
    private TypeManagementService typeManagementService;

    protected void activate(ComponentContext context) {
    }

    protected void deactivate(ComponentContext context) {
    }

    @Override
    public boolean isOCCChecksumAvailable() {
        return this.entityOperations.isPersistentClassAvailable();
    }

    @Override
    public void addOccToEntity(JavaType entity, String fieldName, String digestMethod) {
        this.addGvNIXAnnotationsDependecy();
        this.doAddOccToEntity(entity, fieldName, digestMethod, true);
    }

    private void doAddOccToEntity(JavaType entity, String fieldName, String digestMethod, boolean annotateParent) {
        String declaredByType;
        String entityMetadataKey = JpaActiveRecordMetadata.createIdentifier((JavaType)entity, (LogicalPath)LogicalPath.getInstance((Path)Path.SRC_MAIN_JAVA, (String)""));
        JpaActiveRecordMetadata entityMetadata = (JpaActiveRecordMetadata)this.metadataService.get(entityMetadataKey, true);
        if (entityMetadata == null) {
            return;
        }
        FieldMetadata versionField = this.persistenceMemberLocator.getVersionField(entity);
        if (versionField != null && !entityMetadataKey.endsWith(declaredByType = versionField.getDeclaredByMetadataId().substring(versionField.getDeclaredByMetadataId().lastIndexOf("?") + 1))) {
            if (annotateParent) {
                JavaType entityToAnnotate = new JavaType(declaredByType);
                logger.info("Entity ".concat(entityToAnnotate.getFullyQualifiedTypeName().concat(" will be annotated instead of: ".concat(entity.getFullyQualifiedTypeName()))));
                entity = entityToAnnotate;
            } else {
                return;
            }
        }
        ClassOrInterfaceTypeDetails tmpDetails = this.typeLocationService.getTypeDetails(entity);
        Validate.isInstanceOf(ClassOrInterfaceTypeDetails.class, (Object)tmpDetails, (String)("Can't modify " + tmpDetails.getName()), (Object[])new Object[0]);
        ClassOrInterfaceTypeDetailsBuilder mutableTypeDetailsBuilder = new ClassOrInterfaceTypeDetailsBuilder(tmpDetails);
        List entityAnnotations = mutableTypeDetailsBuilder.build().getAnnotations();
        AnnotationMetadata occAnnotation = MemberFindingUtils.getAnnotationOfType((List)entityAnnotations, (JavaType)new JavaType(GvNIXEntityOCCChecksum.class.getName()));
        AnnotationMetadata rooEntityAnnotation = MemberFindingUtils.getAnnotationOfType((List)entityAnnotations, (JavaType)new JavaType(RooJpaActiveRecord.class.getName()));
        if (rooEntityAnnotation != null) {
            if (occAnnotation != null) {
                logger.info("Entity ".concat(entity.getFullyQualifiedTypeName().concat(" is already annotated with ".concat(GvNIXEntityOCCChecksum.class.getName()))));
                return;
            }
            ArrayList<StringAttributeValue> occAnnotationAttributes = new ArrayList<StringAttributeValue>(2);
            if (fieldName != null) {
                occAnnotationAttributes.add(new StringAttributeValue(new JavaSymbolName("fieldName"), fieldName));
            }
            if (digestMethod != null) {
                occAnnotationAttributes.add(new StringAttributeValue(new JavaSymbolName("digestMethod"), digestMethod));
            }
            occAnnotation = new AnnotationMetadataBuilder(new JavaType(GvNIXEntityOCCChecksum.class.getName()), occAnnotationAttributes).build();
            mutableTypeDetailsBuilder.addAnnotation(occAnnotation);
            this.typeManagementService.createOrUpdateTypeOnDisk(mutableTypeDetailsBuilder.build());
        }
    }

    @Override
    public void addOccAll(String fieldName, String digestMethod) {
        this.addGvNIXAnnotationsDependecy();
        for (JavaType type : this.typeLocationService.findTypesWithAnnotation(new JavaType[]{new JavaType(RooJpaActiveRecord.class.getName())})) {
            this.doAddOccToEntity(type, fieldName, digestMethod, false);
        }
    }

    @Override
    public void addGvNIXAnnotationsDependecy() {
        Element conf = XmlUtils.getConfiguration(this.getClass());
        List repos = XmlUtils.findElements((String)"/configuration/gvnix/repositories/repository", (Element)conf);
        for (Element repo : repos) {
            this.projectOperations.addRepository(this.projectOperations.getFocusedModuleName(), new Repository(repo));
        }
        List properties = XmlUtils.findElements((String)"/configuration/gvnix/properties/*", (Element)conf);
        for (Element property : properties) {
            this.projectOperations.addProperty(this.projectOperations.getFocusedModuleName(), new Property(property));
        }
        List depens = XmlUtils.findElements((String)"/configuration/gvnix/dependencies/dependency", (Element)conf);
        DependenciesVersionManager.manageDependencyVersion(this.metadataService, this.projectOperations, depens);
    }

    protected void bindMetadataService(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    protected void unbindMetadataService(MetadataService metadataService) {
        if (this.metadataService == metadataService) {
            this.metadataService = null;
        }
    }

    protected void bindProjectOperations(ProjectOperations projectOperations) {
        this.projectOperations = projectOperations;
    }

    protected void unbindProjectOperations(ProjectOperations projectOperations) {
        if (this.projectOperations == projectOperations) {
            this.projectOperations = null;
        }
    }

    protected void bindEntityOperations(JpaOperations jpaOperations) {
        this.entityOperations = jpaOperations;
    }

    protected void unbindEntityOperations(JpaOperations jpaOperations) {
        if (this.entityOperations == jpaOperations) {
            this.entityOperations = null;
        }
    }

    protected void bindTypeLocationService(TypeLocationService typeLocationService) {
        this.typeLocationService = typeLocationService;
    }

    protected void unbindTypeLocationService(TypeLocationService typeLocationService) {
        if (this.typeLocationService == typeLocationService) {
            this.typeLocationService = null;
        }
    }

    protected void bindPersistenceMemberLocator(PersistenceMemberLocator persistenceMemberLocator) {
        this.persistenceMemberLocator = persistenceMemberLocator;
    }

    protected void unbindPersistenceMemberLocator(PersistenceMemberLocator persistenceMemberLocator) {
        if (this.persistenceMemberLocator == persistenceMemberLocator) {
            this.persistenceMemberLocator = null;
        }
    }

    protected void bindTypeManagementService(TypeManagementService typeManagementService) {
        this.typeManagementService = typeManagementService;
    }

    protected void unbindTypeManagementService(TypeManagementService typeManagementService) {
        if (this.typeManagementService == typeManagementService) {
            this.typeManagementService = null;
        }
    }
}

