/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.roo.classpath.PhysicalTypeMetadata;
import org.springframework.roo.classpath.details.ClassOrInterfaceTypeDetails;
import org.springframework.roo.classpath.details.FieldMetadata;
import org.springframework.roo.classpath.details.FieldMetadataBuilder;
import org.springframework.roo.classpath.details.MemberFindingUtils;
import org.springframework.roo.classpath.details.MemberHoldingTypeDetails;
import org.springframework.roo.classpath.details.MethodMetadata;
import org.springframework.roo.classpath.details.MethodMetadataBuilder;
import org.springframework.roo.classpath.details.annotations.AnnotatedJavaType;
import org.springframework.roo.classpath.details.annotations.AnnotationMetadata;
import org.springframework.roo.classpath.details.annotations.AnnotationMetadataBuilder;
import org.springframework.roo.classpath.details.annotations.ArrayAttributeValue;
import org.springframework.roo.classpath.details.annotations.EnumAttributeValue;
import org.springframework.roo.classpath.details.annotations.StringAttributeValue;
import org.springframework.roo.classpath.details.comments.AbstractComment;
import org.springframework.roo.classpath.details.comments.CommentStructure;
import org.springframework.roo.classpath.details.comments.JavadocComment;
import org.springframework.roo.classpath.itd.AbstractItdTypeDetailsProvidingMetadataItem;
import org.springframework.roo.classpath.itd.InvocableMemberBodyBuilder;
import org.springframework.roo.classpath.scanner.MemberDetails;
import org.springframework.roo.model.EnumDetails;
import org.springframework.roo.model.ImportRegistrationResolver;
import org.springframework.roo.model.JavaSymbolName;
import org.springframework.roo.model.JavaType;

public class ItdBuilderHelper {
    private final AbstractItdTypeDetailsProvidingMetadataItem metadata;
    private final ImportRegistrationResolver importResolver;
    private final ClassOrInterfaceTypeDetails governorTypeDetails;
    private final MemberDetails memberDetails;

    public ItdBuilderHelper(AbstractItdTypeDetailsProvidingMetadataItem metadata, PhysicalTypeMetadata governorPhysicalTypeMetadata, ImportRegistrationResolver importResolver) {
        this(metadata, governorPhysicalTypeMetadata, importResolver, null);
    }

    public ItdBuilderHelper(AbstractItdTypeDetailsProvidingMetadataItem metadata, PhysicalTypeMetadata governorPhysicalTypeMetadata, ImportRegistrationResolver importResolver, MemberDetails memberDetails) {
        this.metadata = metadata;
        MemberHoldingTypeDetails physicalTypeDetails = governorPhysicalTypeMetadata.getMemberHoldingTypeDetails();
        this.governorTypeDetails = physicalTypeDetails instanceof ClassOrInterfaceTypeDetails ? (ClassOrInterfaceTypeDetails)physicalTypeDetails : null;
        this.importResolver = importResolver;
        this.memberDetails = memberDetails;
    }

    public String getFinalTypeName(JavaType type) {
        return type.getNameIncludingTypeParameters(false, this.importResolver);
    }

    public ArrayAttributeValue<StringAttributeValue> toAttributeValue(String name, Iterable<String> stringValues) {
        ArrayList<StringAttributeValue> stringAttributeValues = new ArrayList<StringAttributeValue>();
        JavaSymbolName ignored = new JavaSymbolName("ignored");
        for (String str : stringValues) {
            stringAttributeValues.add(new StringAttributeValue(ignored, str));
        }
        return new ArrayAttributeValue(new JavaSymbolName(name), stringAttributeValues);
    }

    public ArrayAttributeValue<EnumAttributeValue> toEnumAttributeValue(String name, JavaType enumType, Iterable<String> enumValueNames) {
        ArrayList<EnumAttributeValue> enumAttributeValues = new ArrayList<EnumAttributeValue>();
        JavaSymbolName ignored = new JavaSymbolName("ignored");
        for (String enumName : enumValueNames) {
            enumAttributeValues.add(new EnumAttributeValue(ignored, new EnumDetails(enumType, new JavaSymbolName(enumName))));
        }
        return new ArrayAttributeValue(new JavaSymbolName(name), enumAttributeValues);
    }

    public MethodMetadata methodExists(JavaSymbolName methodName, List<AnnotatedJavaType> paramTypes) {
        return MemberFindingUtils.getDeclaredMethod((MemberHoldingTypeDetails)this.governorTypeDetails, (JavaSymbolName)methodName, (List)AnnotatedJavaType.convertFromAnnotatedJavaTypes(paramTypes));
    }

    public void buildGetterMethodBody(InvocableMemberBodyBuilder bodyBuilder, JavaSymbolName fieldName) {
        bodyBuilder.appendFormalLine(String.format("return this.%s;", fieldName.getSymbolName()));
    }

    public void buildSetterMethodBody(InvocableMemberBodyBuilder bodyBuilder, JavaSymbolName fieldName) {
        bodyBuilder.appendFormalLine(String.format("this.%s = %s;", fieldName.getSymbolName(), fieldName.getSymbolName()));
    }

    public MethodMetadata getGetterMethod(FieldMetadata fieldMetadata, List<AnnotationMetadataBuilder> aAnnotations) {
        JavaSymbolName methodName = this.getGetterMethodNameForField(fieldMetadata.getFieldName());
        return this.getGetterMethod(fieldMetadata.getFieldName(), methodName, fieldMetadata.getFieldType(), aAnnotations);
    }

    public MethodMetadata getGetterMethod(JavaSymbolName filedName, JavaType fieldType, List<AnnotationMetadataBuilder> aAnnotations) {
        JavaSymbolName methodName = this.getGetterMethodNameForField(filedName);
        return this.getGetterMethod(filedName, methodName, fieldType, aAnnotations);
    }

    public JavaSymbolName getGetterMethodNameForField(JavaSymbolName filedName) {
        JavaSymbolName methodName = new JavaSymbolName("get".concat(filedName.getSymbolNameCapitalisedFirstLetter()));
        return methodName;
    }

    public MethodMetadata getGetterMethod(JavaSymbolName filedName, JavaSymbolName methodName, JavaType fieldType, List<AnnotationMetadataBuilder> aAnnotations) {
        ArrayList<AnnotatedJavaType> parameterTypes = new ArrayList<AnnotatedJavaType>();
        MethodMetadata method = this.methodExists(methodName, parameterTypes);
        if (method != null) {
            return method;
        }
        ArrayList<AnnotationMetadataBuilder> annotations = new ArrayList<AnnotationMetadataBuilder>();
        if (aAnnotations != null) {
            annotations.addAll(aAnnotations);
        }
        ArrayList throwsTypes = new ArrayList();
        ArrayList parameterNames = new ArrayList();
        InvocableMemberBodyBuilder bodyBuilder = new InvocableMemberBodyBuilder();
        this.buildGetterMethodBody(bodyBuilder, filedName);
        MethodMetadataBuilder methodBuilder = new MethodMetadataBuilder(this.metadata.getId(), 1, methodName, fieldType, parameterTypes, parameterNames, bodyBuilder);
        methodBuilder.setAnnotations(annotations);
        methodBuilder.setThrowsTypes(throwsTypes);
        return methodBuilder.build();
    }

    public MethodMetadata getSetterMethod(FieldMetadata fieldMetadata, List<AnnotationMetadataBuilder> aAnnotations) {
        JavaSymbolName methodName = this.getSetterMethodNameForField(fieldMetadata.getFieldName());
        return this.getSetterMethod(fieldMetadata.getFieldName(), methodName, fieldMetadata.getFieldType(), aAnnotations);
    }

    public MethodMetadata getSetterMethod(JavaSymbolName filedName, JavaType fieldType, List<AnnotationMetadataBuilder> aAnnotations) {
        JavaSymbolName methodName = this.getSetterMethodNameForField(filedName);
        return this.getSetterMethod(filedName, methodName, fieldType, aAnnotations);
    }

    public JavaSymbolName getSetterMethodNameForField(JavaSymbolName filedName) {
        JavaSymbolName methodName = new JavaSymbolName("set".concat(filedName.getSymbolNameCapitalisedFirstLetter()));
        return methodName;
    }

    public MethodMetadata getSetterMethod(JavaSymbolName filedName, JavaSymbolName methodName, JavaType fieldType, List<AnnotationMetadataBuilder> aAnnotations) {
        ArrayList<AnnotatedJavaType> parameterTypes = new ArrayList<AnnotatedJavaType>();
        parameterTypes.add(new AnnotatedJavaType(fieldType, new AnnotationMetadata[0]));
        MethodMetadata method = this.methodExists(methodName, parameterTypes);
        if (method != null) {
            return method;
        }
        ArrayList<AnnotationMetadataBuilder> annotations = new ArrayList<AnnotationMetadataBuilder>();
        if (aAnnotations != null) {
            annotations.addAll(aAnnotations);
        }
        ArrayList throwsTypes = new ArrayList();
        ArrayList<JavaSymbolName> parameterNames = new ArrayList<JavaSymbolName>();
        parameterNames.add(filedName);
        InvocableMemberBodyBuilder bodyBuilder = new InvocableMemberBodyBuilder();
        this.buildSetterMethodBody(bodyBuilder, filedName);
        MethodMetadataBuilder methodBuilder = new MethodMetadataBuilder(this.metadata.getId(), 1, methodName, JavaType.VOID_PRIMITIVE, parameterTypes, parameterNames, bodyBuilder);
        methodBuilder.setAnnotations(annotations);
        methodBuilder.setThrowsTypes(throwsTypes);
        return methodBuilder.build();
    }

    public FieldMetadata getField(JavaSymbolName fieldName, int modifiers, JavaType fieldType, List<AnnotationMetadataBuilder> annotationsRequired, GET_FIELD_EXISTS_ACTION whenExists) {
        JavaSymbolName curName = fieldName;
        FieldMetadata currentField = this.getDeclaredField(curName);
        if (currentField != null) {
            if (whenExists == GET_FIELD_EXISTS_ACTION.RETURN_EXISTING) {
                return currentField;
            }
            if (whenExists == GET_FIELD_EXISTS_ACTION.RETURN_EXISTING_IF_ANNOTATION_MATCH) {
                if (annotationsRequired == null || annotationsRequired.isEmpty()) {
                    return currentField;
                }
                if (this.hasFieldAllAnnotation(currentField, annotationsRequired)) {
                    return currentField;
                }
            } else if (whenExists == GET_FIELD_EXISTS_ACTION.THROW_ERROR) {
                throw new IllegalStateException(String.format("Field %s already exist", fieldName));
            }
        }
        if (currentField != null) {
            JavaSymbolName newName = new JavaSymbolName(fieldName.getSymbolName().concat("_"));
            return this.getField(newName, modifiers, fieldType, annotationsRequired, whenExists);
        }
        ArrayList<AnnotationMetadataBuilder> annotations = new ArrayList<AnnotationMetadataBuilder>(1);
        if (annotationsRequired != null && !annotationsRequired.isEmpty()) {
            annotations.addAll(annotationsRequired);
        }
        FieldMetadataBuilder fieldBuilder = new FieldMetadataBuilder(this.metadata.getId(), modifiers, annotations, fieldName, fieldType);
        return fieldBuilder.build();
    }

    private FieldMetadata getDeclaredField(JavaSymbolName name) {
        if (this.memberDetails == null) {
            return this.governorTypeDetails.getDeclaredField(name);
        }
        for (FieldMetadata field : this.memberDetails.getFields()) {
            if (!field.getFieldName().equals((Object)name)) continue;
            return field;
        }
        return null;
    }

    private boolean hasFieldAllAnnotation(FieldMetadata currentField, List<AnnotationMetadataBuilder> annotationsRequired) {
        for (AnnotationMetadataBuilder annotation : annotationsRequired) {
            if (currentField.getAnnotation(annotation.getAnnotationType()) != null) continue;
            return false;
        }
        return true;
    }

    public void addJavaDocToMethod(MethodMetadataBuilder methodBuilder, String description, String returnInfo, String ... parametersInfo) {
        if (parametersInfo != null && parametersInfo.length > 0 && parametersInfo.length != methodBuilder.getParameterNames().size()) {
            throw new IllegalArgumentException("Parameter names size doesn't match with parameters info.");
        }
        CommentStructure comments = methodBuilder.getCommentStructure();
        if (comments == null) {
            comments = new CommentStructure();
            methodBuilder.setCommentStructure(comments);
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            comments.addComment((AbstractComment)new JavadocComment(), CommentStructure.CommentLocation.BEGINNING);
            comments.addComment((AbstractComment)new JavadocComment(StringUtils.replace((String)description, (String)"\n", (String)"\n<p/>\n")), CommentStructure.CommentLocation.BEGINNING);
        }
        this.addJavaDocParams(methodBuilder, comments, parametersInfo);
        if (StringUtils.isNotBlank((CharSequence)returnInfo)) {
            comments.addComment((AbstractComment)new JavadocComment(), CommentStructure.CommentLocation.BEGINNING);
            comments.addComment((AbstractComment)new JavadocComment("@returns ".concat(returnInfo)), CommentStructure.CommentLocation.BEGINNING);
        }
        this.addJavaDocThrows(methodBuilder, comments);
    }

    private void addJavaDocThrows(MethodMetadataBuilder methodBuilder, CommentStructure comments) {
        if (!methodBuilder.getThrowsTypes().isEmpty()) {
            comments.addComment((AbstractComment)new JavadocComment(), CommentStructure.CommentLocation.BEGINNING);
            for (JavaType throwType : methodBuilder.getThrowsTypes()) {
                comments.addComment((AbstractComment)new JavadocComment("@throws ".concat(throwType.getSimpleTypeName())), CommentStructure.CommentLocation.BEGINNING);
            }
        }
    }

    private void addJavaDocParams(MethodMetadataBuilder methodBuilder, CommentStructure comments, String ... parametersInfo) {
        if (!methodBuilder.getParameterNames().isEmpty()) {
            comments.addComment((AbstractComment)new JavadocComment(), CommentStructure.CommentLocation.BEGINNING);
            int paramIndex = 0;
            for (JavaSymbolName paramName : methodBuilder.getParameterNames()) {
                StringBuilder sBuilder = new StringBuilder("@param ");
                sBuilder.append(paramName.getSymbolName());
                if (parametersInfo != null && paramIndex < parametersInfo.length) {
                    sBuilder.append(parametersInfo[paramIndex]);
                }
                comments.addComment((AbstractComment)new JavadocComment(sBuilder.toString()), CommentStructure.CommentLocation.BEGINNING);
                ++paramIndex;
            }
        }
    }

    public List<AnnotationMetadataBuilder> toAnnotationMetadata(JavaType ... annotations) {
        return this.toAnnotationMetadata(Arrays.asList(annotations));
    }

    public List<AnnotationMetadataBuilder> toAnnotationMetadata(List<JavaType> annotations) {
        ArrayList<AnnotationMetadataBuilder> result = new ArrayList<AnnotationMetadataBuilder>();
        if (annotations != null && !annotations.isEmpty()) {
            for (JavaType annotation : annotations) {
                result.add(new AnnotationMetadataBuilder(annotation));
            }
        }
        return result;
    }

    public List<AnnotatedJavaType> toAnnotedJavaType(JavaType ... types) {
        return this.toAnnotedJavaType(Arrays.asList(types));
    }

    public List<AnnotatedJavaType> toAnnotedJavaType(List<JavaType> types) {
        ArrayList<AnnotatedJavaType> result = new ArrayList<AnnotatedJavaType>();
        if (types != null && !types.isEmpty()) {
            for (JavaType type : types) {
                result.add(new AnnotatedJavaType(type, new AnnotationMetadata[0]));
            }
        }
        return result;
    }

    public List<JavaSymbolName> toSymbolName(String ... names) {
        return this.toSymbolName(Arrays.asList(names));
    }

    public List<JavaSymbolName> toSymbolName(List<String> names) {
        ArrayList<JavaSymbolName> result = new ArrayList<JavaSymbolName>();
        if (names != null && !names.isEmpty()) {
            for (String name : names) {
                result.add(new JavaSymbolName(name));
            }
        }
        return result;
    }

    public static enum GET_FIELD_EXISTS_ACTION {
        RETURN_EXISTING,
        RETURN_EXISTING_IF_ANNOTATION_MATCH,
        CREATE_NEW_ALWAYS,
        THROW_ERROR;

    }
}

