/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.process.manager.FileManager;
import org.springframework.roo.process.manager.MutableFile;
import org.springframework.roo.project.LogicalPath;
import org.springframework.roo.project.Path;
import org.springframework.roo.project.PathResolver;
import org.springframework.roo.project.ProjectMetadata;
import org.springframework.roo.project.ProjectOperations;
import org.springframework.roo.support.osgi.OSGiUtils;
import org.springframework.roo.support.util.FileUtils;

public class OperationUtils {
    public static boolean isProjectAvailable(MetadataService metadataService, ProjectOperations projectOperations) {
        return OperationUtils.getPathResolver(metadataService, projectOperations) != null;
    }

    public static PathResolver getPathResolver(MetadataService metadataService, ProjectOperations projectOperations) {
        ProjectMetadata projectMetadata = (ProjectMetadata)metadataService.get(ProjectMetadata.getProjectIdentifier((String)projectOperations.getFocusedModuleName()));
        if (projectMetadata == null) {
            return null;
        }
        return projectOperations.getPathResolver();
    }

    public static boolean isSpringMvcProject(MetadataService metadataService, FileManager fileManager, ProjectOperations projectOperations) {
        PathResolver pathResolver = OperationUtils.getPathResolver(metadataService, projectOperations);
        String webXmlPath = pathResolver.getIdentifier(LogicalPath.getInstance((Path)Path.SRC_MAIN_WEBAPP, (String)""), "WEB-INF/spring/webmvc-config.xml");
        return fileManager.exists(webXmlPath);
    }

    public static boolean isWebProject(MetadataService metadataService, FileManager fileManager, ProjectOperations projectOperations) {
        PathResolver pathResolver = OperationUtils.getPathResolver(metadataService, projectOperations);
        String webXmlPath = pathResolver.getIdentifier(LogicalPath.getInstance((Path)Path.SRC_MAIN_WEBAPP, (String)""), "WEB-INF/web.xml");
        return fileManager.exists(webXmlPath);
    }

    public static void installWebDialogClass(String packageFullName, PathResolver pathResolver, FileManager fileManager) {
        String classFullName = pathResolver.getIdentifier(LogicalPath.getInstance((Path)Path.SRC_MAIN_JAVA, (String)""), packageFullName.concat(".Dialog").replace(".", File.separator).concat(".java"));
        OperationUtils.installJavaClassFromTemplate(packageFullName, classFullName, "Dialog.java-template", pathResolver, fileManager);
    }

    public static void installJavaClassFromTemplate(String packageFullName, String classFullName, String javaClassTemplateName, PathResolver pathResolver, FileManager fileManager) {
        OperationUtils.installJavaClassFromTemplate(packageFullName, classFullName, javaClassTemplateName, null, pathResolver, fileManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installJavaClassFromTemplate(String packageFullName, String classFullName, String javaClassTemplateName, Map<String, String> toReplace, PathResolver pathResolver, FileManager fileManager) {
        MutableFile mutableClass = null;
        if (!fileManager.exists(classFullName)) {
            InputStream template = FileUtils.getInputStream(OperationUtils.class, (String)javaClassTemplateName);
            try {
                String javaTemplate = IOUtils.toString((Reader)new InputStreamReader(template));
                javaTemplate = StringUtils.replace((String)javaTemplate, (String)"${PACKAGE}", (String)packageFullName);
                if (toReplace != null && !toReplace.isEmpty()) {
                    for (Map.Entry<String, String> entry : toReplace.entrySet()) {
                        javaTemplate = StringUtils.replace((String)javaTemplate, (String)entry.getKey(), (String)entry.getValue());
                    }
                }
                mutableClass = fileManager.createFile(classFullName);
                OutputStream outputStream = null;
                InputStream inputStream = null;
                try {
                    outputStream = mutableClass.getOutputStream();
                    inputStream = IOUtils.toInputStream((String)javaTemplate);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
            catch (IOException ioe) {
                throw new IllegalStateException("Unable load ".concat(javaClassTemplateName).concat(", ioe"));
            }
            finally {
                try {
                    template.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Error creating ".concat(classFullName).concat(" in project"), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDirectoryContents(String sourceAntPath, String targetDirectory, FileManager fileManager, ComponentContext context, Class<?> clazz) {
        StringUtils.isNotBlank((CharSequence)sourceAntPath);
        StringUtils.isNotBlank((CharSequence)targetDirectory);
        if (!targetDirectory.endsWith("/")) {
            targetDirectory = targetDirectory + "/";
        }
        if (!fileManager.exists(targetDirectory)) {
            fileManager.createDirectory(targetDirectory);
        }
        String path = FileUtils.getPath(clazz, (String)sourceAntPath);
        Collection urls = OSGiUtils.findEntriesByPattern((BundleContext)context.getBundleContext(), (String)path);
        Validate.notNull((Object)urls, (String)("Could not search bundles for resources for Ant Path '" + path + "'"), (Object[])new Object[0]);
        for (URL url : urls) {
            String fileName = url.getPath().substring(url.getPath().lastIndexOf("/") + 1);
            try {
                OutputStream outputStream;
                if (!fileManager.exists(targetDirectory + fileName)) {
                    outputStream = null;
                    try {
                        outputStream = fileManager.createFile(targetDirectory + fileName).getOutputStream();
                        IOUtils.copy((InputStream)url.openStream(), (OutputStream)outputStream);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(outputStream);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)outputStream);
                    continue;
                }
                outputStream = null;
                try {
                    outputStream = fileManager.updateFile(targetDirectory + fileName).getOutputStream();
                    IOUtils.copy((InputStream)url.openStream(), (OutputStream)outputStream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
            catch (IOException e) {
                throw new IllegalStateException("Encountered an error during updating of resources for the add-on.", e);
            }
        }
    }
}

