/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.support;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.gvnix.support.OperationUtils;
import org.springframework.roo.addon.web.mvc.controller.scaffold.WebScaffoldMetadata;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.model.JavaType;
import org.springframework.roo.process.manager.FileManager;
import org.springframework.roo.process.manager.MutableFile;
import org.springframework.roo.project.LogicalPath;
import org.springframework.roo.project.Path;
import org.springframework.roo.project.PathResolver;
import org.springframework.roo.project.ProjectOperations;
import org.springframework.roo.support.util.DomUtils;
import org.springframework.roo.support.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebProjectUtils {
    private static final String WEB_INF_VIEWS = "WEB-INF/views/";
    private static final String JSPX_EXT = ".jspx";
    private static final String VALUE = "value";

    public static boolean isSpringMvcProject(MetadataService metadataService, FileManager fileManager, ProjectOperations projectOperations) {
        PathResolver pathResolver = OperationUtils.getPathResolver(metadataService, projectOperations);
        String webXmlPath = pathResolver.getIdentifier(LogicalPath.getInstance((Path)Path.SRC_MAIN_WEBAPP, (String)""), "WEB-INF/spring/webmvc-config.xml");
        return fileManager.exists(webXmlPath);
    }

    public static boolean isWebProject(MetadataService metadataService, FileManager fileManager, ProjectOperations projectOperations) {
        PathResolver pathResolver = OperationUtils.getPathResolver(metadataService, projectOperations);
        String webXmlPath = pathResolver.getIdentifier(LogicalPath.getInstance((Path)Path.SRC_MAIN_WEBAPP, (String)""), "WEB-INF/web.xml");
        return fileManager.exists(webXmlPath);
    }

    public static void installWebDialogClass(String packageFullName, PathResolver pathResolver, FileManager fileManager) {
        String classFullName = pathResolver.getIdentifier(LogicalPath.getInstance((Path)Path.SRC_MAIN_JAVA, (String)""), packageFullName.concat(".Dialog").replace(".", File.separator).concat(".java"));
        OperationUtils.installJavaClassFromTemplate(packageFullName, classFullName, "Dialog.java-template", pathResolver, fileManager);
    }

    public static void addTagxUriInJspx(JavaType controller, String jspxName, Map<String, String> uriMap, ProjectOperations projectOperations, FileManager fileManager, MetadataService metadataService) {
        WebScaffoldMetadata webScaffoldMetadata = (WebScaffoldMetadata)metadataService.get(WebScaffoldMetadata.createIdentifier((JavaType)controller, (LogicalPath)WebProjectUtils.getJavaPath(projectOperations)));
        Validate.notNull((Object)webScaffoldMetadata, (String)"Can't get RooWebScaffold metada for type: %s", (Object[])new Object[]{controller.getFullyQualifiedTypeName()});
        WebProjectUtils.addTagxUriInJspx(webScaffoldMetadata.getAnnotationValues().getPath(), jspxName, uriMap, projectOperations, fileManager);
    }

    public static void addTagxUriInJspx(String controllerPath, String jspxName, Map<String, String> newUriMap, ProjectOperations projectOperations, FileManager fileManager) {
        WebProjectUtils.addTagxUriInJspx(WEB_INF_VIEWS.concat(controllerPath).concat("/").concat(jspxName).concat(JSPX_EXT), (Map<String, String>)null, newUriMap, projectOperations, fileManager);
    }

    public static void addTagxUriInJspx(String controllerPath, String jspxName, Map<String, String> oldUriMap, Map<String, String> newUriMap, ProjectOperations projectOperations, FileManager fileManager) {
        WebProjectUtils.addTagxUriInJspx(WEB_INF_VIEWS.concat(controllerPath).concat("/").concat(jspxName).concat(JSPX_EXT), oldUriMap, newUriMap, projectOperations, fileManager);
    }

    public static void addTagxUriInJspx(String relativePath, Map<String, String> oldUriMap, Map<String, String> newUriMap, ProjectOperations projectOperations, FileManager fileManager) {
        PathResolver pathResolver = projectOperations.getPathResolver();
        String docJspx = pathResolver.getIdentifier(WebProjectUtils.getWebappPath(projectOperations), relativePath);
        Document docJspXml = WebProjectUtils.loadXmlDocument(docJspx, fileManager);
        if (docJspXml == null) {
            return;
        }
        Element docRoot = docJspXml.getDocumentElement();
        Element divMain = XmlUtils.findFirstElement((String)"/div", (Node)docRoot);
        boolean modified = false;
        for (Map.Entry<String, String> newUriEntry : newUriMap.entrySet()) {
            String nsName = newUriEntry.getKey();
            String nsUri = newUriEntry.getValue();
            divMain.setAttribute(nsName, nsUri);
            modified = true;
        }
        if (modified) {
            DomUtils.removeTextNodes((Node)docJspXml);
            fileManager.createOrUpdateTextFileIfRequired(docJspx, XmlUtils.nodeToString((Node)docJspXml), true);
        }
    }

    public static void updateTagxUriInJspx(JavaType controller, String jspxName, Map<String, String> uriMap, ProjectOperations projectOperations, FileManager fileManager, MetadataService metadataService) {
        WebScaffoldMetadata webScaffoldMetadata = (WebScaffoldMetadata)metadataService.get(WebScaffoldMetadata.createIdentifier((JavaType)controller, (LogicalPath)WebProjectUtils.getJavaPath(projectOperations)));
        Validate.notNull((Object)webScaffoldMetadata, (String)"Can't get RooWebScaffold metada for type: %s", (Object[])new Object[]{controller.getFullyQualifiedTypeName()});
        WebProjectUtils.updateTagxUriInJspx(webScaffoldMetadata.getAnnotationValues().getPath(), jspxName, uriMap, projectOperations, fileManager);
    }

    public static void updateTagxUriInJspx(String controllerPath, String jspxName, Map<String, String> newUriMap, ProjectOperations projectOperations, FileManager fileManager) {
        WebProjectUtils.updateTagxUriInJspx(WEB_INF_VIEWS.concat(controllerPath).concat("/").concat(jspxName).concat(JSPX_EXT), (Map<String, String>)null, newUriMap, projectOperations, fileManager);
    }

    public static void updateTagxUriInJspx(String controllerPath, String jspxName, Map<String, String> oldUriMap, Map<String, String> newUriMap, ProjectOperations projectOperations, FileManager fileManager) {
        WebProjectUtils.updateTagxUriInJspx(WEB_INF_VIEWS.concat(controllerPath).concat("/").concat(jspxName).concat(JSPX_EXT), oldUriMap, newUriMap, projectOperations, fileManager);
    }

    public static void updateTagxUriInJspx(String relativePath, Map<String, String> oldUriMap, Map<String, String> newUriMap, ProjectOperations projectOperations, FileManager fileManager) {
        PathResolver pathResolver;
        String docJspx;
        Document docJspXml;
        if (oldUriMap == null) {
            oldUriMap = new HashMap<String, String>();
        }
        if ((docJspXml = WebProjectUtils.loadXmlDocument(docJspx = (pathResolver = projectOperations.getPathResolver()).getIdentifier(WebProjectUtils.getWebappPath(projectOperations), relativePath), fileManager)) == null) {
            return;
        }
        Element docRoot = docJspXml.getDocumentElement();
        Element divMain = XmlUtils.findFirstElement((String)"/div", (Node)docRoot);
        boolean modified = false;
        for (Map.Entry<String, String> newUriEntry : newUriMap.entrySet()) {
            String nsName = newUriEntry.getKey();
            String nsUri = newUriEntry.getValue();
            if (oldUriMap.containsKey(nsName) && divMain.hasAttribute(nsName)) {
                String oldNsUri = oldUriMap.get(nsName);
                String currentUri = divMain.getAttribute(nsName);
                if ((StringUtils.isEmpty((CharSequence)oldNsUri) || oldNsUri.equalsIgnoreCase(currentUri)) && !StringUtils.equalsIgnoreCase((CharSequence)currentUri, (CharSequence)nsUri)) {
                    divMain.setAttribute(nsName, nsUri);
                    modified = true;
                }
            }
            if (oldUriMap.containsKey(nsName) || !divMain.hasAttribute(nsName) || StringUtils.equalsIgnoreCase((CharSequence)divMain.getAttribute(nsName), (CharSequence)nsUri)) continue;
            divMain.setAttribute(nsName, nsUri);
            modified = true;
        }
        if (modified) {
            DomUtils.removeTextNodes((Node)docJspXml);
            fileManager.createOrUpdateTextFileIfRequired(docJspx, XmlUtils.nodeToString((Node)docJspXml), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document loadXmlDocument(String docFileIdentifier, FileManager fileManager) {
        Document docXml;
        Validate.notNull((Object)fileManager, (String)"FileManager cannot be null", (Object[])new Object[0]);
        if (!fileManager.exists(docFileIdentifier)) {
            return null;
        }
        InputStream docIs = null;
        try {
            docIs = fileManager.getInputStream(docFileIdentifier);
            try {
                docXml = XmlUtils.getDocumentBuilder().parse(docIs);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Could not open ".concat(docFileIdentifier), ex);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)docIs);
        }
        return docXml;
    }

    public static LogicalPath getWebappPath(ProjectOperations projectOperations) {
        return LogicalPath.getInstance((Path)Path.SRC_MAIN_WEBAPP, (String)projectOperations.getFocusedModuleName());
    }

    public static LogicalPath getJavaPath(ProjectOperations projectOperations) {
        return LogicalPath.getInstance((Path)Path.SRC_MAIN_JAVA, (String)projectOperations.getFocusedModuleName());
    }

    public static boolean addCssToTag(Document docTagx, Element root, String varName, String location) {
        boolean modified = false;
        modified = WebProjectUtils.addUrlToTag(docTagx, root, varName, location);
        Element cssElement = XmlUtils.findFirstElement((String)String.format("link[@href='${%s}']", varName), (Node)root);
        if (cssElement == null) {
            cssElement = docTagx.createElement("link");
            cssElement.setAttribute("rel", "stylesheet");
            cssElement.setAttribute("type", "text/css");
            cssElement.setAttribute("media", "screen,print");
            cssElement.setAttribute("href", "${".concat(varName).concat("}"));
            root.appendChild(cssElement);
            modified = true;
        }
        return modified;
    }

    public static boolean updateCssToTag(Document docTagx, Element root, String varName, String location) {
        boolean modified = false;
        modified = WebProjectUtils.updateUrlToTag(docTagx, root, varName, location);
        Element cssElement = XmlUtils.findFirstElement((String)String.format("link[@href='${%s}']", varName), (Node)root);
        if (cssElement == null) {
            cssElement = docTagx.createElement("link");
            cssElement.setAttribute("rel", "stylesheet");
            cssElement.setAttribute("type", "text/css");
            cssElement.setAttribute("media", "screen,print");
            cssElement.setAttribute("href", "${".concat(varName).concat("}"));
            root.appendChild(cssElement);
            modified = true;
        }
        return modified;
    }

    public static boolean addUrlToTag(Document docTagx, Element root, String varName, String location) {
        Element urlElement = XmlUtils.findFirstElement((String)("url[@var='".concat(varName) + "']"), (Node)root);
        if (urlElement == null) {
            urlElement = docTagx.createElement("spring:url");
            urlElement.setAttribute("var", varName);
            urlElement.setAttribute(VALUE, location);
            root.appendChild(urlElement);
            return true;
        }
        return false;
    }

    public static boolean updateUrlToTag(Document docTagx, Element root, String varName, String location) {
        Element urlElement = XmlUtils.findFirstElement((String)("url[@var='".concat(varName) + "']"), (Node)root);
        if (urlElement != null) {
            urlElement.setAttribute("var", varName);
            urlElement.setAttribute(VALUE, location);
            return true;
        }
        return false;
    }

    public static boolean addJSToTag(Document docTagx, Element root, String varName, String location) {
        boolean modified = false;
        modified = WebProjectUtils.addUrlToTag(docTagx, root, varName, location);
        Element scriptElement = XmlUtils.findFirstElement((String)String.format("script[@src='${%s}']", varName), (Node)root);
        if (scriptElement == null) {
            scriptElement = docTagx.createElement("script");
            scriptElement.setAttribute("src", "${".concat(varName).concat("}"));
            scriptElement.setAttribute("type", "text/javascript");
            scriptElement.appendChild(docTagx.createComment("required for FF3 and Opera"));
            root.appendChild(scriptElement);
            modified = true;
        }
        return modified;
    }

    public static boolean updateJSToTag(Document docTagx, Element root, String varName, String location) {
        boolean modified = false;
        modified = WebProjectUtils.updateUrlToTag(docTagx, root, varName, location);
        Element scriptElement = XmlUtils.findFirstElement((String)String.format("script[@src='${%s}']", varName), (Node)root);
        if (scriptElement == null) {
            scriptElement = docTagx.createElement("script");
            scriptElement.setAttribute("src", "${".concat(varName).concat("}"));
            scriptElement.setAttribute("type", "text/javascript");
            scriptElement.appendChild(docTagx.createComment("required for FF3 and Opera"));
            root.appendChild(scriptElement);
            modified = true;
        }
        return modified;
    }

    public static void addJsAndCssToLoadScriptsTag(List<Pair<String, String>> cssList, List<Pair<String, String>> jsList, ProjectOperations projectOperations, FileManager fileManager) {
        Document docTagx;
        PathResolver pathResolver = projectOperations.getPathResolver();
        String docTagxPath = pathResolver.getIdentifier(WebProjectUtils.getWebappPath(projectOperations), "WEB-INF/tags/util/load-scripts.tagx");
        Validate.isTrue((boolean)fileManager.exists(docTagxPath), (String)"load-script.tagx not found: ".concat(docTagxPath), (Object[])new Object[0]);
        MutableFile docTagxMutableFile = null;
        try {
            docTagxMutableFile = fileManager.updateFile(docTagxPath);
            docTagx = XmlUtils.getDocumentBuilder().parse(docTagxMutableFile.getInputStream());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        Element root = docTagx.getDocumentElement();
        boolean modified = false;
        for (Pair<String, String> css : cssList) {
            modified = WebProjectUtils.addCssToTag(docTagx, root, (String)css.getLeft(), (String)css.getRight()) || modified;
        }
        for (Pair<String, String> js : jsList) {
            modified = WebProjectUtils.addJSToTag(docTagx, root, (String)js.getLeft(), (String)js.getRight()) || modified;
        }
        if (modified) {
            XmlUtils.writeXml((OutputStream)docTagxMutableFile.getOutputStream(), (Document)docTagx);
        }
    }

    public static boolean addLocaleVarToTag(Document docTagx, Element root, String varName) {
        Element varElement = XmlUtils.findFirstElement((String)String.format("c:set[@var='${%s}']", varName), (Node)root);
        if (varElement == null) {
            varElement = docTagx.createElement("c:set");
            varElement.setAttribute("var", varName);
            varElement.appendChild(docTagx.createComment(" Get the user local from the page context (it was set by Spring MVC's locale resolver) "));
            Element pElement = docTagx.createElement("c:set");
            pElement.setAttribute("var", "jqlocale");
            pElement.appendChild(docTagx.createTextNode("${pageContext.response.locale}"));
            varElement.appendChild(pElement);
            Element ifElement = docTagx.createElement("c:if");
            ifElement.setAttribute("test", "${fn:length(jqlocale) eq 2}");
            Element outElement = docTagx.createElement("c:out");
            outElement.setAttribute(VALUE, "${jqlocale}");
            ifElement.appendChild(outElement);
            varElement.appendChild(ifElement);
            ifElement = docTagx.createElement("c:if");
            ifElement.setAttribute("test", "${fn:length(jqlocale) gt 2}");
            outElement = docTagx.createElement("c:out");
            outElement.setAttribute(VALUE, "${fn:substringBefore(jqlocale, '_')}");
            outElement.setAttribute("default", "en");
            ifElement.appendChild(outElement);
            varElement.appendChild(ifElement);
            ifElement = docTagx.createElement("c:if");
            ifElement.setAttribute("test", "${fn:length(jqlocale) lt 2}");
            outElement = docTagx.createElement("c:out");
            outElement.setAttribute(VALUE, "en");
            ifElement.appendChild(outElement);
            varElement.appendChild(ifElement);
            root.appendChild(varElement);
            return true;
        }
        return false;
    }
}

