/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.support.dependenciesmanager;

import java.util.List;
import java.util.Set;
import org.gvnix.support.dependenciesmanager.VersionInfo;
import org.springframework.roo.metadata.MetadataService;
import org.springframework.roo.project.Dependency;
import org.springframework.roo.project.ProjectMetadata;
import org.springframework.roo.project.ProjectOperations;
import org.springframework.roo.project.Property;
import org.w3c.dom.Element;

public class DependenciesVersionManager {
    public static boolean manageDependencyVersion(MetadataService metadataService, ProjectOperations projectOperations, List<Element> dependenciesElements) {
        ProjectMetadata md = (ProjectMetadata)metadataService.get(ProjectMetadata.getProjectIdentifier((String)projectOperations.getFocusedModuleName()));
        if (md == null) {
            return false;
        }
        boolean updateDependency = true;
        Dependency dependency = null;
        for (Element depen : dependenciesElements) {
            dependency = new Dependency(depen);
            Set results = projectOperations.getFocusedModule().getDependenciesExcludingVersion(dependency);
            VersionInfo existingDepVersionInfo = null;
            VersionInfo newDepVersionInfo = VersionInfo.extractVersionInfoFromString(dependency.getVersion());
            for (Dependency existingDependency : results) {
                existingDepVersionInfo = VersionInfo.extractVersionInfoFromString(existingDependency.getVersion());
                if (existingDepVersionInfo == null) continue;
                if (existingDepVersionInfo.compareTo(newDepVersionInfo) < 0) {
                    projectOperations.removeDependency(projectOperations.getFocusedModuleName(), existingDependency);
                    updateDependency = true;
                    continue;
                }
                updateDependency = false;
            }
            if (!updateDependency) continue;
            projectOperations.addDependency(projectOperations.getFocusedModuleName(), dependency);
        }
        return updateDependency;
    }

    public static boolean managePropertyVersion(MetadataService metadataService, ProjectOperations projectOperations, List<Element> projectProperties) {
        boolean propertiesUpdated = false;
        ProjectMetadata md = (ProjectMetadata)metadataService.get(ProjectMetadata.getProjectIdentifier((String)projectOperations.getFocusedModuleName()));
        if (md == null) {
            return propertiesUpdated;
        }
        Set results = null;
        Property property = null;
        VersionInfo existingPropVersionInfo = null;
        VersionInfo newPropVersionInfo = null;
        for (Element elemProperty : projectProperties) {
            propertiesUpdated = true;
            property = new Property(elemProperty);
            newPropVersionInfo = VersionInfo.extractVersionInfoFromString(property.getValue());
            results = projectOperations.getFocusedModule().getPropertiesExcludingValue(property);
            for (Property existingProperty : results) {
                existingPropVersionInfo = VersionInfo.extractVersionInfoFromString(existingProperty.getValue());
                if (existingPropVersionInfo == null) continue;
                if (existingPropVersionInfo.compareTo(newPropVersionInfo) < 0) {
                    propertiesUpdated = true;
                    continue;
                }
                propertiesUpdated = false;
            }
            if (!propertiesUpdated) continue;
            projectOperations.addProperty(projectOperations.getFocusedModuleName(), new Property(elemProperty));
        }
        return propertiesUpdated;
    }
}

