/*
 * Decompiled with CFR 0.152.
 */
package org.gvnix.support.dependenciesmanager;

import org.apache.commons.lang3.Validate;
import org.gvnix.support.dependenciesmanager.Qualifiers;

public class VersionInfo {
    private Integer major = 0;
    private Integer minor = 0;
    private Integer patch = 0;
    private Qualifiers qualifier = Qualifiers.EMPTY;

    public int compareTo(VersionInfo v) {
        Validate.notNull((Object)v);
        int result = this.major.compareTo(v.major);
        if (result != 0) {
            return result;
        }
        result = this.minor.compareTo(v.minor);
        if (result != 0) {
            return result;
        }
        result = this.patch.compareTo(v.patch);
        if (result != 0) {
            return result;
        }
        result = this.qualifier.newerThan(v.qualifier);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + "." + (Object)((Object)this.qualifier);
    }

    public static VersionInfo extractVersionInfoFromString(String version) {
        if (version == null || version.length() == 0) {
            return null;
        }
        String[] ver = version.split("\\.");
        try {
            if (ver.length == 3) {
                VersionInfo result = new VersionInfo();
                result.major = new Integer(ver[0]);
                result.minor = new Integer(ver[1]);
                String[] patchVerQualifier = ver[2].split("-");
                result.patch = new Integer(patchVerQualifier[0]);
                if (patchVerQualifier.length == 2) {
                    String qualifier = patchVerQualifier[1];
                    if (qualifier.equalsIgnoreCase(Qualifiers.RELEASE.toString())) {
                        result.qualifier = Qualifiers.RELEASE;
                    } else if (qualifier.equalsIgnoreCase(Qualifiers.SNAPSHOT.toString())) {
                        result.qualifier = Qualifiers.SNAPSHOT;
                    }
                }
                return result;
            }
            if (ver.length == 2) {
                VersionInfo result = new VersionInfo();
                result.major = new Integer(ver[0]);
                result.minor = new Integer(ver[1]);
                return result;
            }
        }
        catch (RuntimeException e) {
            return null;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.major == null ? 0 : this.major.hashCode());
        result = 31 * result + (this.minor == null ? 0 : this.minor.hashCode());
        result = 31 * result + (this.patch == null ? 0 : this.patch.hashCode());
        result = 31 * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionInfo)) {
            return false;
        }
        VersionInfo other = (VersionInfo)obj;
        return this.compareTo(other) == 0;
    }
}

