/*
 * Decompiled with CFR 0.152.
 */
package org.gwizard.metrics;

import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.Service;
import com.google.inject.Inject;
import java.lang.management.ManagementFactory;
import org.gwizard.services.Services;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsService
extends AbstractIdleService {
    private static final Logger log = LoggerFactory.getLogger(MetricsService.class);
    private final MetricRegistry metricRegistry;
    private JmxReporter jmxReporter;

    @Inject
    public MetricsService(Services services, MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        metricRegistry.register("jvm.buffers", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        metricRegistry.register("jvm.gc", (Metric)new GarbageCollectorMetricSet());
        metricRegistry.register("jvm.memory", (Metric)new MemoryUsageGaugeSet());
        metricRegistry.register("jvm.threads", (Metric)new ThreadStatesGaugeSet());
        services.add((Service)this);
    }

    protected void startUp() throws Exception {
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).build();
        this.jmxReporter.start();
    }

    protected void shutDown() throws Exception {
        this.jmxReporter.stop();
    }
}

