/*
 * Decompiled with CFR 0.152.
 */
package org.gwizard.rest;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import java.util.Map;
import javax.inject.Singleton;
import org.gwizard.rest.JaxrsModule;
import org.gwizard.rest.ObjectMapperContextResolver;
import org.gwizard.web.WebModule;
import org.jboss.resteasy.plugins.guice.GuiceResteasyBootstrapServletContextListener;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;

public class RestModule
extends ServletModule {
    private final String path;

    public RestModule() {
        this.path = null;
    }

    public RestModule(String path) {
        Preconditions.checkArgument((path.length() == 0 || path.startsWith("/") ? 1 : 0) != 0, (Object)"Path must begin with '/'");
        Preconditions.checkArgument((!path.endsWith("/") ? 1 : 0) != 0, (Object)"Path must not have a trailing '/'");
        this.path = path;
    }

    protected void configureServlets() {
        this.install((Module)new WebModule());
        this.install((Module)new JaxrsModule());
        this.bind(GuiceResteasyBootstrapServletContextListener.class);
        this.bind(ObjectMapperContextResolver.class);
        this.bind(HttpServletDispatcher.class).in(Singleton.class);
        if (this.path == null) {
            this.serve("/*", new String[0]).with(HttpServletDispatcher.class);
        } else {
            ImmutableMap initParams = ImmutableMap.of((Object)"resteasy.servlet.mapping.prefix", (Object)this.path);
            this.serve(this.path + "/*", new String[0]).with(HttpServletDispatcher.class, (Map)initParams);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestModule)) {
            return false;
        }
        RestModule other = (RestModule)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestModule;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

