/*
 * Decompiled with CFR 0.152.
 */
package com.google.web.bindery.requestfactory.shared.impl;

import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import com.google.web.bindery.autobean.shared.AutoBeanVisitor;
import com.google.web.bindery.autobean.shared.Splittable;
import com.google.web.bindery.autobean.shared.ValueCodex;
import com.google.web.bindery.autobean.shared.impl.AbstractAutoBean;
import com.google.web.bindery.autobean.shared.impl.EnumMap;
import com.google.web.bindery.autobean.shared.impl.StringQuoter;
import com.google.web.bindery.event.shared.UmbrellaException;
import com.google.web.bindery.requestfactory.shared.BaseProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxy;
import com.google.web.bindery.requestfactory.shared.EntityProxyChange;
import com.google.web.bindery.requestfactory.shared.EntityProxyId;
import com.google.web.bindery.requestfactory.shared.FanoutReceiver;
import com.google.web.bindery.requestfactory.shared.Receiver;
import com.google.web.bindery.requestfactory.shared.Request;
import com.google.web.bindery.requestfactory.shared.RequestContext;
import com.google.web.bindery.requestfactory.shared.RequestTransport;
import com.google.web.bindery.requestfactory.shared.ServerFailure;
import com.google.web.bindery.requestfactory.shared.WriteOperation;
import com.google.web.bindery.requestfactory.shared.impl.AbstractRequest;
import com.google.web.bindery.requestfactory.shared.impl.AbstractRequestFactory;
import com.google.web.bindery.requestfactory.shared.impl.BaseProxyCategory;
import com.google.web.bindery.requestfactory.shared.impl.EntityCodex;
import com.google.web.bindery.requestfactory.shared.impl.MessageFactoryHolder;
import com.google.web.bindery.requestfactory.shared.impl.RequestData;
import com.google.web.bindery.requestfactory.shared.impl.SimpleProxyId;
import com.google.web.bindery.requestfactory.shared.impl.posers.DatePoser;
import com.google.web.bindery.requestfactory.shared.messages.IdMessage;
import com.google.web.bindery.requestfactory.shared.messages.InvocationMessage;
import com.google.web.bindery.requestfactory.shared.messages.JsonRpcRequest;
import com.google.web.bindery.requestfactory.shared.messages.MessageFactory;
import com.google.web.bindery.requestfactory.shared.messages.OperationMessage;
import com.google.web.bindery.requestfactory.shared.messages.RequestMessage;
import com.google.web.bindery.requestfactory.shared.messages.ResponseMessage;
import com.google.web.bindery.requestfactory.shared.messages.ServerFailureMessage;
import com.google.web.bindery.requestfactory.shared.messages.ViolationMessage;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.metadata.ConstraintDescriptor;

public abstract class AbstractRequestContext
implements RequestContext,
EntityCodex.EntitySource {
    private static final WriteOperation[] DELETE_ONLY = new WriteOperation[]{WriteOperation.DELETE};
    private static final WriteOperation[] PERSIST_AND_UPDATE = new WriteOperation[]{WriteOperation.PERSIST, WriteOperation.UPDATE};
    private static final WriteOperation[] UPDATE_ONLY = new WriteOperation[]{WriteOperation.UPDATE};
    private static int payloadId = 100;
    private State state;

    protected AbstractRequestContext(AbstractRequestFactory factory, Dialect dialect) {
        this.setState(new State(factory, dialect.create(this), this));
    }

    @Override
    public <T extends RequestContext> T append(T other) {
        AbstractRequestContext child = (AbstractRequestContext)other;
        if (!this.state.isCompatible(child.state)) {
            throw new IllegalStateException(this.getClass().getName() + " and " + child.getClass().getName() + " are not compatible");
        }
        if (!child.state.isClean()) {
            throw new IllegalStateException("The provided RequestContext has been changed");
        }
        child.setState(this.state);
        return other;
    }

    @Override
    public <T extends BaseProxy> T create(Class<T> clazz) {
        this.checkLocked();
        SimpleProxyId<T> id = this.state.requestFactory.allocateId(clazz);
        AutoBean<T> created = this.createProxy(clazz, id, false);
        return this.takeOwnership(created);
    }

    @Override
    public <T extends BaseProxy> T edit(T object) {
        return this.editProxy(object);
    }

    public <T extends BaseProxy> T editProxy(T object) {
        AutoBean<T> bean = this.checkStreamsNotCrossed(object);
        this.checkLocked();
        AutoBean<? extends BaseProxy> previouslySeen = this.state.editedProxies.get(BaseProxyCategory.stableId(bean));
        if (previouslySeen != null && !previouslySeen.isFrozen()) {
            return (T)previouslySeen.as();
        }
        AutoBean<T> parent = bean;
        bean = this.cloneBeanAndCollections(bean);
        bean.setTag("parentObject", parent);
        return bean.as();
    }

    @Override
    public <P extends EntityProxy> Request<P> find(final EntityProxyId<P> proxyId) {
        return new AbstractRequest<BaseProxy, P>(this, this){
            final /* synthetic */ AbstractRequestContext this$0;
            {
                this.this$0 = this$0;
                super(requestContext);
                this.requestContext.addInvocation(this);
            }

            @Override
            protected RequestData makeRequestData() {
                return new RequestData("?", new Object[]{proxyId}, this.propertyRefs, proxyId.getProxyClass(), null);
            }
        };
    }

    @Override
    public void fire() {
        boolean needsReceiver = true;
        for (AbstractRequest<?, ?> request : this.state.invocations) {
            if (!request.hasReceiver()) continue;
            needsReceiver = false;
            break;
        }
        if (needsReceiver) {
            this.doFire(new Receiver<Void>(){

                @Override
                public void onSuccess(Void response) {
                }
            });
        } else {
            this.doFire(null);
        }
    }

    @Override
    public void fire(Receiver<Void> receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException();
        }
        this.doFire(receiver);
    }

    @Override
    public <Q extends BaseProxy> AutoBean<Q> getBeanForPayload(Splittable serializedProxyId) {
        IdMessage ref = AutoBeanCodex.decode((AutoBeanFactory)MessageFactoryHolder.FACTORY, IdMessage.class, serializedProxyId).as();
        SimpleProxyId<BaseProxy> id = this.getId(ref);
        return this.getProxyForReturnPayloadGraph(id);
    }

    @Override
    public AbstractRequestFactory getRequestFactory() {
        return this.state.requestFactory;
    }

    @Override
    public Splittable getSerializedProxyId(SimpleProxyId<?> stableId) {
        AutoBean<IdMessage> bean = MessageFactoryHolder.FACTORY.id();
        IdMessage ref = bean.as();
        ref.setServerId(stableId.getServerId());
        ref.setTypeToken(this.getRequestFactory().getTypeToken(stableId.getProxyClass()));
        if (stableId.isSynthetic()) {
            ref.setStrength(IdMessage.Strength.SYNTHETIC);
            ref.setSyntheticId(stableId.getSyntheticId());
        } else if (stableId.isEphemeral()) {
            ref.setStrength(IdMessage.Strength.EPHEMERAL);
            ref.setClientId(stableId.getClientId());
        }
        return AutoBeanCodex.encode(bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChanged() {
        assert (!this.state.diffing);
        this.state.diffing = true;
        try {
            for (AutoBean<? extends BaseProxy> bean : this.state.editedProxies.values()) {
                AutoBean<? extends BaseProxy> previous = (AutoBean<? extends BaseProxy>)bean.getTag("parentObject");
                if (previous == null) {
                    Class<? extends BaseProxy> proxyClass = BaseProxyCategory.stableId(bean).getProxyClass();
                    previous = this.getAutoBeanFactory().create(proxyClass);
                }
                if (AutoBeanUtils.diff(previous, bean).isEmpty()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.state.diffing = false;
        }
    }

    @Override
    public boolean isEntityType(Class<?> clazz) {
        return this.state.requestFactory.isEntityType(clazz);
    }

    public boolean isLocked() {
        return this.state.locked;
    }

    @Override
    public boolean isValueType(Class<?> clazz) {
        return this.state.requestFactory.isValueType(clazz);
    }

    public void setFireDisabled(boolean disabled) {
        this.state.fireDisabled = disabled;
    }

    protected void addInvocation(AbstractRequest<?, ?> request) {
        this.state.dialect.addInvocation(request);
    }

    protected <T extends BaseProxy> AutoBean<T> createProxy(Class<T> clazz, SimpleProxyId<T> id, boolean useAppendedContexts) {
        AutoBean<T> created = null;
        if (useAppendedContexts) {
            AbstractRequestContext ctx;
            Iterator<AbstractRequestContext> iterator = this.state.appendedContexts.iterator();
            while (iterator.hasNext() && (created = (ctx = iterator.next()).getAutoBeanFactory().create(clazz)) == null) {
            }
        } else {
            created = this.getAutoBeanFactory().create(clazz);
        }
        if (created != null) {
            created.setTag("stableId", id);
            return created;
        }
        throw new IllegalArgumentException("Unknown proxy type " + clazz.getName());
    }

    protected void fail(Receiver<Void> receiver, ServerFailure failure) {
        this.reuse();
        failure.setRequestContext(this);
        HashSet<Throwable> causes = null;
        for (AbstractRequest<?, ?> request : new ArrayList(this.state.invocations)) {
            try {
                request.onFail(failure);
            }
            catch (Throwable t) {
                if (causes == null) {
                    causes = new HashSet();
                }
                causes.add(t);
            }
        }
        if (receiver != null) {
            try {
                receiver.onFailure(failure);
            }
            catch (Throwable t) {
                if (causes == null) {
                    causes = new HashSet<Throwable>();
                }
                causes.add(t);
            }
        }
        if (causes != null) {
            throw new UmbrellaException(causes);
        }
    }

    protected abstract AutoBeanFactory getAutoBeanFactory();

    protected void violation(Receiver<Void> receiver, Set<ConstraintViolation<?>> errors) {
        this.reuse();
        HashSet<Throwable> causes = null;
        for (AbstractRequest<?, ?> request : new ArrayList(this.state.invocations)) {
            try {
                request.onViolation(errors);
            }
            catch (Throwable t) {
                if (causes == null) {
                    causes = new HashSet();
                }
                causes.add(t);
            }
        }
        if (receiver != null) {
            try {
                receiver.onConstraintViolation(errors);
            }
            catch (Throwable t) {
                if (causes == null) {
                    causes = new HashSet<Throwable>();
                }
                causes.add(t);
            }
        }
        if (causes != null) {
            throw new UmbrellaException(causes);
        }
    }

    SimpleProxyId<BaseProxy> getId(IdMessage op) {
        if (IdMessage.Strength.SYNTHETIC.equals((Object)op.getStrength())) {
            return this.allocateSyntheticId(op.getTypeToken(), op.getSyntheticId());
        }
        return this.state.requestFactory.getId(op.getTypeToken(), op.getServerId(), op.getClientId());
    }

    <Q extends BaseProxy> AutoBean<Q> getProxyForReturnPayloadGraph(SimpleProxyId<Q> id) {
        AutoBean<Object> bean = this.state.returnedProxies.get(id);
        if (bean == null) {
            Class<Q> proxyClass = id.getProxyClass();
            bean = this.createProxy(proxyClass, id, true);
            this.state.returnedProxies.put(id, bean);
        }
        return bean;
    }

    boolean isDiffing() {
        return this.state.diffing;
    }

    AutoBean<OperationMessage> makeOperationMessage(SimpleProxyId<BaseProxy> stableId, AutoBean<?> proxyBean, boolean useDelta) {
        AutoBean<BaseProxy> parent;
        AutoBean<OperationMessage> toReturn = MessageFactoryHolder.FACTORY.operation();
        OperationMessage operation = toReturn.as();
        operation.setTypeToken(this.state.requestFactory.getTypeToken(stableId.getProxyClass()));
        if (stableId.isEphemeral()) {
            parent = this.createProxy(stableId.getProxyClass(), stableId, true);
            operation.setOperation(WriteOperation.PERSIST);
            operation.setClientId(stableId.getClientId());
            operation.setStrength(IdMessage.Strength.EPHEMERAL);
        } else if (stableId.isSynthetic()) {
            parent = this.createProxy(stableId.getProxyClass(), stableId, true);
            operation.setOperation(WriteOperation.PERSIST);
            operation.setSyntheticId(stableId.getSyntheticId());
            operation.setStrength(IdMessage.Strength.SYNTHETIC);
        } else {
            parent = (AutoBean<BaseProxy>)proxyBean.getTag("parentObject");
            operation.setServerId(stableId.getServerId());
            operation.setOperation(WriteOperation.UPDATE);
        }
        assert (!useDelta || parent != null);
        String version = (String)proxyBean.getTag("version");
        if (version != null) {
            operation.setVersion(version);
        }
        Map<Object, Object> diff = Collections.emptyMap();
        if (this.isEntityType(stableId.getProxyClass())) {
            diff = useDelta ? AutoBeanUtils.diff(parent, proxyBean) : AutoBeanUtils.getAllProperties(proxyBean);
        } else if (this.isValueType(stableId.getProxyClass())) {
            diff = AutoBeanUtils.getAllProperties(proxyBean);
        }
        if (!diff.isEmpty()) {
            HashMap<String, Splittable> propertyMap = new HashMap<String, Splittable>();
            for (Map.Entry<Object, Object> entry : diff.entrySet()) {
                propertyMap.put((String)entry.getKey(), EntityCodex.encode(this, entry.getValue()));
            }
            operation.setPropertyMap(propertyMap);
        }
        return toReturn;
    }

    <Q extends BaseProxy> Q processReturnOperation(SimpleProxyId<Q> id, OperationMessage op, WriteOperation ... operations) {
        AutoBean<Q> toMutate = this.getProxyForReturnPayloadGraph(id);
        toMutate.setTag("version", op.getVersion());
        final Map<String, Splittable> properties = op.getPropertyMap();
        if (properties != null) {
            toMutate.accept(new AutoBeanVisitor(this){
                final /* synthetic */ AbstractRequestContext this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
                    if (ctx.canSet() && properties.containsKey(propertyName)) {
                        Splittable raw = (Splittable)properties.get(propertyName);
                        Object decoded = null;
                        if (ctx.getType() == Map.class) {
                            AutoBeanVisitor.MapPropertyContext mapCtx = (AutoBeanVisitor.MapPropertyContext)ctx;
                            Class<?> keyType = mapCtx.getKeyType();
                            Class<?> valueType = mapCtx.getValueType();
                            decoded = EntityCodex.decode(this.this$0, mapCtx.getType(), keyType, valueType, raw);
                        } else {
                            Class<?> elementType = ctx instanceof AutoBeanVisitor.CollectionPropertyContext ? ((AutoBeanVisitor.CollectionPropertyContext)ctx).getElementType() : null;
                            decoded = EntityCodex.decode((EntityCodex.EntitySource)this.this$0, ctx.getType(), elementType, raw);
                        }
                        ctx.set(decoded);
                    }
                    return false;
                }

                @Override
                public boolean visitValueProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
                    if (ctx.canSet() && properties.containsKey(propertyName)) {
                        Splittable raw = (Splittable)properties.get(propertyName);
                        Object decoded = ValueCodex.decode(ctx.getType(), raw);
                        if (decoded != null && Date.class.equals(ctx.getType())) {
                            decoded = new DatePoser((Date)decoded);
                        }
                        ctx.set(decoded);
                    }
                    return false;
                }
            });
        }
        this.makeImmutable(toMutate);
        BaseProxy proxy = (BaseProxy)toMutate.as();
        if (operations != null && this.state.requestFactory.isEntityType(id.getProxyClass())) {
            for (WriteOperation writeOperation : operations) {
                if (writeOperation.equals((Object)WriteOperation.UPDATE) && !this.state.requestFactory.hasVersionChanged(id, op.getVersion())) continue;
                this.state.requestFactory.getEventBus().fireEventFromSource(new EntityProxyChange<EntityProxy>((EntityProxy)proxy, writeOperation), id.getProxyClass());
            }
        }
        return (Q)proxy;
    }

    private <Q extends BaseProxy> SimpleProxyId<Q> allocateSyntheticId(String typeToken, int syntheticId) {
        SimpleProxyId<Object> toReturn = this.state.syntheticIds.get(syntheticId);
        if (toReturn == null) {
            toReturn = this.state.requestFactory.allocateId(this.state.requestFactory.getTypeFromToken(typeToken));
            this.state.syntheticIds.put(syntheticId, toReturn);
        }
        return toReturn;
    }

    private void checkLocked() {
        if (this.state.locked) {
            throw new IllegalStateException("A request is already in progress");
        }
    }

    private <T> AutoBean<T> checkStreamsNotCrossed(T object) {
        AutoBean bean = AutoBeanUtils.getAutoBean(object);
        if (bean == null) {
            throw new IllegalArgumentException(object.getClass().getName());
        }
        State otherState = (State)bean.getTag("requestContext");
        if (!bean.isFrozen() && otherState != this.state) {
            assert (otherState != null) : "Unfrozen bean with null RequestContext";
            throw new IllegalArgumentException("Attempting to edit an EntityProxy previously edited by another RequestContext");
        }
        return bean;
    }

    private <T extends BaseProxy> AutoBean<T> cloneBeanAndCollections(final AutoBean<T> toClone) {
        AutoBean<T> clone = toClone.getFactory().create(toClone.getType());
        clone.setTag("stableId", toClone.getTag("stableId"));
        clone.setTag("version", toClone.getTag("version"));
        this.takeOwnership(clone);
        clone.accept(new AutoBeanVisitor(this){
            final Map<String, Object> values;
            final /* synthetic */ AbstractRequestContext this$0;
            {
                this.this$0 = this$0;
                this.values = AutoBeanUtils.getAllProperties(toClone);
            }

            @Override
            public boolean visitCollectionProperty(String propertyName, AutoBean<Collection<?>> value, AutoBeanVisitor.CollectionPropertyContext ctx) {
                value = AutoBeanUtils.getAutoBean((Collection)this.values.get(propertyName));
                if (value != null) {
                    AbstractCollection collection;
                    if (List.class == ctx.getType()) {
                        collection = new ArrayList();
                    } else if (Set.class == ctx.getType()) {
                        collection = new HashSet();
                    } else {
                        throw new IllegalArgumentException(ctx.getType().getName());
                    }
                    if (this.this$0.isValueType(ctx.getElementType()) || this.this$0.isEntityType(ctx.getElementType())) {
                        for (Object o : value.as()) {
                            if (o == null) {
                                collection.add(null);
                                continue;
                            }
                            collection.add(this.this$0.editProxy((BaseProxy)o));
                        }
                    } else {
                        collection.addAll(value.as());
                    }
                    ctx.set(collection);
                }
                return false;
            }

            @Override
            public boolean visitReferenceProperty(String propertyName, AutoBean<?> value, AutoBeanVisitor.PropertyContext ctx) {
                value = AutoBeanUtils.getAutoBean(this.values.get(propertyName));
                if (value != null) {
                    if (this.this$0.isValueType(ctx.getType()) || this.this$0.isEntityType(ctx.getType())) {
                        AutoBean<Object> valueBean = value;
                        ctx.set(this.this$0.editProxy((BaseProxy)valueBean.as()));
                    } else {
                        ctx.set(value.as());
                    }
                }
                return false;
            }

            @Override
            public boolean visitValueProperty(String propertyName, Object value, AutoBeanVisitor.PropertyContext ctx) {
                ctx.set(this.values.get(propertyName));
                return false;
            }
        });
        return clone;
    }

    private void doFire(Receiver<Void> receiver) {
        Receiver<Void> finalReceiver;
        if (this.state.fireDisabled) {
            if (receiver != null) {
                if (this.state.fanout == null) {
                    this.state.fanout = new FanoutReceiver();
                }
                this.state.fanout.add(receiver);
            }
            return;
        }
        if (this.state.fanout != null) {
            if (receiver != null) {
                this.state.fanout.add(receiver);
            }
            finalReceiver = this.state.fanout;
        } else {
            finalReceiver = receiver;
        }
        this.checkLocked();
        this.state.locked = true;
        this.freezeEntities(true);
        String payload = this.state.dialect.makePayload();
        this.state.requestFactory.getRequestTransport().send(payload, new RequestTransport.TransportReceiver(){
            final /* synthetic */ AbstractRequestContext this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onTransportFailure(ServerFailure failure) {
                this.this$0.fail(finalReceiver, failure);
            }

            @Override
            public void onTransportSuccess(String payload) {
                ((AbstractRequestContext)this.this$0).state.dialect.processPayload(finalReceiver, payload);
            }
        });
    }

    private void freezeEntities(boolean frozen) {
        for (AutoBean<? extends BaseProxy> bean : this.state.editedProxies.values()) {
            bean.setFrozen(frozen);
        }
    }

    private void makeImmutable(AutoBean<? extends BaseProxy> toMutate) {
        toMutate.setTag("parentObject", toMutate);
        toMutate.setTag("requestContext", null);
        toMutate.setFrozen(true);
    }

    private List<InvocationMessage> makePayloadInvocations() {
        MessageFactory f = MessageFactoryHolder.FACTORY;
        ArrayList<InvocationMessage> invocationMessages = new ArrayList<InvocationMessage>();
        for (AbstractRequest<?, ?> invocation : this.state.invocations) {
            RequestData data = invocation.getRequestData();
            InvocationMessage message = f.invocation().as();
            message.setOperation(data.getOperation());
            Set<String> refsToSend = data.getPropertyRefs();
            if (!refsToSend.isEmpty()) {
                message.setPropertyRefs(refsToSend);
            }
            ArrayList<Splittable> parameters = new ArrayList<Splittable>(data.getOrderedParameters().length);
            for (Object param : data.getOrderedParameters()) {
                parameters.add(EntityCodex.encode(this, param));
            }
            if (!parameters.isEmpty()) {
                message.setParameters(parameters);
            }
            invocationMessages.add(message);
        }
        return invocationMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<OperationMessage> makePayloadOperations() {
        assert (this.isLocked());
        assert (!this.state.diffing);
        this.state.diffing = true;
        try {
            ArrayList<OperationMessage> operations = new ArrayList<OperationMessage>();
            for (AutoBean<? extends BaseProxy> currentView : this.state.editedProxies.values()) {
                OperationMessage operation = this.makeOperationMessage(BaseProxyCategory.stableId(currentView), currentView, true).as();
                operations.add(operation);
            }
            ArrayList<OperationMessage> arrayList = operations;
            return arrayList;
        }
        finally {
            this.state.diffing = false;
        }
    }

    private void processReturnOperations(ResponseMessage response) {
        List<OperationMessage> ops = response.getOperations();
        if (ops == null) {
            return;
        }
        for (OperationMessage op : ops) {
            SimpleProxyId<BaseProxy> id = this.getId(op);
            WriteOperation[] toPropagate = null;
            WriteOperation effect = op.getOperation();
            if (effect != null) {
                switch (effect) {
                    case DELETE: {
                        toPropagate = DELETE_ONLY;
                        break;
                    }
                    case PERSIST: {
                        toPropagate = PERSIST_AND_UPDATE;
                        break;
                    }
                    case UPDATE: {
                        toPropagate = UPDATE_ONLY;
                        break;
                    }
                    default: {
                        throw new RuntimeException(effect.toString());
                    }
                }
            }
            this.processReturnOperation(id, op, toPropagate);
        }
        assert (this.state.returnedProxies.size() == ops.size());
    }

    private void retainArg(Object arg) {
        if (arg instanceof Iterable) {
            for (Object o : (Iterable)arg) {
                this.retainArg(o);
            }
        } else if (arg instanceof BaseProxy) {
            this.edit((BaseProxy)arg);
        }
    }

    private void reuse() {
        this.freezeEntities(false);
        this.state.locked = false;
    }

    private void setState(State state) {
        this.state = state;
        state.addContext(this);
    }

    private <T extends BaseProxy> T takeOwnership(AutoBean<T> bean) {
        this.state.editedProxies.put(BaseProxyCategory.stableId(bean), bean);
        bean.setTag("requestContext", this.state);
        return (T)((BaseProxy)bean.as());
    }

    protected static class State {
        public Set<AbstractRequestContext> appendedContexts;
        public final AbstractRequestContext canonical;
        public final DialectImpl dialect;
        public FanoutReceiver<Void> fanout;
        public boolean fireDisabled;
        public final List<AbstractRequest<?, ?>> invocations = new ArrayList();
        public boolean locked;
        public boolean diffing;
        public final Map<SimpleProxyId<?>, AutoBean<? extends BaseProxy>> editedProxies = new LinkedHashMap();
        public final Map<SimpleProxyId<?>, AutoBean<?>> returnedProxies = new HashMap();
        public final AbstractRequestFactory requestFactory;
        public final Map<Integer, SimpleProxyId<?>> syntheticIds = new HashMap();

        public State(AbstractRequestFactory requestFactory, DialectImpl dialect, AbstractRequestContext canonical) {
            this.requestFactory = requestFactory;
            this.canonical = canonical;
            this.dialect = dialect;
        }

        public void addContext(AbstractRequestContext ctx) {
            if (this.appendedContexts == null) {
                this.appendedContexts = Collections.singleton(ctx);
            } else {
                if (this.appendedContexts.size() == 1) {
                    this.appendedContexts = new LinkedHashSet<AbstractRequestContext>(this.appendedContexts);
                }
                this.appendedContexts.add(ctx);
            }
        }

        public AbstractRequestContext getCanonicalContext() {
            return this.canonical;
        }

        public boolean isClean() {
            return this.editedProxies.isEmpty() && this.invocations.isEmpty() && !this.locked && this.returnedProxies.isEmpty() && this.syntheticIds.isEmpty();
        }

        public boolean isCompatible(State state) {
            return this.requestFactory == state.requestFactory && this.dialect.getClass().equals(state.dialect.getClass());
        }
    }

    public static enum Dialect {
        STANDARD{

            @Override
            DialectImpl create(AbstractRequestContext context) {
                return context.new StandardPayloadDialect();
            }
        }
        ,
        JSON_RPC{

            @Override
            DialectImpl create(AbstractRequestContext context) {
                return context.new JsonRpcPayloadDialect();
            }
        };


        abstract DialectImpl create(AbstractRequestContext var1);
    }

    static interface DialectImpl {
        public void addInvocation(AbstractRequest<?, ?> var1);

        public String makePayload();

        public void processPayload(Receiver<Void> var1, String var2);
    }

    private class MyConstraintViolation
    implements ConstraintViolation<BaseProxy> {
        private final BaseProxy leafBean;
        private final String messageTemplate;
        private final String message;
        private final String path;
        private final BaseProxy rootBean;
        private final Class<? extends BaseProxy> rootBeanClass;

        public MyConstraintViolation(ViolationMessage msg) {
            AutoBean<? extends BaseProxy> leafProxy = this.findEditedProxy(msg.getLeafBeanId());
            this.leafBean = leafProxy == null ? null : leafProxy.as();
            this.message = msg.getMessage();
            this.messageTemplate = msg.getMessageTemplate();
            this.path = msg.getPath();
            AutoBean<? extends BaseProxy> rootProxy = this.findEditedProxy(msg.getRootBeanId());
            this.rootBeanClass = rootProxy.getType();
            this.rootBean = rootProxy.as();
        }

        public ConstraintDescriptor<?> getConstraintDescriptor() {
            return null;
        }

        public Object getInvalidValue() {
            return null;
        }

        public Object getLeafBean() {
            return this.leafBean;
        }

        public String getMessage() {
            return this.message;
        }

        public String getMessageTemplate() {
            return this.messageTemplate;
        }

        public Path getPropertyPath() {
            return new Path(){

                public Iterator<Path.Node> iterator() {
                    return Collections.emptyList().iterator();
                }

                public String toString() {
                    return MyConstraintViolation.this.path;
                }
            };
        }

        public BaseProxy getRootBean() {
            return this.rootBean;
        }

        public Class<BaseProxy> getRootBeanClass() {
            return this.rootBeanClass;
        }

        private AutoBean<? extends BaseProxy> findEditedProxy(IdMessage idMessage) {
            SimpleProxyId<BaseProxy> rootId = AbstractRequestContext.this.getId(idMessage);
            AutoBean<BaseProxy> stub = AbstractRequestContext.this.getProxyForReturnPayloadGraph(rootId);
            return ((AbstractRequestContext)AbstractRequestContext.this).state.editedProxies.get(BaseProxyCategory.stableId(stub));
        }
    }

    class StandardPayloadDialect
    implements DialectImpl {
        StandardPayloadDialect() {
        }

        @Override
        public void addInvocation(AbstractRequest<?, ?> request) {
            ((AbstractRequestContext)AbstractRequestContext.this).state.invocations.add(request);
            for (Object arg : request.getRequestData().getOrderedParameters()) {
                AbstractRequestContext.this.retainArg(arg);
            }
        }

        @Override
        public String makePayload() {
            MessageFactory f = MessageFactoryHolder.FACTORY;
            List operations = AbstractRequestContext.this.makePayloadOperations();
            List invocationMessages = AbstractRequestContext.this.makePayloadInvocations();
            AutoBean<RequestMessage> bean = f.request();
            RequestMessage requestMessage = bean.as();
            requestMessage.setRequestFactory(AbstractRequestContext.this.getRequestFactory().getFactoryTypeToken());
            if (!invocationMessages.isEmpty()) {
                requestMessage.setInvocations(invocationMessages);
            }
            if (!operations.isEmpty()) {
                requestMessage.setOperations(operations);
            }
            return AutoBeanCodex.encode(bean).getPayload();
        }

        @Override
        public void processPayload(Receiver<Void> receiver, String payload) {
            ResponseMessage response = AutoBeanCodex.decode((AutoBeanFactory)MessageFactoryHolder.FACTORY, ResponseMessage.class, payload).as();
            if (response.getGeneralFailure() != null) {
                ServerFailureMessage failure = response.getGeneralFailure();
                ServerFailure fail = new ServerFailure(failure.getMessage(), failure.getExceptionType(), failure.getStackTrace(), failure.isFatal());
                AbstractRequestContext.this.fail(receiver, fail);
                return;
            }
            if (response.getViolations() != null) {
                HashSet errors = new HashSet();
                for (ViolationMessage message : response.getViolations()) {
                    errors.add(new MyConstraintViolation(message));
                }
                AbstractRequestContext.this.violation(receiver, errors);
                return;
            }
            AbstractRequestContext.this.processReturnOperations(response);
            HashSet<Throwable> causes = null;
            int j = ((AbstractRequestContext)AbstractRequestContext.this).state.invocations.size();
            for (int i = 0; i < j; ++i) {
                try {
                    if (response.getStatusCodes().get(i).booleanValue()) {
                        ((AbstractRequestContext)AbstractRequestContext.this).state.invocations.get(i).onSuccess(response.getInvocationResults().get(i));
                        continue;
                    }
                    ServerFailureMessage failure = AutoBeanCodex.decode((AutoBeanFactory)MessageFactoryHolder.FACTORY, ServerFailureMessage.class, response.getInvocationResults().get(i)).as();
                    ((AbstractRequestContext)AbstractRequestContext.this).state.invocations.get(i).onFail(new ServerFailure(failure.getMessage(), failure.getExceptionType(), failure.getStackTrace(), failure.isFatal()));
                    continue;
                }
                catch (Throwable t) {
                    if (causes == null) {
                        causes = new HashSet<Throwable>();
                    }
                    causes.add(t);
                }
            }
            if (receiver != null) {
                try {
                    receiver.onSuccess(null);
                }
                catch (Throwable t) {
                    if (causes == null) {
                        causes = new HashSet();
                    }
                    causes.add(t);
                }
            }
            ((AbstractRequestContext)AbstractRequestContext.this).state.editedProxies.clear();
            ((AbstractRequestContext)AbstractRequestContext.this).state.invocations.clear();
            ((AbstractRequestContext)AbstractRequestContext.this).state.returnedProxies.clear();
            if (causes != null) {
                throw new UmbrellaException(causes);
            }
        }
    }

    class JsonRpcPayloadDialect
    implements DialectImpl {
        JsonRpcPayloadDialect() {
        }

        @Override
        public void addInvocation(AbstractRequest<?, ?> request) {
            if (!((AbstractRequestContext)AbstractRequestContext.this).state.invocations.isEmpty()) {
                throw new RuntimeException("Only one invocation per request, pending backend support");
            }
            ((AbstractRequestContext)AbstractRequestContext.this).state.invocations.add(request);
            for (Object arg : request.getRequestData().getOrderedParameters()) {
                AbstractRequestContext.this.retainArg(arg);
            }
        }

        @Override
        public String makePayload() {
            RequestData data = ((AbstractRequestContext)AbstractRequestContext.this).state.invocations.get(0).getRequestData();
            AutoBean<JsonRpcRequest> bean = MessageFactoryHolder.FACTORY.jsonRpcRequest();
            JsonRpcRequest request = bean.as();
            request.setVersion("2.0");
            request.setApiVersion(data.getApiVersion());
            request.setId(payloadId++);
            HashMap<String, Splittable> params = new HashMap<String, Splittable>();
            for (Map.Entry<String, Object> entry : data.getNamedParameters().entrySet()) {
                Object obj = entry.getValue();
                Splittable value = this.encode(obj);
                params.put(entry.getKey(), value);
            }
            if (data.getRequestResource() != null) {
                params.put("resource", this.encode(data.getRequestResource()));
            }
            request.setParams(params);
            request.setMethod(data.getOperation());
            return AutoBeanCodex.encode(bean).getPayload();
        }

        @Override
        public void processPayload(Receiver<Void> receiver, String payload) {
            Splittable raw = StringQuoter.split(payload);
            Receiver<?> callback = ((AbstractRequestContext)AbstractRequestContext.this).state.invocations.get(0).getReceiver();
            if (!raw.isNull("error")) {
                Splittable error = raw.get("error");
                ServerFailure failure = new ServerFailure(error.get("message").asString(), error.get("code").asString(), payload, true);
                AbstractRequestContext.this.fail(receiver, failure);
                return;
            }
            Splittable result = raw.get("result");
            Class<?> target = ((AbstractRequestContext)AbstractRequestContext.this).state.invocations.get(0).getRequestData().getReturnType();
            SimpleProxyId<?> id = AbstractRequestContext.this.getRequestFactory().allocateId(target);
            AutoBean<?> bean = AbstractRequestContext.this.createProxy(target, id, true);
            ((AbstractAutoBean)bean).setData(result);
            if (callback != null) {
                callback.onSuccess(bean.as());
            }
            if (receiver != null) {
                receiver.onSuccess(null);
            }
        }

        Splittable encode(Object obj) {
            if (obj == null) {
                return Splittable.NULL;
            }
            if (obj instanceof Collection) {
                return this.collectionEncode((Collection)obj);
            }
            return this.nonCollectionEncode(obj);
        }

        private Splittable collectionEncode(Collection<?> collection) {
            StringBuilder sb = new StringBuilder("[");
            Iterator<?> it = collection.iterator();
            if (it.hasNext()) {
                sb.append(this.nonCollectionEncode(it.next()).getPayload());
                while (it.hasNext()) {
                    sb.append(",");
                    sb.append(this.nonCollectionEncode(it.next()).getPayload());
                }
            }
            sb.append("]");
            return StringQuoter.split(sb.toString());
        }

        private Splittable nonCollectionEncode(Object obj) {
            if (obj instanceof Collection) {
                throw new RuntimeException("Unable to encode request as JSON payload; Request methods must have parameters of the form List<T> or Set<T>, where T is a scalar (non-collection) type.");
            }
            Splittable value = obj instanceof Enum && AbstractRequestContext.this.getAutoBeanFactory() instanceof EnumMap ? ValueCodex.encode(((EnumMap)((Object)AbstractRequestContext.this.getAutoBeanFactory())).getToken((Enum)obj)) : (ValueCodex.canDecode(obj.getClass()) ? ValueCodex.encode(obj) : AutoBeanCodex.encode(AutoBeanUtils.getAutoBean(obj)));
            return value;
        }
    }
}

