/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "sd" locale.
 */
public class LocalizedNamesImpl_sd extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "PK",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "IE",
        "IS",
        "CI",
        "AZ",
        "AU",
        "AT",
        "US",
        "AS",
        "VI",
        "UM",
        "MP",
        "KP",
        "AR",
        "JO",
        "AM",
        "UZ",
        "IL",
        "ES",
        "AF",
        "UN",
        "AL",
        "DZ",
        "SV",
        "AX",
        "AD",
        "IM",
        "AQ",
        "AG",
        "ID",
        "IN",
        "AO",
        "AI",
        "EH",
        "IR",
        "ER",
        "EE",
        "ET",
        "EC",
        "GQ",
        "IT",
        "BB",
        "BH",
        "BR",
        "IO",
        "VG",
        "GB",
        "BM",
        "BN",
        "BI",
        "BF",
        "BG",
        "BD",
        "BS",
        "BA",
        "BO",
        "BV",
        "BW",
        "QO",
        "BE",
        "BZ",
        "BJ",
        "BY",
        "TW",
        "TJ",
        "TM",
        "TR",
        "TC",
        "TZ",
        "TV",
        "TG",
        "TL",
        "TN",
        "GE",
        "JP",
        "GI",
        "JE",
        "DE",
        "JM",
        "RW",
        "RU",
        "RO",
        "RE",
        "ZW",
        "ZM",
        "ST",
        "CY",
        "RS",
        "LK",
        "SA",
        "SK",
        "SI",
        "WS",
        "SX",
        "CH",
        "SE",
        "SZ",
        "SJ",
        "SR",
        "SB",
        "SO",
        "SD",
        "SL",
        "SN",
        "LC",
        "MF",
        "KN",
        "SH",
        "SG",
        "SM",
        "BL",
        "VC",
        "PM",
        "EA",
        "SY",
        "SC",
        "AC",
        "IQ",
        "AW",
        "OM",
        "FO",
        "FK",
        "FJ",
        "FR",
        "PF",
        "TF",
        "GF",
        "PS",
        "PH",
        "FI",
        "KZ",
        "QA",
        "LR",
        "LA",
        "LV",
        "LB",
        "LY",
        "LS",
        "LT",
        "LI",
        "LU",
        "FM",
        "MQ",
        "MH",
        "MW",
        "MD",
        "MV",
        "ML",
        "MT",
        "AE",
        "MG",
        "EG",
        "MY",
        "MN",
        "MA",
        "MR",
        "MU",
        "MZ",
        "MC",
        "MS",
        "ME",
        "YT",
        "MM",
        "MK",
        "MX",
        "MO",
        "NR",
        "NE",
        "NG",
        "NO",
        "NF",
        "NU",
        "NL",
        "NA",
        "NZ",
        "NP",
        "NI",
        "NC",
        "HK",
        "HM",
        "HN",
        "HT",
        "WF",
        "VN",
        "VE",
        "VU",
        "VA",
        "CF",
        "YE",
        "EZ",
        "UY",
        "EU",
        "GR",
        "UA",
        "UG",
        "TA",
        "TT",
        "TO",
        "TK",
        "PG",
        "PK",
        "PT",
        "PW",
        "PA",
        "PL",
        "PY",
        "PE",
        "PR",
        "PN",
        "TH",
        "BT",
        "TD",
        "CL",
        "CN",
        "HU",
        "CZ",
        "DG",
        "DJ",
        "DM",
        "DO",
        "DK",
        "ZA",
        "GS",
        "SS",
        "KR",
        "CA",
        "CG",
        "CD",
        "KI",
        "CX",
        "KG",
        "HR",
        "CP",
        "KH",
        "XK",
        "CR",
        "CO",
        "KM",
        "KW",
        "CC",
        "CK",
        "BQ",
        "CM",
        "KY",
        "IC",
        "KE",
        "CU",
        "CW",
        "CV",
        "GA",
        "GL",
        "GD",
        "GN",
        "GW",
        "GH",
        "GT",
        "GU",
        "GP",
        "GG",
        "GY",
        "GM",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "دنيا");
    namesMap.put("002", "آفريڪا");
    namesMap.put("003", "اتر آمريڪا");
    namesMap.put("005", "ڏکڻ آمريڪا");
    namesMap.put("009", "سامونڊي");
    namesMap.put("011", "اولهه آفريقا");
    namesMap.put("013", "وچ آمريڪا");
    namesMap.put("014", "اوڀر آفريڪا");
    namesMap.put("015", "اترين آفريڪا");
    namesMap.put("017", "وچ آفريڪا");
    namesMap.put("018", "ڏاکڻي آمريڪا");
    namesMap.put("019", "آمريڪا");
    namesMap.put("021", "اترين آمريڪا");
    namesMap.put("029", "ڪيريبين");
    namesMap.put("030", "اوڀر ايشيا");
    namesMap.put("034", "ڏکڻ ايشيا");
    namesMap.put("035", "ڏکڻ اوڀر ايشيا");
    namesMap.put("039", "ڏکڻ يورپ");
    namesMap.put("053", "آسٽریلیشیا");
    namesMap.put("054", "میلانیشیا");
    namesMap.put("057", "مائڪرونيشائي خطو");
    namesMap.put("061", "پولینیشیا");
    namesMap.put("142", "ايشيا");
    namesMap.put("143", "وچ ايشيا");
    namesMap.put("145", "اولهه ايشيا");
    namesMap.put("150", "يورپ");
    namesMap.put("151", "اوڀر يورپ");
    namesMap.put("154", "اترين يورپ");
    namesMap.put("155", "اولهه يورپ");
    namesMap.put("202", "سب-سهارا آفريڪا");
    namesMap.put("419", "لاطيني آمريڪا");
    namesMap.put("AC", "طلوع ٻيٽ");
    namesMap.put("AD", "اندورا");
    namesMap.put("AE", "متحده عرب امارات");
    namesMap.put("AF", "افغانستان");
    namesMap.put("AG", "انٽيگئا و بربودا");
    namesMap.put("AI", "انگويلا");
    namesMap.put("AL", "البانيا");
    namesMap.put("AM", "ارمینیا");
    namesMap.put("AO", "انگولا");
    namesMap.put("AQ", "انٽارڪٽيڪا");
    namesMap.put("AR", "ارجنٽينا");
    namesMap.put("AS", "آمريڪي ساموا");
    namesMap.put("AT", "آشٽريا");
    namesMap.put("AU", "آسٽريليا");
    namesMap.put("AW", "عروبا");
    namesMap.put("AX", "الند ٻيٽ");
    namesMap.put("AZ", "آذربائيجان");
    namesMap.put("BA", "بوسنیا اور هرزیگوینا");
    namesMap.put("BB", "باربڊوس");
    namesMap.put("BD", "بنگلاديش");
    namesMap.put("BE", "بيلجيم");
    namesMap.put("BF", "برڪينا فاسو");
    namesMap.put("BG", "بلغاريا");
    namesMap.put("BH", "بحرين");
    namesMap.put("BI", "برونڊي");
    namesMap.put("BJ", "بينن");
    namesMap.put("BL", "سینٽ برٿلیمی");
    namesMap.put("BM", "برمودا");
    namesMap.put("BN", "برونائي");
    namesMap.put("BO", "بوليويا");
    namesMap.put("BQ", "ڪيريبين نيدرلينڊ");
    namesMap.put("BR", "برازيل");
    namesMap.put("BS", "بهاماس");
    namesMap.put("BT", "ڀوٽان");
    namesMap.put("BV", "بووٽ ٻيٽ");
    namesMap.put("BW", "بوٽسوانا");
    namesMap.put("BY", "بیلارس");
    namesMap.put("BZ", "بيليز");
    namesMap.put("CA", "ڪئناڊا");
    namesMap.put("CC", "ڪوڪوس ٻيٽ");
    namesMap.put("CD", "ڪانگو -ڪنشاسا");
    namesMap.put("CF", "وچ آفريقي جمهوريه");
    namesMap.put("CG", "ڪانگو - برازاویل");
    namesMap.put("CH", "سوئزرلينڊ");
    namesMap.put("CI", "آئيوري ڪنارو");
    namesMap.put("CK", "ڪوڪ ٻيٽ");
    namesMap.put("CL", "چلي");
    namesMap.put("CM", "ڪيمرون");
    namesMap.put("CN", "چين");
    namesMap.put("CO", "ڪولمبيا");
    namesMap.put("CP", "ڪلپرٽن ٻيٽ");
    namesMap.put("CR", "ڪوسٽا رڪا");
    namesMap.put("CU", "ڪيوبا");
    namesMap.put("CV", "ڪيپ وردي");
    namesMap.put("CW", "ڪيوراسائو");
    namesMap.put("CX", "ڪرسمس ٻيٽ");
    namesMap.put("CY", "سائپرس");
    namesMap.put("CZ", "چيڪيا");
    namesMap.put("DE", "جرمني");
    namesMap.put("DG", "ڊئيگو گارسيا");
    namesMap.put("DJ", "ڊجبيوتي");
    namesMap.put("DK", "ڊينمارڪ");
    namesMap.put("DM", "ڊومينيڪا");
    namesMap.put("DO", "ڊومينيڪن جمهوريه");
    namesMap.put("DZ", "الجيريا");
    namesMap.put("EA", "سیوٽا ۽ میلیلا");
    namesMap.put("EC", "ايڪواڊور");
    namesMap.put("EE", "ايسٽونيا");
    namesMap.put("EG", "مصر");
    namesMap.put("EH", "اولهه صحارا");
    namesMap.put("ER", "ايريٽيريا");
    namesMap.put("ES", "اسپين");
    namesMap.put("ET", "ايٿوپيا");
    namesMap.put("EU", "يورپين يونين");
    namesMap.put("EZ", "يورو زون");
    namesMap.put("FI", "فن لينڊ");
    namesMap.put("FJ", "فجي");
    namesMap.put("FK", "فاڪ لينڊ ٻيٽ");
    namesMap.put("FM", "مائڪرونيشيا");
    namesMap.put("FO", "فارو ٻيٽ");
    namesMap.put("FR", "فرانس");
    namesMap.put("GA", "گبون");
    namesMap.put("GB", "برطانيه");
    namesMap.put("GD", "گرينڊا");
    namesMap.put("GE", "جارجيا");
    namesMap.put("GF", "فرانسيسي گيانا");
    namesMap.put("GG", "گورنسي");
    namesMap.put("GH", "گهانا");
    namesMap.put("GI", "جبرالٽر");
    namesMap.put("GL", "گرين لينڊ");
    namesMap.put("GM", "گيمبيا");
    namesMap.put("GN", "گني");
    namesMap.put("GP", "گواڊیلوپ");
    namesMap.put("GQ", "ايڪوٽوريل گائينا");
    namesMap.put("GR", "يونان");
    namesMap.put("GS", "ڏکڻ جارجيا ۽ ڏکڻ سينڊوچ ٻيٽ");
    namesMap.put("GT", "گوئٽي مالا");
    namesMap.put("GU", "گوام");
    namesMap.put("GW", "گني بسائو");
    namesMap.put("GY", "گيانا");
    namesMap.put("HK", "هانگ ڪانگ");
    namesMap.put("HM", "هرڊ ۽ مڪڊونلڊ ٻيٽ");
    namesMap.put("HN", "هنڊورس");
    namesMap.put("HR", "ڪروئيشيا");
    namesMap.put("HT", "هيٽي");
    namesMap.put("HU", "چيڪ جهموريه");
    namesMap.put("IC", "ڪينري ٻيٽ");
    namesMap.put("ID", "انڊونيشيا");
    namesMap.put("IE", "آئرلينڊ");
    namesMap.put("IL", "اسرائيل");
    namesMap.put("IM", "انسانن جو ٻيٽ");
    namesMap.put("IN", "انڊيا");
    namesMap.put("IO", "برطانوي هندي سمنڊ خطو");
    namesMap.put("IQ", "عراق");
    namesMap.put("IR", "ايران");
    namesMap.put("IS", "آئس لينڊ");
    namesMap.put("IT", "اٽلي");
    namesMap.put("JE", "جرسي");
    namesMap.put("JM", "جميڪا");
    namesMap.put("JO", "اردن");
    namesMap.put("JP", "جاپان");
    namesMap.put("KE", "ڪينيا");
    namesMap.put("KG", "ڪرغستان");
    namesMap.put("KH", "ڪمبوڊيا");
    namesMap.put("KI", "ڪرباتي");
    namesMap.put("KM", "ڪوموروس");
    namesMap.put("KN", "سينٽ ڪٽس و نيوس");
    namesMap.put("KP", "اتر ڪوريا");
    namesMap.put("KR", "ڏکڻ ڪوريا");
    namesMap.put("KW", "ڪويت");
    namesMap.put("KY", "ڪي مين ٻيٽ");
    namesMap.put("KZ", "قازقستان");
    namesMap.put("LA", "لائوس");
    namesMap.put("LB", "لبنان");
    namesMap.put("LC", "سينٽ لوسيا");
    namesMap.put("LI", "لچي ٽينسٽين");
    namesMap.put("LK", "سري لنڪا");
    namesMap.put("LR", "لائبیریا");
    namesMap.put("LS", "ليسوٿو");
    namesMap.put("LT", "لٿونيا");
    namesMap.put("LU", "لیگزمبرگ");
    namesMap.put("LV", "لاتويا");
    namesMap.put("LY", "لبيا");
    namesMap.put("MA", "موروڪو");
    namesMap.put("MC", "موناڪو");
    namesMap.put("MD", "مالدووا");
    namesMap.put("ME", "مونٽي نيگرو");
    namesMap.put("MF", "سينٽ مارٽن");
    namesMap.put("MG", "مداگيسڪر");
    namesMap.put("MH", "مارشل ڀيٽ");
    namesMap.put("MK", "ميسي ڊونيا");
    namesMap.put("ML", "مالي");
    namesMap.put("MM", "ميانمار (برما)");
    namesMap.put("MN", "منگوليا");
    namesMap.put("MO", "مڪائو");
    namesMap.put("MP", "اتر مرينا ٻيٽ");
    namesMap.put("MQ", "مارتينڪ");
    namesMap.put("MR", "موريتانيا");
    namesMap.put("MS", "مونٽسراٽ");
    namesMap.put("MT", "مالٽا");
    namesMap.put("MU", "موريشس");
    namesMap.put("MV", "مالديپ");
    namesMap.put("MW", "مالاوي");
    namesMap.put("MX", "ميڪسيڪو");
    namesMap.put("MY", "ملائيشيا");
    namesMap.put("MZ", "موزمبیق");
    namesMap.put("NA", "نيميبيا");
    namesMap.put("NC", "نیو ڪالیڊونیا");
    namesMap.put("NE", "نائيجر");
    namesMap.put("NF", "نورفوڪ ٻيٽ");
    namesMap.put("NG", "نائيجيريا");
    namesMap.put("NI", "نڪراگوا");
    namesMap.put("NL", "نيدرلينڊ");
    namesMap.put("NO", "ناروي");
    namesMap.put("NP", "نيپال");
    namesMap.put("NR", "نائورو");
    namesMap.put("NU", "نووي");
    namesMap.put("NZ", "نيو زيلينڊ");
    namesMap.put("OM", "عمان");
    namesMap.put("PA", "پناما");
    namesMap.put("PE", "پيرو");
    namesMap.put("PF", "فرانسيسي پولينيشيا");
    namesMap.put("PG", "پاپوا نیو گني");
    namesMap.put("PH", "فلپائن");
    namesMap.put("PK", "پاڪستان");
    namesMap.put("PL", "پولينڊ");
    namesMap.put("PM", "سینٽ پیئر و میڪوئیلون");
    namesMap.put("PN", "پٽڪئرن ٻيٽ");
    namesMap.put("PR", "پيوئرٽو ريڪو");
    namesMap.put("PS", "فلسطيني حدون");
    namesMap.put("PT", "پرتگال");
    namesMap.put("PW", "پلائو");
    namesMap.put("PY", "پيراگوءِ");
    namesMap.put("QA", "قطر");
    namesMap.put("QO", "بيروني سامونڊي");
    namesMap.put("RE", "ري يونين");
    namesMap.put("RO", "رومانيا");
    namesMap.put("RS", "سربيا");
    namesMap.put("RU", "روس");
    namesMap.put("RW", "روانڊا");
    namesMap.put("SA", "سعودی عرب");
    namesMap.put("SB", "سولومون ٻيٽَ");
    namesMap.put("SC", "شي شلز");
    namesMap.put("SD", "سوڊان");
    namesMap.put("SE", "سوئيڊن");
    namesMap.put("SG", "سينگاپور");
    namesMap.put("SH", "سينٽ ھيلينا");
    namesMap.put("SI", "سلوینیا");
    namesMap.put("SJ", "سوالبارڊ ۽ جان ماین");
    namesMap.put("SK", "سلوواڪيا");
    namesMap.put("SL", "سيرا ليون");
    namesMap.put("SM", "سین مرینو");
    namesMap.put("SN", "سينيگال");
    namesMap.put("SO", "سوماليا");
    namesMap.put("SR", "سورينام");
    namesMap.put("SS", "ڏکڻ سوڊان");
    namesMap.put("ST", "سائو ٽوم ۽ پرنسپیي");
    namesMap.put("SV", "ال سلواڊور");
    namesMap.put("SX", "سنٽ مارٽن");
    namesMap.put("SY", "شام");
    namesMap.put("SZ", "سوازيلينڊ");
    namesMap.put("TA", "ٽرسٽن دا ڪوها");
    namesMap.put("TC", "ترڪ ۽ ڪيڪوس ٻيٽ");
    namesMap.put("TD", "چاڊ");
    namesMap.put("TF", "فرانسيسي ڏاکڻي علائقا");
    namesMap.put("TG", "توگو");
    namesMap.put("TH", "ٿائيليند");
    namesMap.put("TJ", "تاجڪستان");
    namesMap.put("TK", "ٽوڪلائو");
    namesMap.put("TL", "تيمور ليستي");
    namesMap.put("TM", "ترڪمانستان");
    namesMap.put("TN", "تيونيسيا");
    namesMap.put("TO", "ٽونگا");
    namesMap.put("TR", "ترڪي");
    namesMap.put("TT", "ٽريني ڊيڊ ۽ ٽوباگو ٻيٽ");
    namesMap.put("TV", "توالو");
    namesMap.put("TW", "تائیوان");
    namesMap.put("TZ", "تنزانيا");
    namesMap.put("UA", "يوڪرين");
    namesMap.put("UG", "يوگنڊا");
    namesMap.put("UM", "آمريڪي ٻاهريون ٻيٽ");
    namesMap.put("UN", "اقوام متحده");
    namesMap.put("US", "آمريڪا جون گڏيل رياستون");
    namesMap.put("UY", "يوروگوءِ");
    namesMap.put("UZ", "ازبڪستان");
    namesMap.put("VA", "ويٽڪين سٽي");
    namesMap.put("VC", "سینٽ ونسنت ۽ گریناڊینز");
    namesMap.put("VE", "وينزيلا");
    namesMap.put("VG", "برطانوي ورجن ٻيٽ");
    namesMap.put("VI", "آمريڪي ورجن ٻيٽ");
    namesMap.put("VN", "ويتنام");
    namesMap.put("VU", "وينيٽيو");
    namesMap.put("WF", "والس ۽ فتونا");
    namesMap.put("WS", "سموئا");
    namesMap.put("XK", "ڪوسووو");
    namesMap.put("YE", "يمن");
    namesMap.put("YT", "مياتي");
    namesMap.put("ZA", "ڏکڻ آفريقا");
    namesMap.put("ZM", "زيمبيا");
    namesMap.put("ZW", "زمبابوي");
    namesMap.put("ZZ", "اڻڄاتل خطو");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "دنيا",
        "002": "آفريڪا",
        "003": "اتر آمريڪا",
        "005": "ڏکڻ آمريڪا",
        "009": "سامونڊي",
        "011": "اولهه آفريقا",
        "013": "وچ آمريڪا",
        "014": "اوڀر آفريڪا",
        "015": "اترين آفريڪا",
        "017": "وچ آفريڪا",
        "018": "ڏاکڻي آمريڪا",
        "019": "آمريڪا",
        "021": "اترين آمريڪا",
        "029": "ڪيريبين",
        "030": "اوڀر ايشيا",
        "034": "ڏکڻ ايشيا",
        "035": "ڏکڻ اوڀر ايشيا",
        "039": "ڏکڻ يورپ",
        "053": "آسٽریلیشیا",
        "054": "میلانیشیا",
        "057": "مائڪرونيشائي خطو",
        "061": "پولینیشیا",
        "142": "ايشيا",
        "143": "وچ ايشيا",
        "145": "اولهه ايشيا",
        "150": "يورپ",
        "151": "اوڀر يورپ",
        "154": "اترين يورپ",
        "155": "اولهه يورپ",
        "202": "سب-سهارا آفريڪا",
        "419": "لاطيني آمريڪا",
        "AC": "طلوع ٻيٽ",
        "AD": "اندورا",
        "AE": "متحده عرب امارات",
        "AF": "افغانستان",
        "AG": "انٽيگئا و بربودا",
        "AI": "انگويلا",
        "AL": "البانيا",
        "AM": "ارمینیا",
        "AO": "انگولا",
        "AQ": "انٽارڪٽيڪا",
        "AR": "ارجنٽينا",
        "AS": "آمريڪي ساموا",
        "AT": "آشٽريا",
        "AU": "آسٽريليا",
        "AW": "عروبا",
        "AX": "الند ٻيٽ",
        "AZ": "آذربائيجان",
        "BA": "بوسنیا اور هرزیگوینا",
        "BB": "باربڊوس",
        "BD": "بنگلاديش",
        "BE": "بيلجيم",
        "BF": "برڪينا فاسو",
        "BG": "بلغاريا",
        "BH": "بحرين",
        "BI": "برونڊي",
        "BJ": "بينن",
        "BL": "سینٽ برٿلیمی",
        "BM": "برمودا",
        "BN": "برونائي",
        "BO": "بوليويا",
        "BQ": "ڪيريبين نيدرلينڊ",
        "BR": "برازيل",
        "BS": "بهاماس",
        "BT": "ڀوٽان",
        "BV": "بووٽ ٻيٽ",
        "BW": "بوٽسوانا",
        "BY": "بیلارس",
        "BZ": "بيليز",
        "CA": "ڪئناڊا",
        "CC": "ڪوڪوس ٻيٽ",
        "CD": "ڪانگو -ڪنشاسا",
        "CF": "وچ آفريقي جمهوريه",
        "CG": "ڪانگو - برازاویل",
        "CH": "سوئزرلينڊ",
        "CI": "آئيوري ڪنارو",
        "CK": "ڪوڪ ٻيٽ",
        "CL": "چلي",
        "CM": "ڪيمرون",
        "CN": "چين",
        "CO": "ڪولمبيا",
        "CP": "ڪلپرٽن ٻيٽ",
        "CR": "ڪوسٽا رڪا",
        "CU": "ڪيوبا",
        "CV": "ڪيپ وردي",
        "CW": "ڪيوراسائو",
        "CX": "ڪرسمس ٻيٽ",
        "CY": "سائپرس",
        "CZ": "چيڪيا",
        "DE": "جرمني",
        "DG": "ڊئيگو گارسيا",
        "DJ": "ڊجبيوتي",
        "DK": "ڊينمارڪ",
        "DM": "ڊومينيڪا",
        "DO": "ڊومينيڪن جمهوريه",
        "DZ": "الجيريا",
        "EA": "سیوٽا ۽ میلیلا",
        "EC": "ايڪواڊور",
        "EE": "ايسٽونيا",
        "EG": "مصر",
        "EH": "اولهه صحارا",
        "ER": "ايريٽيريا",
        "ES": "اسپين",
        "ET": "ايٿوپيا",
        "EU": "يورپين يونين",
        "EZ": "يورو زون",
        "FI": "فن لينڊ",
        "FJ": "فجي",
        "FK": "فاڪ لينڊ ٻيٽ",
        "FM": "مائڪرونيشيا",
        "FO": "فارو ٻيٽ",
        "FR": "فرانس",
        "GA": "گبون",
        "GB": "برطانيه",
        "GD": "گرينڊا",
        "GE": "جارجيا",
        "GF": "فرانسيسي گيانا",
        "GG": "گورنسي",
        "GH": "گهانا",
        "GI": "جبرالٽر",
        "GL": "گرين لينڊ",
        "GM": "گيمبيا",
        "GN": "گني",
        "GP": "گواڊیلوپ",
        "GQ": "ايڪوٽوريل گائينا",
        "GR": "يونان",
        "GS": "ڏکڻ جارجيا ۽ ڏکڻ سينڊوچ ٻيٽ",
        "GT": "گوئٽي مالا",
        "GU": "گوام",
        "GW": "گني بسائو",
        "GY": "گيانا",
        "HK": "هانگ ڪانگ",
        "HM": "هرڊ ۽ مڪڊونلڊ ٻيٽ",
        "HN": "هنڊورس",
        "HR": "ڪروئيشيا",
        "HT": "هيٽي",
        "HU": "چيڪ جهموريه",
        "IC": "ڪينري ٻيٽ",
        "ID": "انڊونيشيا",
        "IE": "آئرلينڊ",
        "IL": "اسرائيل",
        "IM": "انسانن جو ٻيٽ",
        "IN": "انڊيا",
        "IO": "برطانوي هندي سمنڊ خطو",
        "IQ": "عراق",
        "IR": "ايران",
        "IS": "آئس لينڊ",
        "IT": "اٽلي",
        "JE": "جرسي",
        "JM": "جميڪا",
        "JO": "اردن",
        "JP": "جاپان",
        "KE": "ڪينيا",
        "KG": "ڪرغستان",
        "KH": "ڪمبوڊيا",
        "KI": "ڪرباتي",
        "KM": "ڪوموروس",
        "KN": "سينٽ ڪٽس و نيوس",
        "KP": "اتر ڪوريا",
        "KR": "ڏکڻ ڪوريا",
        "KW": "ڪويت",
        "KY": "ڪي مين ٻيٽ",
        "KZ": "قازقستان",
        "LA": "لائوس",
        "LB": "لبنان",
        "LC": "سينٽ لوسيا",
        "LI": "لچي ٽينسٽين",
        "LK": "سري لنڪا",
        "LR": "لائبیریا",
        "LS": "ليسوٿو",
        "LT": "لٿونيا",
        "LU": "لیگزمبرگ",
        "LV": "لاتويا",
        "LY": "لبيا",
        "MA": "موروڪو",
        "MC": "موناڪو",
        "MD": "مالدووا",
        "ME": "مونٽي نيگرو",
        "MF": "سينٽ مارٽن",
        "MG": "مداگيسڪر",
        "MH": "مارشل ڀيٽ",
        "MK": "ميسي ڊونيا",
        "ML": "مالي",
        "MM": "ميانمار (برما)",
        "MN": "منگوليا",
        "MO": "مڪائو",
        "MP": "اتر مرينا ٻيٽ",
        "MQ": "مارتينڪ",
        "MR": "موريتانيا",
        "MS": "مونٽسراٽ",
        "MT": "مالٽا",
        "MU": "موريشس",
        "MV": "مالديپ",
        "MW": "مالاوي",
        "MX": "ميڪسيڪو",
        "MY": "ملائيشيا",
        "MZ": "موزمبیق",
        "NA": "نيميبيا",
        "NC": "نیو ڪالیڊونیا",
        "NE": "نائيجر",
        "NF": "نورفوڪ ٻيٽ",
        "NG": "نائيجيريا",
        "NI": "نڪراگوا",
        "NL": "نيدرلينڊ",
        "NO": "ناروي",
        "NP": "نيپال",
        "NR": "نائورو",
        "NU": "نووي",
        "NZ": "نيو زيلينڊ",
        "OM": "عمان",
        "PA": "پناما",
        "PE": "پيرو",
        "PF": "فرانسيسي پولينيشيا",
        "PG": "پاپوا نیو گني",
        "PH": "فلپائن",
        "PK": "پاڪستان",
        "PL": "پولينڊ",
        "PM": "سینٽ پیئر و میڪوئیلون",
        "PN": "پٽڪئرن ٻيٽ",
        "PR": "پيوئرٽو ريڪو",
        "PS": "فلسطيني حدون",
        "PT": "پرتگال",
        "PW": "پلائو",
        "PY": "پيراگوءِ",
        "QA": "قطر",
        "QO": "بيروني سامونڊي",
        "RE": "ري يونين",
        "RO": "رومانيا",
        "RS": "سربيا",
        "RU": "روس",
        "RW": "روانڊا",
        "SA": "سعودی عرب",
        "SB": "سولومون ٻيٽَ",
        "SC": "شي شلز",
        "SD": "سوڊان",
        "SE": "سوئيڊن",
        "SG": "سينگاپور",
        "SH": "سينٽ ھيلينا",
        "SI": "سلوینیا",
        "SJ": "سوالبارڊ ۽ جان ماین",
        "SK": "سلوواڪيا",
        "SL": "سيرا ليون",
        "SM": "سین مرینو",
        "SN": "سينيگال",
        "SO": "سوماليا",
        "SR": "سورينام",
        "SS": "ڏکڻ سوڊان",
        "ST": "سائو ٽوم ۽ پرنسپیي",
        "SV": "ال سلواڊور",
        "SX": "سنٽ مارٽن",
        "SY": "شام",
        "SZ": "سوازيلينڊ",
        "TA": "ٽرسٽن دا ڪوها",
        "TC": "ترڪ ۽ ڪيڪوس ٻيٽ",
        "TD": "چاڊ",
        "TF": "فرانسيسي ڏاکڻي علائقا",
        "TG": "توگو",
        "TH": "ٿائيليند",
        "TJ": "تاجڪستان",
        "TK": "ٽوڪلائو",
        "TL": "تيمور ليستي",
        "TM": "ترڪمانستان",
        "TN": "تيونيسيا",
        "TO": "ٽونگا",
        "TR": "ترڪي",
        "TT": "ٽريني ڊيڊ ۽ ٽوباگو ٻيٽ",
        "TV": "توالو",
        "TW": "تائیوان",
        "TZ": "تنزانيا",
        "UA": "يوڪرين",
        "UG": "يوگنڊا",
        "UM": "آمريڪي ٻاهريون ٻيٽ",
        "UN": "اقوام متحده",
        "US": "آمريڪا جون گڏيل رياستون",
        "UY": "يوروگوءِ",
        "UZ": "ازبڪستان",
        "VA": "ويٽڪين سٽي",
        "VC": "سینٽ ونسنت ۽ گریناڊینز",
        "VE": "وينزيلا",
        "VG": "برطانوي ورجن ٻيٽ",
        "VI": "آمريڪي ورجن ٻيٽ",
        "VN": "ويتنام",
        "VU": "وينيٽيو",
        "WF": "والس ۽ فتونا",
        "WS": "سموئا",
        "XK": "ڪوسووو",
        "YE": "يمن",
        "YT": "مياتي",
        "ZA": "ڏکڻ آفريقا",
        "ZM": "زيمبيا",
        "ZW": "زمبابوي",
        "ZZ": "اڻڄاتل خطو"
    };
  }-*/;
}
