/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.number;

import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsCloseTo
extends TypeSafeMatcher<Double> {
    private final double error;
    private final double value;

    public IsCloseTo(double value, double error) {
        this.error = error;
        this.value = value;
    }

    @Override
    public boolean matchesSafely(Double item) {
        return Math.abs(item - this.value) <= this.error;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("a numeric value within ").appendValue(this.error).appendText(" of ").appendValue(this.value);
    }

    @Factory
    public static Matcher<Double> closeTo(double operand, double error) {
        return new IsCloseTo(operand, error);
    }
}

