/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.object;

import java.util.EventObject;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsEventFrom
extends TypeSafeMatcher<EventObject> {
    private final Class eventClass;
    private final Object source;

    public IsEventFrom(Class eventClass, Object source) {
        this.eventClass = eventClass;
        this.source = source;
    }

    @Override
    public boolean matchesSafely(EventObject item) {
        return this.eventClass.isInstance(item) && this.eventHasSameSource(item);
    }

    private boolean eventHasSameSource(EventObject ev) {
        return ev.getSource() == this.source;
    }

    @Override
    public void describeTo(Description description) {
        description.appendText("an event of type ").appendText(this.eventClass.getName()).appendText(" from ").appendValue(this.source);
    }

    @Factory
    public static Matcher<EventObject> eventFrom(Class<? extends EventObject> eventClass, Object source) {
        return new IsEventFrom(eventClass, source);
    }

    @Factory
    public static Matcher<EventObject> eventFrom(Object source) {
        return IsEventFrom.eventFrom(EventObject.class, source);
    }
}

