/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.girr;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.girr.GirrException;
import org.harctoolbox.girr.Named;
import org.harctoolbox.girr.XmlExporter;
import org.harctoolbox.girr.XmlStatic;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreException;
import org.harctoolbox.ircore.IrCoreUtils;
import org.harctoolbox.ircore.IrSequence;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.ircore.ModulatedIrSequence;
import org.harctoolbox.ircore.OddSequenceLengthException;
import org.harctoolbox.ircore.Pronto;
import org.harctoolbox.ircore.ThisCannotHappenException;
import org.harctoolbox.irp.Assignment;
import org.harctoolbox.irp.Decoder;
import org.harctoolbox.irp.DomainViolationException;
import org.harctoolbox.irp.ElementaryDecode;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpDatabase;
import org.harctoolbox.irp.IrpException;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.IrpParseException;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.Protocol;
import org.harctoolbox.irp.ShortPronto;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Command
extends XmlExporter
implements Named {
    private static final Logger logger = Logger.getLogger(Command.class.getName());
    static final int INITIAL_HASHMAP_CAPACITY = 4;
    private static final int INITIAL_STRINGBUILDER_CAPACITY = 64;
    public static final String TOGGLE_PARAMETER_NAME = "T";
    public static final String F_PARAMETER_NAME = "F";
    public static final String D_PARAMETER_NAME = "D";
    public static final String S_PARAMETER_NAME = "S";
    private static final String DUMMY_COMMAND_NAME = "dummy-command";
    private static IrpDatabase irpDatabase = null;
    private static Decoder decoder = null;
    private static Decoder.DecoderParameters decoderParameters = new Decoder.DecoderParameters();
    private static boolean useInheritanceForXml = true;
    private static boolean acceptEmptyCommands = false;
    private Protocol protocol;
    private MasterType masterType;
    private final Map<String, String> notes;
    private final String name;
    private final String displayName;
    private String protocolName;
    private Map<String, Long> parameters;
    private Integer frequency;
    private Double dutyCycle;
    private String[] intro;
    private String[] repeat;
    private String[] ending;
    private String[] prontoHex;
    private final String comment;
    private Map<String, String> otherFormats;

    public static void setUseInheritanceForXml(boolean val) {
        useInheritanceForXml = val;
    }

    public static boolean isUseInheritanceForXml() {
        return useInheritanceForXml;
    }

    public static void setAcceptEmptyCommands(boolean acceptEmpties) {
        acceptEmptyCommands = acceptEmpties;
    }

    public static boolean isAcceptEmptyCommands() {
        return acceptEmptyCommands;
    }

    public static void setIrpDatabase(IrpDatabase newIrpDatabase) throws IrpParseException {
        irpDatabase = newIrpDatabase;
        decoder = new Decoder(irpDatabase);
    }

    public static void setDecoderParameters(Decoder.DecoderParameters newDecoderParameters) {
        decoderParameters = newDecoderParameters;
    }

    public static void setIrpDatabase(String irpProtocolsIniPath) throws IOException, IrpParseException, SAXException {
        Command.setIrpDatabase(new IrpDatabase(irpProtocolsIniPath));
    }

    private static String toPrintString(Map<String, Long> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder str = new StringBuilder(64);
        map.entrySet().forEach(kvp -> str.append((String)kvp.getKey()).append("=").append(Long.toString((Long)kvp.getValue())).append(" "));
        return str.substring(0, str.length() - 1);
    }

    private static void processRaw(Document doc, Element element, String sequence, String tagName, boolean fatRaw) {
        Element el = Command.toElement(doc, sequence, tagName, fatRaw);
        if (el != null) {
            element.appendChild(el);
        }
    }

    private static Element toElement(Document doc, String sequence, String tagName, boolean fatRaw) {
        if (sequence == null || sequence.isEmpty()) {
            return null;
        }
        Element el = doc.createElementNS("http://www.harctoolbox.org/Girr", tagName);
        if (fatRaw) {
            Command.insertFatElements(doc, el, sequence);
        } else {
            el.setTextContent(sequence);
        }
        return el;
    }

    private static void insertFatElements(Document doc, Element el, String sequence) {
        String[] durations = sequence.split(" ");
        for (int i = 0; i < durations.length; ++i) {
            String duration = durations[i].replaceAll("[\\+-]", "");
            Element e = doc.createElementNS("http://www.harctoolbox.org/Girr", i % 2 == 0 ? "flash" : "gap");
            e.setTextContent(duration);
            el.appendChild(e);
        }
    }

    private static String parseSequence(Element element) {
        if (element.getElementsByTagName("flash").getLength() > 0) {
            StringBuilder str = new StringBuilder(64);
            NodeList nl = element.getChildNodes();
            block8: for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i).getNodeType() != 1) continue;
                Element el = (Element)nl.item(i);
                switch (el.getTagName()) {
                    case "flash": {
                        str.append(" +").append(el.getTextContent());
                        continue block8;
                    }
                    case "gap": {
                        str.append(" -").append(el.getTextContent());
                        continue block8;
                    }
                    default: {
                        logger.log(Level.SEVERE, "Invalid tag name: {0}", el.getTagName());
                        throw new ThisCannotHappenException("Invalid tag name");
                    }
                }
            }
            return str.substring(1);
        }
        return element.getTextContent();
    }

    public static ModulatedIrSequence concatenateAsSequence(Collection<Command> commands) throws IrpException, IrCoreException {
        Double frequency = null;
        Double dutyCycle = null;
        IrSequence seq = new IrSequence();
        for (Command c : commands) {
            if (frequency == null) {
                frequency = c.getFrequency();
            }
            if (dutyCycle == null) {
                dutyCycle = c.getDutyCycle();
            }
            seq = seq.append((IrSequence)c.toIrSignal().toModulatedIrSequence(1));
        }
        return new ModulatedIrSequence(seq, frequency, dutyCycle);
    }

    public static boolean isKnownProtocol(String protocolName) {
        return protocolName != null && !protocolName.isEmpty() && irpDatabase.isKnownExpandAlias(protocolName);
    }

    private static Map<String, Long> mkMap(Long device, Long subdevice) {
        LinkedHashMap<String, Long> params = new LinkedHashMap<String, Long>(4);
        if (device != null) {
            params.put(D_PARAMETER_NAME, device);
        }
        if (subdevice != null) {
            params.put(S_PARAMETER_NAME, subdevice);
        }
        return params;
    }

    private static List<Assignment> parseTransformations(String str) {
        String[] array;
        ArrayList<Assignment> list = new ArrayList<Assignment>(8);
        String payload = str.trim().replaceFirst("^\\{", "").replaceFirst("\\}$", "").replaceAll("\\s*=\\s*", "=");
        for (String s : array = payload.split(",")) {
            list.add(new Assignment(s));
        }
        return list;
    }

    public Command(Element element, String inheritProtocol, Map<String, Long> inheritParameters) throws GirrException {
        this(MasterType.safeValueOf(element.getAttribute("master")), element.getAttribute("name"), element.getAttribute("comment"), element.getAttribute("displayName"), XmlStatic.parseElementsByLanguage(element.getElementsByTagName("notes")));
        if (!element.getTagName().equals("command")) {
            throw new GirrException("Element is not of type command");
        }
        this.protocolName = inheritProtocol != null ? irpDatabase.expandAlias(inheritProtocol) : null;
        this.parameters = new LinkedHashMap<String, Long>(4);
        if (inheritParameters != null) {
            this.parameters.putAll(inheritParameters);
        }
        this.otherFormats = new HashMap<String, String>(0);
        try {
            String Fstring;
            NodeList nl;
            NodeList paramsNodeList = element.getElementsByTagName("parameters");
            if (paramsNodeList.getLength() > 0) {
                Element params = (Element)paramsNodeList.item(0);
                String proto = params.getAttribute("protocol");
                if (!proto.isEmpty()) {
                    this.protocolName = irpDatabase.expandAlias(proto);
                }
                nl = params.getElementsByTagName("parameter");
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el = (Element)nl.item(i);
                    this.parameters.put(el.getAttribute("name"), IrCoreUtils.parseLong((String)el.getAttribute("value")));
                }
            }
            if (!(Fstring = element.getAttribute(F_PARAMETER_NAME)).isEmpty()) {
                this.parameters.put(F_PARAMETER_NAME, IrCoreUtils.parseLong((String)Fstring));
            }
            if ((nl = element.getElementsByTagName("raw")).getLength() > 0) {
                this.intro = new String[nl.getLength()];
                this.repeat = new String[nl.getLength()];
                this.ending = new String[nl.getLength()];
                for (int i = 0; i < nl.getLength(); ++i) {
                    NodeList nodeList;
                    String dc;
                    int T;
                    Element el = (Element)nl.item(i);
                    try {
                        T = Integer.parseInt(el.getAttribute(TOGGLE_PARAMETER_NAME));
                    }
                    catch (NumberFormatException ex) {
                        T = 0;
                    }
                    this.barfIfInvalidToggle(T, nl.getLength());
                    String freq = el.getAttribute("frequency");
                    if (!freq.isEmpty()) {
                        this.frequency = Integer.valueOf(freq);
                    }
                    if (!(dc = el.getAttribute("dutyCycle")).isEmpty()) {
                        this.dutyCycle = Double.valueOf(dc);
                        if (!ModulatedIrSequence.isValidDutyCycle((Double)this.dutyCycle)) {
                            throw new GirrException("Invalid dutyCycle: " + this.dutyCycle + "; must be between 0 and 1.");
                        }
                    }
                    if ((nodeList = el.getElementsByTagName("intro")).getLength() > 0) {
                        this.intro[T] = Command.parseSequence((Element)nodeList.item(0));
                    }
                    if ((nodeList = el.getElementsByTagName("repeat")).getLength() > 0) {
                        this.repeat[T] = Command.parseSequence((Element)nodeList.item(0));
                    }
                    if ((nodeList = el.getElementsByTagName("ending")).getLength() <= 0) continue;
                    this.ending[T] = Command.parseSequence((Element)nodeList.item(0));
                }
            }
            if ((nl = element.getElementsByTagName("ccf")).getLength() > 0) {
                this.prontoHex = new String[nl.getLength()];
                for (int i = 0; i < nl.getLength(); ++i) {
                    int T;
                    Element el = (Element)nl.item(i);
                    try {
                        T = Integer.parseInt(el.getAttribute(TOGGLE_PARAMETER_NAME));
                    }
                    catch (NumberFormatException ex) {
                        T = 0;
                    }
                    this.barfIfInvalidToggle(T, nl.getLength());
                    this.prontoHex[T] = el.getTextContent();
                }
            }
            nl = element.getElementsByTagName("format");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(0);
                this.otherFormats.put(el.getAttribute("name"), el.getTextContent());
            }
        }
        catch (IllegalArgumentException ex) {
            throw new GirrException(ex);
        }
        this.sanityCheck();
    }

    public Command(Element element) throws GirrException {
        this(element, null, null);
    }

    public Command(File file) throws GirrException, IOException, SAXException {
        this(Command.getElement(file));
    }

    public Command(Reader reader) throws IOException, SAXException, GirrException {
        this(Command.getElement(reader));
    }

    public Command(String name, String comment, IrSignal irSignal) {
        this(MasterType.raw, name, comment);
        this.generateRaw(irSignal);
    }

    public Command(String name, String comment, String protocolName, Map<String, Long> parameters, boolean check) throws GirrException {
        this(name, null, comment, null, protocolName, parameters, check);
    }

    public Command(String name, String displayName, String comment, Map<String, String> notes, String protocolName, Map<String, Long> parameters, boolean check) throws GirrException {
        this(MasterType.parameters, name, displayName, comment, notes);
        if (protocolName == null) {
            throw new GirrException("No protocol name");
        }
        this.parameters = new LinkedHashMap<String, Long>(parameters);
        String expandedProtocolName = irpDatabase.expandAlias(protocolName);
        try {
            this.protocol = irpDatabase.getProtocol(expandedProtocolName);
        }
        catch (IrpException ex) {
            if (check) {
                throw new GirrException(ex);
            }
            this.protocol = null;
        }
        this.protocolName = expandedProtocolName;
        this.sanityCheck();
    }

    public Command(String name, String comment, String protocolName, Map<String, Long> parameters) throws GirrException {
        this(name, comment, protocolName, parameters, true);
    }

    private Command(MasterType masterType, String name, String comment) {
        this(masterType, name, comment, null, null);
    }

    private Command(MasterType masterType, String name, String comment, String displayName, Map<String, String> notes) {
        this.masterType = masterType;
        this.name = name;
        this.comment = comment;
        this.displayName = displayName;
        this.otherFormats = new HashMap<String, String>(0);
        this.notes = notes != null ? notes : new HashMap(0);
        this.frequency = null;
        this.dutyCycle = null;
        this.prontoHex = null;
        this.intro = null;
        this.repeat = null;
        this.ending = null;
    }

    public Command(String name, String comment, String prontoHex) throws GirrException {
        this(MasterType.ccf, name, comment);
        this.prontoHex = new String[1];
        this.prontoHex[0] = prontoHex;
        this.sanityCheck();
    }

    public Command(String name) {
        this(MasterType.empty, name, null);
    }

    public Command(String protocolName, Long device, Long subdevice) {
        this(MasterType.empty, DUMMY_COMMAND_NAME, null);
        this.parameters = Command.mkMap(device, subdevice);
        this.protocolName = protocolName;
    }

    public Command() {
        this(DUMMY_COMMAND_NAME);
    }

    public double getDutyCycle() throws IrpException {
        if (this.masterType == MasterType.parameters) {
            this.checkForProtocol();
            return this.protocol.getDutyCycle();
        }
        return this.dutyCycle;
    }

    public String getComment() {
        return this.comment;
    }

    public String getNotes(String lang) {
        return this.notes.get(lang);
    }

    public MasterType getMasterType() {
        return this.masterType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getProtocolName() throws IrpException, IrCoreException {
        this.checkForParameters();
        return this.protocolName;
    }

    public Map<String, Long> getParameters() throws IrpException, IrCoreException {
        this.checkForParameters();
        return this.parameters != null ? Collections.unmodifiableMap(this.parameters) : null;
    }

    public double getFrequency() throws IrpException {
        if (this.masterType == MasterType.parameters) {
            this.checkForProtocol();
            return this.protocol.getFrequency();
        }
        return this.frequency.intValue();
    }

    private void checkForProtocol() throws IrpException {
        if (this.protocol == null) {
            this.protocol = irpDatabase.getProtocol(this.protocolName);
        }
    }

    private boolean checkIfProtocol() {
        if (this.protocol != null) {
            return true;
        }
        if (this.protocolName == null || this.protocolName.isEmpty()) {
            return false;
        }
        if (irpDatabase.isKnown(this.protocolName)) {
            try {
                this.protocol = irpDatabase.getProtocol(this.protocolName);
            }
            catch (IrpException ex) {
                throw new ThisCannotHappenException();
            }
        }
        return this.protocol != null;
    }

    public String getIntro() throws GirrException, IrCoreException, IrpException {
        return this.getIntro(0);
    }

    public String getIntro(int T) throws GirrException, IrCoreException, IrpException {
        this.checkForRaw();
        this.barfIfInvalidToggle(T);
        return this.intro[T];
    }

    public String getRepeat() throws GirrException, IrCoreException, IrpException {
        return this.getRepeat(0);
    }

    public String getRepeat(int T) throws GirrException, IrCoreException, IrpException {
        this.checkForRaw();
        this.barfIfInvalidToggle(T);
        return this.repeat[T];
    }

    public String getEnding() throws GirrException, IrpException, IrCoreException {
        return this.getEnding(0);
    }

    public String getEnding(int T) throws GirrException, IrpException, IrCoreException {
        this.checkForRaw();
        this.barfIfInvalidToggle(T);
        return this.ending[T];
    }

    public String getProntoHex() throws GirrException, IrpException, IrCoreException {
        return this.getProntoHex(0);
    }

    public String getProntoHex(int T) throws GirrException, IrpException, IrCoreException {
        this.checkForProntoHex();
        this.barfIfInvalidToggle(T);
        return this.prontoHex[T];
    }

    private void barfIfInvalidToggle(Integer T) {
        this.barfIfInvalidToggle(T, this.numberOfToggleValues());
    }

    private void barfIfInvalidToggle(Integer T, int noToggles) {
        if (T != null && (T < 0 || T >= noToggles)) {
            throw new IllegalArgumentException("Illegal value of T = " + T);
        }
    }

    public Collection<String> getOtherFormats() {
        return this.otherFormats.keySet();
    }

    public String getFormat(String name) {
        return this.otherFormats != null ? this.otherFormats.get(name) : null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public IrSignal toIrSignal() throws IrpException, IrCoreException {
        return this.toIrSignal(null);
    }

    public IrSignal toIrSignal(Integer toggle) throws IrpException, IrCoreException {
        this.barfIfInvalidToggle(toggle);
        int T = toggle == null ? 0 : toggle;
        switch (this.masterType) {
            case parameters: {
                if (toggle != null) {
                    LinkedHashMap<String, Long> params = new LinkedHashMap<String, Long>(this.parameters);
                    params.put(TOGGLE_PARAMETER_NAME, toggle.longValue());
                    return irpDatabase.render(this.protocolName, params);
                }
                return irpDatabase.render(this.protocolName, this.parameters);
            }
            case raw: {
                return new IrSignal(this.intro[T], this.repeat[T], this.ending[T], this.frequency != null ? Double.valueOf(this.frequency.doubleValue()) : null, this.dutyCycle);
            }
            case ccf: {
                return ShortPronto.parse((String)this.prontoHex[T]);
            }
            case empty: {
                return null;
            }
        }
        throw new ThisCannotHappenException();
    }

    public String nameProtocolParameterString() {
        StringBuilder str = new StringBuilder(this.name != null ? this.name : "<no_name>");
        if (this.protocolName == null) {
            str.append(": <no decode>");
        } else {
            str.append(": ").append(this.protocolName);
            if (this.parameters.containsKey(D_PARAMETER_NAME)) {
                str.append(" Device: ").append(this.parameters.get(D_PARAMETER_NAME));
            }
            if (this.parameters.containsKey(S_PARAMETER_NAME)) {
                str.append(".").append(this.parameters.get(S_PARAMETER_NAME));
            }
            if (this.parameters.containsKey(F_PARAMETER_NAME)) {
                str.append(" Function: ").append(this.parameters.get(F_PARAMETER_NAME));
            }
            this.parameters.entrySet().forEach(kvp -> {
                String parName = (String)kvp.getKey();
                if (!(parName.equals(F_PARAMETER_NAME) || parName.equals(D_PARAMETER_NAME) || parName.equals(S_PARAMETER_NAME))) {
                    str.append(" ").append(parName).append("=").append(kvp.getValue());
                }
            });
        }
        return str.toString();
    }

    public String prettyValueString() {
        if (this.masterType == MasterType.empty) {
            return "Empty";
        }
        try {
            this.checkForParameters();
        }
        catch (IrCoreException | IrpException ex) {
            return "Undecoded signal";
        }
        return this.parameters != null && !this.parameters.isEmpty() ? this.protocolName + ", " + Command.toPrintString(this.parameters) : (this.prontoHex != null ? this.prontoHex[0] : "Undecoded signal");
    }

    public String toPrintString() throws IrpException, IrCoreException, GirrException {
        StringBuilder str = new StringBuilder(this.name != null ? this.name : "<unnamed>");
        str.append(": ");
        if (this.parameters != null) {
            str.append(this.protocolName).append(", ").append(Command.toPrintString(this.parameters));
        } else if (this.prontoHex != null) {
            str.append(this.getProntoHex());
        } else {
            str.append(this.toIrSignal().toString(true));
        }
        return str.toString();
    }

    public String toString() {
        if (this.masterType == MasterType.empty) {
            return "Empty";
        }
        try {
            return this.toPrintString();
        }
        catch (GirrException | IrCoreException | IrpException ex) {
            logger.log(Level.WARNING, null, ex);
            return this.name + ": (<erroneous signal>)";
        }
    }

    private void sanityCheck() throws GirrException {
        boolean prontoHexOk;
        boolean protocolOk = this.protocolName != null && !this.protocolName.isEmpty();
        boolean parametersOk = this.parameters != null;
        boolean rawOk = this.intro != null && this.intro[0] != null && !this.intro[0].isEmpty() || this.repeat != null && this.repeat[0] != null && !this.repeat[0].isEmpty();
        boolean bl = prontoHexOk = this.prontoHex != null && this.prontoHex[0] != null && !this.prontoHex[0].isEmpty();
        if (this.masterType == null) {
            MasterType masterType = protocolOk && parametersOk ? MasterType.parameters : (rawOk ? MasterType.raw : (this.masterType = prontoHexOk ? MasterType.ccf : MasterType.empty));
        }
        if (!acceptEmptyCommands && this.masterType == MasterType.empty) {
            throw new GirrException("Command " + this.name + ": Empty commands not allowed.");
        }
        if (this.masterType == MasterType.parameters && !protocolOk) {
            throw new GirrException("Command " + this.name + ": MasterType is parameters, but no protocol found.");
        }
        if (this.masterType == MasterType.parameters && !parametersOk) {
            throw new GirrException("Command " + this.name + ": MasterType is parameters, but no parameters found.");
        }
        if (this.masterType == MasterType.raw && !rawOk) {
            throw new GirrException("Command " + this.name + ": MasterType is raw, but both intro- and repeat-sequence empty.");
        }
        if (this.masterType == MasterType.ccf && !prontoHexOk) {
            throw new GirrException("Command " + this.name + ": MasterType is prontoHex, but no Pronto Hex found.");
        }
    }

    private void generateRawProntoHexAllT(boolean generateRaw, boolean generateProntoHex) throws GirrException, DomainViolationException, NameUnassignedException, IrpInvalidArgumentException, InvalidNameException, OddSequenceLengthException {
        if (this.numberOfToggleValues() == 1) {
            this.generateRawProntoHex(generateRaw, generateProntoHex);
        } else {
            for (int T = 0; T < this.numberOfToggleValues(); ++T) {
                this.generateRawProntoHexForceT(T, generateRaw, generateProntoHex);
            }
        }
    }

    private void generateRawProntoHexForceT(int T, boolean generateRaw, boolean generateProntoHex) throws DomainViolationException, NameUnassignedException, IrpInvalidArgumentException, InvalidNameException, OddSequenceLengthException {
        LinkedHashMap<String, Long> params = new LinkedHashMap<String, Long>(this.parameters);
        params.put(TOGGLE_PARAMETER_NAME, Long.valueOf(T));
        this.generateRawProntoHex(params, T, generateRaw, generateProntoHex);
    }

    private void generateRawProntoHex(boolean generateRaw, boolean generateProntoHex) throws GirrException, DomainViolationException, NameUnassignedException, IrpInvalidArgumentException, InvalidNameException, OddSequenceLengthException {
        if (!this.checkIfProtocol()) {
            throw new GirrException("protocol named " + this.protocolName + " not found or erroneous");
        }
        IrSignal irSignal = this.protocol.toIrSignal(this.parameters);
        if (generateRaw) {
            this.generateRaw(irSignal);
        }
        if (generateProntoHex) {
            this.generateProntoHex(irSignal);
        }
    }

    private void generateRawProntoHex(Map<String, Long> parameters, int T, boolean generateRaw, boolean generateProntoHex) throws DomainViolationException, NameUnassignedException, IrpInvalidArgumentException, InvalidNameException, OddSequenceLengthException {
        IrSignal irSignal = this.protocol.toIrSignal(parameters);
        if (generateRaw) {
            this.generateRaw(irSignal, T);
        }
        if (generateProntoHex) {
            this.generateProntoHex(irSignal, T);
        }
    }

    private void generateDecode(IrSignal irSignal) {
        if (irSignal == null) {
            this.notes.put("en", "No signal information.");
            return;
        }
        Decoder.AbstractDecodesCollection decodes = decoder.decodeLoose(irSignal, decoderParameters);
        if (decodes.isEmpty()) {
            this.notes.put("en", "Decoding was invoked, but found no decode.");
        } else {
            ElementaryDecode firstDecode = decodes.first();
            this.protocolName = firstDecode.getName();
            this.parameters = firstDecode.getMap();
        }
        if (decodes.size() > 1) {
            this.notes.put("en", "Several decodes");
        }
    }

    public void checkForParameters() throws IrpException, IrCoreException {
        if (this.parameters == null || this.parameters.isEmpty()) {
            this.generateDecode(this.toIrSignal());
        }
    }

    private void checkForRaw() throws GirrException, DomainViolationException, NameUnassignedException, IrpInvalidArgumentException, InvalidArgumentException, Pronto.NonProntoFormatException, InvalidNameException {
        if (this.intro != null || this.repeat != null || this.ending != null) {
            return;
        }
        if (this.masterType == MasterType.parameters) {
            this.generateRawProntoHexAllT(true, false);
        } else {
            IrSignal irSignal = Pronto.parse((String)this.prontoHex[0]);
            this.generateRaw(irSignal);
        }
    }

    private void checkForProntoHex() throws GirrException, IrpInvalidArgumentException, DomainViolationException, NameUnassignedException, OddSequenceLengthException, InvalidNameException {
        if (this.prontoHex != null) {
            return;
        }
        if (this.masterType == MasterType.parameters) {
            this.generateRawProntoHexAllT(false, true);
        } else {
            IrSignal irSignal = new IrSignal(this.intro[0], this.repeat[0], this.ending[0], this.frequency != null ? Double.valueOf(this.frequency.doubleValue()) : null, this.dutyCycle);
            this.generateProntoHex(irSignal);
        }
    }

    private void checkFor(MasterType type) throws GirrException, DomainViolationException, NameUnassignedException, IrpInvalidArgumentException, InvalidArgumentException, Pronto.NonProntoFormatException, InvalidNameException, IrpException, IrCoreException {
        switch (type) {
            case parameters: {
                this.checkForParameters();
                break;
            }
            case ccf: {
                this.checkForProntoHex();
                break;
            }
            case raw: {
                this.checkForRaw();
                break;
            }
        }
    }

    public int numberOfToggleValues() {
        if (!this.checkIfProtocol()) {
            return 1;
        }
        return this.masterType == MasterType.parameters && !this.parameters.containsKey(TOGGLE_PARAMETER_NAME) && this.protocol != null && this.protocol.hasParameter(TOGGLE_PARAMETER_NAME) && this.protocol.hasParameterMemory(TOGGLE_PARAMETER_NAME) ? (int)this.protocol.getParameterMax(TOGGLE_PARAMETER_NAME) + 1 : 1;
    }

    private void generateRaw(IrSignal irSignal) {
        this.generateRaw(irSignal, 0);
    }

    private void generateRaw(IrSignal irSignal, int T) {
        this.barfIfInvalidToggle(T);
        this.frequency = irSignal.getFrequency() != null ? Integer.valueOf(irSignal.getFrequency().intValue()) : null;
        this.dutyCycle = irSignal.getDutyCycle();
        if (this.intro == null) {
            this.intro = new String[this.numberOfToggleValues()];
        }
        this.intro[T] = irSignal.getIntroSequence().toString(true, " ", "", "");
        if (this.repeat == null) {
            this.repeat = new String[this.numberOfToggleValues()];
        }
        this.repeat[T] = irSignal.getRepeatSequence().toString(true, " ", "", "");
        if (this.ending == null) {
            this.ending = new String[this.numberOfToggleValues()];
        }
        this.ending[T] = irSignal.getEndingSequence().toString(true, " ", "", "");
    }

    private void generateProntoHex(IrSignal irSignal) {
        this.generateProntoHex(irSignal, 0);
    }

    private void generateProntoHex(IrSignal irSignal, int T) {
        this.barfIfInvalidToggle(T);
        if (this.prontoHex == null) {
            this.prontoHex = new String[this.numberOfToggleValues()];
        }
        this.prontoHex[T] = Pronto.toString((IrSignal)irSignal);
    }

    public void addFormat(String name, String value) {
        if (this.otherFormats == null) {
            this.otherFormats = new HashMap<String, String>(1);
        }
        this.otherFormats.put(name, value);
    }

    public void addFormat(CommandTextFormat format, int repeatCount) throws IrpException, IrCoreException {
        this.addFormat(format.getName(), format.format(this.toIrSignal(), repeatCount));
    }

    @Override
    Element toElement(Document doc, boolean fatRaw, boolean generateParameters, boolean generateProntoHex, boolean generateRaw) {
        return this.toElement(doc, fatRaw, generateParameters, generateProntoHex, generateRaw, null, null);
    }

    Element toElement(Document doc, boolean fatRaw, boolean generateParameters, boolean generateProntoHex, boolean generateRaw, String inheritedProtocolName, Map<String, Long> inheritedParameters) {
        Element element = doc.createElementNS("http://www.harctoolbox.org/Girr", "command");
        element.setAttribute("name", this.name);
        MasterType actualMasterType = this.actualMasterType(generateParameters, generateProntoHex, generateRaw);
        if (actualMasterType != null) {
            element.setAttribute("master", actualMasterType.name());
        }
        if (this.comment != null && !this.comment.isEmpty()) {
            element.setAttribute("comment", this.comment);
        }
        if (this.displayName != null && !this.displayName.isEmpty()) {
            element.setAttribute("displayName", this.displayName);
        }
        this.notes.entrySet().stream().map(note -> {
            Element notesEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "notes");
            notesEl.setAttribute("xml:lang", (String)note.getKey());
            notesEl.setTextContent((String)note.getValue());
            return notesEl;
        }).forEachOrdered(notesEl -> element.appendChild((Node)notesEl));
        if (generateParameters || actualMasterType == MasterType.parameters) {
            try {
                this.checkForParameters();
                if (this.parameters != null) {
                    if (this.canReduce(inheritedProtocolName, inheritedParameters)) {
                        Long parameterF = this.parameters.get(F_PARAMETER_NAME);
                        if (parameterF != null) {
                            element.setAttribute(F_PARAMETER_NAME, parameterF.toString());
                        }
                    } else {
                        Element parametersEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "parameters");
                        if (this.protocolName != null) {
                            parametersEl.setAttribute("protocol", this.protocolName);
                        }
                        element.appendChild(parametersEl);
                        this.parameters.entrySet().stream().map(parameter -> {
                            Element parameterEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "parameter");
                            parameterEl.setAttribute("name", (String)parameter.getKey());
                            parameterEl.setAttribute("value", ((Long)parameter.getValue()).toString());
                            return parameterEl;
                        }).forEachOrdered(parameterEl -> parametersEl.appendChild((Node)parameterEl));
                    }
                }
            }
            catch (IrCoreException | IrpException ex) {
                logger.log(Level.INFO, null, ex);
                element.appendChild(doc.createComment("Parameters requested but could not be generated."));
            }
        }
        if (generateRaw || actualMasterType == MasterType.raw) {
            try {
                this.checkForRaw();
                if (this.intro != null || this.repeat != null || this.ending != null) {
                    for (int T = 0; T < this.numberOfToggleValues(); ++T) {
                        Element rawEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "raw");
                        rawEl.setAttribute("frequency", Integer.toString(this.frequency != null ? this.frequency : 38000));
                        if (this.dutyCycle != null && this.dutyCycle > 0.0) {
                            rawEl.setAttribute("dutyCycle", Double.toString(this.dutyCycle));
                        }
                        if (this.numberOfToggleValues() > 1) {
                            rawEl.setAttribute(TOGGLE_PARAMETER_NAME, Integer.toString(T));
                        }
                        element.appendChild(rawEl);
                        Command.processRaw(doc, rawEl, this.intro[T], "intro", fatRaw);
                        Command.processRaw(doc, rawEl, this.repeat[T], "repeat", fatRaw);
                        Command.processRaw(doc, rawEl, this.ending[T], "ending", fatRaw);
                    }
                }
            }
            catch (GirrException | IrCoreException | IrpException ex) {
                logger.log(Level.INFO, "{0}", ex.getMessage());
                element.appendChild(doc.createComment("Raw signal requested but could not be generated: " + ex.getMessage() + "."));
            }
        }
        if (generateProntoHex || actualMasterType == MasterType.ccf) {
            try {
                this.checkForProntoHex();
                if (this.prontoHex != null) {
                    for (int T = 0; T < this.numberOfToggleValues(); ++T) {
                        Element prontoHexEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "ccf");
                        if (this.numberOfToggleValues() > 1) {
                            prontoHexEl.setAttribute(TOGGLE_PARAMETER_NAME, Integer.toString(T));
                        }
                        prontoHexEl.setTextContent(this.prontoHex[T]);
                        element.appendChild(prontoHexEl);
                    }
                }
            }
            catch (GirrException | IrCoreException | IrpException ex) {
                logger.log(Level.INFO, "{0}", ex.getMessage());
                element.appendChild(doc.createComment("Pronto Hex requested but could not be generated: " + ex.getMessage() + "."));
            }
        }
        if (this.otherFormats != null) {
            this.otherFormats.entrySet().stream().map(format -> {
                Element formatEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "format");
                formatEl.setAttribute("name", (String)format.getKey());
                formatEl.setTextContent((String)format.getValue());
                return formatEl;
            }).forEachOrdered(formatEl -> element.appendChild((Node)formatEl));
        }
        return element;
    }

    MasterType actualMasterType(boolean generateParameters, boolean generateProntoHex, boolean generateRaw) {
        MasterType actualMasterType = this.masterType;
        if (this.masterType == MasterType.raw && !generateRaw || this.masterType == MasterType.ccf && !generateProntoHex || this.masterType == MasterType.parameters && !generateParameters) {
            actualMasterType = generateRaw ? MasterType.raw : (generateParameters ? MasterType.parameters : (generateProntoHex ? MasterType.ccf : this.masterType));
        }
        return actualMasterType;
    }

    private boolean canReduce(String inheritedProtocolName, Map<String, Long> inheritedParameters) {
        if (!useInheritanceForXml || !this.protocolName.equals(inheritedProtocolName)) {
            return false;
        }
        for (Map.Entry<String, Long> kvp : this.parameters.entrySet()) {
            Long inheritedParameter;
            String parameterName = kvp.getKey();
            if (parameterName.equals(F_PARAMETER_NAME) || (inheritedParameter = inheritedParameters.get(parameterName)) != null && inheritedParameter.equals(kvp.getValue())) continue;
            return false;
        }
        return true;
    }

    public void strip(MasterType type) throws IrpException, GirrException, IrCoreException {
        if (type != this.masterType) {
            this.checkFor(type);
        }
        if (type != MasterType.parameters) {
            this.parameters = null;
            this.protocol = null;
            this.protocolName = null;
        }
        if (type != MasterType.ccf) {
            this.prontoHex = null;
        }
        if (type != MasterType.raw) {
            this.intro = null;
            this.repeat = null;
            this.ending = null;
            this.frequency = null;
            this.dutyCycle = null;
        }
        this.otherFormats = null;
    }

    public void strip() {
        try {
            this.strip(this.masterType);
        }
        catch (GirrException | IrCoreException | IrpException ex) {
            logger.log(Level.WARNING, ex.getLocalizedMessage());
        }
    }

    public Command transform(String str) throws InvalidNameException, NameUnassignedException, GirrException {
        List<Assignment> transformations = Command.parseTransformations(str);
        return this.transform(transformations);
    }

    public Command transform(Iterable<Assignment> transformations) throws NameUnassignedException, GirrException {
        Map<String, Long> newParameters = this.transformParameters(transformations);
        return new Command(this.name, this.displayName, this.comment, this.notes, this.protocolName, newParameters, true);
    }

    public Map<String, Long> transformParameters(Iterable<Assignment> transformations) throws NameUnassignedException {
        HashMap<String, Long> newParameters = new HashMap<String, Long>(this.parameters.size());
        NameEngine nameEngine = new NameEngine(this.parameters);
        for (Assignment transformation : transformations) {
            long newValue = transformation.toLong(nameEngine);
            newParameters.put(transformation.getName(), newValue);
        }
        HashMap<String, Long> result = new HashMap<String, Long>(nameEngine.toMap());
        result.putAll(newParameters);
        return result;
    }

    static {
        try {
            IrpDatabase database = new IrpDatabase((String)null);
            decoder = new Decoder(database);
            irpDatabase = database;
        }
        catch (IOException | IrpParseException | SAXException ex) {
            throw new ThisCannotHappenException(ex);
        }
    }

    public static enum MasterType {
        raw,
        ccf,
        parameters,
        empty;


        public static MasterType safeValueOf(String s) {
            try {
                if (s.equals("prontoHex")) {
                    return ccf;
                }
                return MasterType.valueOf(s);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
    }

    public static interface CommandTextFormat {
        public String getName();

        public String format(IrSignal var1, int var2);
    }
}

