/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.girr;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.girr.AdminData;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.CommandSet;
import org.harctoolbox.girr.GirrException;
import org.harctoolbox.girr.Named;
import org.harctoolbox.girr.XmlExporter;
import org.harctoolbox.girr.XmlStatic;
import org.harctoolbox.ircore.IrCoreException;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.irp.IrpException;
import org.harctoolbox.xml.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Remote
extends XmlExporter
implements Named,
Iterable<CommandSet> {
    private static final Logger logger = Logger.getLogger(Remote.class.getName());
    private final MetaData metaData;
    private final AdminData adminData;
    private String comment;
    private final Map<String, String> notes;
    private final Map<String, CommandSet> commandSets;
    private final Map<String, Map<String, String>> applicationParameters;

    public Remote(String file) throws GirrException, IOException, SAXException {
        this(XmlUtils.openXmlThing((String)file));
    }

    public Remote(Reader reader) throws IOException, SAXException, GirrException {
        this(XmlUtils.openXmlReader((Reader)reader, null, (boolean)true, (boolean)true));
    }

    public Remote(Document doc) throws GirrException {
        this(doc.getDocumentElement(), null);
    }

    public Remote(Element element, String source) throws GirrException {
        int i;
        if (!element.getTagName().equals("remote")) {
            throw new GirrException("Element name is not remote");
        }
        this.metaData = new MetaData(element.getAttribute("name"), element.getAttribute("displayName"), element.getAttribute("manufacturer"), element.getAttribute("model"), element.getAttribute("deviceClass"), element.getAttribute("remoteName"));
        NodeList nl = element.getElementsByTagName("adminData");
        AdminData adminData = this.adminData = nl.getLength() > 0 ? new AdminData((Element)nl.item(0)) : new AdminData();
        if (source != null && !source.isEmpty()) {
            this.adminData.setSourceIfEmpty(source);
        }
        this.applicationParameters = new LinkedHashMap<String, Map<String, String>>(4);
        this.comment = element.getAttribute("comment");
        this.notes = XmlStatic.parseElementsByLanguage(element.getElementsByTagName("notes"));
        nl = element.getElementsByTagName("applicationData");
        for (i = 0; i < nl.getLength(); ++i) {
            Element el = (Element)nl.item(i);
            NodeList nodeList = el.getElementsByTagName("appParameter");
            HashMap<String, String> map = new HashMap<String, String>(32);
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Element par = (Element)nodeList.item(index);
                map.put(par.getAttribute("name"), par.getAttribute("value"));
            }
            this.applicationParameters.put(el.getAttribute("application"), map);
        }
        nl = element.getElementsByTagName("commandSet");
        this.commandSets = new LinkedHashMap<String, CommandSet>(nl.getLength());
        for (i = 0; i < nl.getLength(); ++i) {
            CommandSet commandSet = new CommandSet((Element)nl.item(i));
            this.commandSets.put(commandSet.getName(), commandSet);
        }
    }

    public Remote(MetaData metaData, String source, String comment, Map<String, String> notes, Collection<CommandSet> commandSetsCollection, Map<String, Map<String, String>> applicationParameters) {
        this.adminData = new AdminData(source);
        this.metaData = metaData;
        this.comment = comment;
        this.notes = notes != null ? notes : new HashMap(2);
        this.commandSets = new LinkedHashMap<String, CommandSet>(4);
        if (commandSetsCollection != null) {
            commandSetsCollection.forEach(cmdSet -> this.commandSets.put(cmdSet.getName(), (CommandSet)cmdSet));
        }
        this.applicationParameters = applicationParameters;
    }

    public Remote(MetaData metaData, String comment, Map<String, String> notes, Collection<CommandSet> commandSetsCollection, Map<String, Map<String, String>> applicationParameters) {
        this(metaData, null, comment, notes, commandSetsCollection, applicationParameters);
    }

    public Remote(MetaData metaData, String comment, Map<String, String> notes, CommandSet commandSet, Map<String, Map<String, String>> applicationParameters) {
        this(metaData, comment, notes, Named.toList(commandSet), applicationParameters);
    }

    public Remote(MetaData metaData, String comment, Map<String, String> notes, Map<String, Command> commands, Map<String, Map<String, String>> applicationParameters, String protocolName, Map<String, Long> parameters) {
        this(metaData, comment, notes, new CommandSet("commandSet", null, commands, protocolName, parameters), applicationParameters);
    }

    public Remote(MetaData metaData, String source, String comment, Map<String, String> notes, Map<String, Command> commands, Map<String, Map<String, String>> applicationParameters, String protocolName, Map<String, Long> parameters) {
        this(metaData, source, comment, notes, Named.toList(new CommandSet("commandSet", null, commands, protocolName, parameters)), applicationParameters);
    }

    public Remote(MetaData metaData, String comment, Map<String, String> notes, Map<String, Command> commands, Map<String, Map<String, String>> applicationParameters) {
        this(metaData, comment, notes, commands, applicationParameters, null, null);
    }

    public Remote(IrSignal irSignal, String name, String comment, String deviceName) {
        this(new MetaData(deviceName), null, null, new CommandSet(new Command(name, comment, irSignal)), null);
    }

    public Remote(CommandSet commandSet) {
        this(new MetaData("unnamed"), null, null, commandSet, null);
    }

    @Override
    public Element toElement(Document doc, boolean fatRaw, boolean generateParameters, boolean generateProntoHex, boolean generateRaw) {
        Element element = doc.createElementNS("http://www.harctoolbox.org/Girr", "remote");
        Element adminDataEl = this.adminData.toElement(doc);
        if (adminDataEl.hasChildNodes() || adminDataEl.hasAttributes()) {
            element.appendChild(adminDataEl);
        }
        element.setAttribute("name", this.metaData.name);
        if (this.metaData.displayName != null && !this.metaData.displayName.isEmpty()) {
            element.setAttribute("displayName", this.metaData.displayName);
        }
        if (this.metaData.manufacturer != null && !this.metaData.manufacturer.isEmpty()) {
            element.setAttribute("manufacturer", this.metaData.manufacturer);
        }
        if (this.metaData.model != null && !this.metaData.model.isEmpty()) {
            element.setAttribute("model", this.metaData.model);
        }
        if (this.metaData.deviceClass != null && !this.metaData.deviceClass.isEmpty()) {
            element.setAttribute("deviceClass", this.metaData.deviceClass);
        }
        if (this.metaData.remoteName != null && !this.metaData.remoteName.isEmpty()) {
            element.setAttribute("remoteName", this.metaData.remoteName);
        }
        if (this.comment != null && !this.comment.isEmpty()) {
            element.setAttribute("comment", this.comment);
        }
        if (this.notes != null) {
            this.notes.entrySet().stream().map(note -> {
                Element notesEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "notes");
                notesEl.setAttribute("xml:lang", (String)note.getKey());
                notesEl.setTextContent((String)note.getValue());
                return notesEl;
            }).forEachOrdered(notesEl -> element.appendChild((Node)notesEl));
        }
        if (this.applicationParameters != null) {
            this.applicationParameters.entrySet().forEach(kvp -> {
                if (kvp.getValue() != null) {
                    Element appEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "applicationData");
                    appEl.setAttribute("application", (String)kvp.getKey());
                    element.appendChild(appEl);
                    ((Map)kvp.getValue()).entrySet().stream().map(param -> {
                        Element paramEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "appParameter");
                        paramEl.setAttribute("name", (String)param.getKey());
                        paramEl.setAttribute("value", (String)param.getValue());
                        return paramEl;
                    }).forEachOrdered(paramEl -> appEl.appendChild((Node)paramEl));
                }
            });
        }
        for (CommandSet commandSet : this) {
            element.appendChild(commandSet.toElement(doc, fatRaw, generateParameters, generateProntoHex, generateRaw));
        }
        return element;
    }

    public void sort(Comparator<? super Named> comparator) {
        ArrayList<CommandSet> list = new ArrayList<CommandSet>(this.commandSets.values());
        Collections.sort(list, comparator);
        Named.populateMap(this.commandSets, list);
    }

    public void sortCommands(Comparator<? super Named> comparator) {
        for (CommandSet commandSet : this) {
            commandSet.sort(comparator);
        }
    }

    public void sortCommands() {
        this.sortCommands(new Named.CompareNameCaseSensitive());
    }

    public void sortCommandsIgnoringCase() {
        this.sort(new Named.CompareNameCaseInsensitive());
    }

    public void sort() {
        this.sort(new Named.CompareNameCaseSensitive());
    }

    public void sortIgnoringCase() {
        this.sort(new Named.CompareNameCaseInsensitive());
    }

    public void normalize() {
        if (this.commandSets.size() < 2) {
            return;
        }
        int numberOfOriginalCommands = this.getNumberOfCommands();
        LinkedHashMap<String, Command> commands = new LinkedHashMap<String, Command>(numberOfOriginalCommands);
        StringJoiner stringJoiner = new StringJoiner(", ", "Merge of CommandSets ", "");
        for (CommandSet cmdSet : this) {
            for (Command cmd : cmdSet) {
                commands.put(cmd.getName(), cmd);
            }
            stringJoiner.add(cmdSet.getName());
        }
        HashMap<String, String> notesCmdSet = new HashMap<String, String>(1);
        String noteString = stringJoiner.toString();
        CommandSet commandSet = new CommandSet("MergedCommandSet", notesCmdSet, commands, null, null);
        this.commandSets.clear();
        this.commandSets.put(commandSet.getName(), commandSet);
        int missing = numberOfOriginalCommands - commandSet.size();
        if (missing > 0) {
            noteString = noteString + "\n" + missing + " commands lost in merge";
        }
        notesCmdSet.put("en", noteString);
    }

    public void addFormat(Command.CommandTextFormat format, int repeatCount) {
        for (CommandSet commandSet : this) {
            for (Command command : commandSet) {
                try {
                    command.addFormat(format, repeatCount);
                }
                catch (IrCoreException | IrpException ex) {
                    logger.log(Level.WARNING, null, ex);
                }
            }
        }
    }

    public boolean hasThisProtocol(String protocolName) throws IrpException, IrCoreException {
        for (CommandSet commandSet : this) {
            for (Command command : commandSet) {
                String prtcl = command.getProtocolName();
                if (prtcl != null && prtcl.equalsIgnoreCase(protocolName)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean containsThisProtocol(String protocolName) throws IrpException, IrCoreException {
        for (CommandSet commandSet : this) {
            for (Command command : commandSet) {
                String prtcl = command.getProtocolName();
                if (prtcl == null || !prtcl.equalsIgnoreCase(protocolName)) continue;
                return true;
            }
        }
        return false;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public String getName() {
        return this.metaData.name;
    }

    public void setName(String name) {
        this.metaData.name = name;
    }

    public String getDisplayName() {
        return this.metaData.displayName;
    }

    public String getComment() {
        return this.comment;
    }

    public int getNumberOfCommands() {
        int sum = 0;
        for (CommandSet cmdSet : this) {
            sum += cmdSet.size();
        }
        return sum;
    }

    public Collection<Command> getCommands() {
        if (this.commandSets.isEmpty()) {
            return new ArrayList<Command>(0);
        }
        if (this.commandSets.size() == 1) {
            return this.iterator().next().getCommands();
        }
        ArrayList<Command> allCommands = new ArrayList<Command>(this.getNumberOfCommands());
        for (CommandSet cmdSet : this) {
            for (Command cmd : cmdSet) {
                allCommands.add(cmd);
            }
        }
        return allCommands;
    }

    public List<Command> getCommand(String name) {
        ArrayList<Command> commands = new ArrayList<Command>(this.commandSets.size());
        for (CommandSet cmdSet : this) {
            Command cmd = cmdSet.getCommand(name);
            if (cmd == null) continue;
            commands.add(cmd);
        }
        return commands;
    }

    public Map<String, Map<String, String>> getApplicationParameters() {
        return Collections.unmodifiableMap(this.applicationParameters);
    }

    public String getManufacturer() {
        return this.metaData.manufacturer;
    }

    public String getModel() {
        return this.metaData.model;
    }

    public String getDeviceClass() {
        return this.metaData.deviceClass;
    }

    public String getRemoteName() {
        return this.metaData.remoteName;
    }

    AdminData getAdminData() {
        return this.adminData;
    }

    public String getFormattedAdminData() {
        return this.adminData.toFormattedString();
    }

    Map<String, String> getAllNotes() {
        return Collections.unmodifiableMap(this.notes);
    }

    public String getNotes() {
        return this.notes.get("en");
    }

    public String getNotes(String lang) {
        return this.notes.get(lang);
    }

    public void setNotes(String lang, String string) {
        this.notes.put(lang, string);
    }

    public void setNotes(String string) {
        this.notes.put("en", string);
    }

    void setComment(String comment) {
        this.comment = comment;
    }

    public void checkForParameters() throws IrpException, IrCoreException {
        for (CommandSet commandSet : this) {
            for (Command command : commandSet) {
                command.checkForParameters();
            }
        }
    }

    @Override
    public Iterator<CommandSet> iterator() {
        return this.commandSets.values().iterator();
    }

    public Map<String, CommandSet> getCommandSets() {
        return Collections.unmodifiableMap(this.commandSets);
    }

    public CommandSet getCommandSet(String name) {
        return this.commandSets.get(name);
    }

    public Command getCommand(String commandSetName, String name) {
        return this.getCommandSet(commandSetName).getCommand(name);
    }

    public void strip() {
        for (CommandSet commandSet : this) {
            commandSet.strip();
        }
    }

    public static final class MetaData
    implements Serializable {
        public static final String DEFAULT_REMOTENAME = "remote";
        private String name;
        private String displayName;
        private String manufacturer;
        private String model;
        private String deviceClass;
        private String remoteName;

        private static boolean isVoid(String s) {
            return s == null || s.isEmpty();
        }

        public MetaData() {
            this.name = DEFAULT_REMOTENAME;
            this.displayName = null;
            this.manufacturer = null;
            this.model = null;
            this.deviceClass = null;
            this.remoteName = null;
        }

        public MetaData(String name) {
            this();
            this.name = name;
        }

        public MetaData(String name, String displayName, String manufacturer, String model, String deviceClass, String remoteName) {
            this.name = name;
            this.displayName = displayName;
            this.manufacturer = manufacturer;
            this.model = model;
            this.deviceClass = deviceClass;
            this.remoteName = remoteName;
        }

        public String toFormattedString() {
            StringBuilder sb = new StringBuilder(256);
            AdminData.printIfNonempty(sb, "name", this.name);
            AdminData.printIfNonempty(sb, "displayName", this.displayName);
            AdminData.printIfNonempty(sb, "manufacturer", this.manufacturer);
            AdminData.printIfNonempty(sb, "model", this.model);
            AdminData.printIfNonempty(sb, "deviceClass", this.deviceClass);
            AdminData.printIfNonempty(sb, "remoteName", this.remoteName);
            int len = sb.length();
            if (len > 1) {
                sb.deleteCharAt(sb.length() - 1);
            }
            return sb.toString();
        }

        public boolean isEmpty() {
            return MetaData.isVoid(this.name) && MetaData.isVoid(this.displayName) && MetaData.isVoid(this.manufacturer) && MetaData.isVoid(this.model) && MetaData.isVoid(this.deviceClass) && MetaData.isVoid(this.remoteName);
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getManufacturer() {
            return this.manufacturer;
        }

        public String getModel() {
            return this.model;
        }

        public String getDeviceClass() {
            return this.deviceClass;
        }

        public String getRemoteName() {
            return this.remoteName;
        }
    }
}

