/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async;

import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hawaiiframework.async.AbortableTaskRunnable;
import org.hawaiiframework.async.timeout.SharedTaskContext;
import org.hawaiiframework.async.timeout.SharedTaskContextHolder;
import org.hawaiiframework.async.timeout.TaskRemoveStrategy;
import org.hawaiiframework.async.timeout.TimeoutGuardTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class AbortableTaskDecorator
implements TaskDecorator {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbortableTaskDecorator.class);
    private final ThreadPoolTaskExecutor taskExecutor;
    private final ScheduledThreadPoolExecutor timeoutExecutor;

    public AbortableTaskDecorator(ThreadPoolTaskExecutor taskExecutor, ScheduledThreadPoolExecutor timeoutExecutor) {
        this.taskExecutor = taskExecutor;
        this.timeoutExecutor = timeoutExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable decorate(Runnable runnable) {
        SharedTaskContext sharedTaskContext = SharedTaskContextHolder.get();
        try {
            Runnable runnable2 = this.getRunnable(runnable, sharedTaskContext);
            return runnable2;
        }
        finally {
            SharedTaskContextHolder.remove();
        }
    }

    private Runnable getRunnable(Runnable runnable, SharedTaskContext sharedTaskContext) {
        this.createTimeoutGuardTask(sharedTaskContext);
        return this.createGuardedTask(runnable, sharedTaskContext);
    }

    private Runnable createGuardedTask(Runnable runnable, SharedTaskContext sharedTaskContext) {
        AbortableTaskRunnable guardedTask = new AbortableTaskRunnable(runnable, sharedTaskContext);
        sharedTaskContext.setTaskRemoveStrategy(new TaskRemoveStrategy(this.taskExecutor.getThreadPoolExecutor(), guardedTask, "guarded", sharedTaskContext.getTaskId()));
        return guardedTask;
    }

    private void createTimeoutGuardTask(SharedTaskContext sharedTaskContext) {
        Integer timeout = sharedTaskContext.getTimeout();
        String taskId = sharedTaskContext.getTaskId();
        LOGGER.debug("Setting timeout of '{}' second(s) for task '{}' with id '{}'.", new Object[]{timeout, sharedTaskContext.getTaskName(), taskId});
        TimeoutGuardTask timeoutGuardTask = new TimeoutGuardTask(sharedTaskContext);
        RunnableScheduledFuture scheduledTimeoutGuardTask = (RunnableScheduledFuture)this.timeoutExecutor.schedule(timeoutGuardTask, (long)timeout.intValue(), TimeUnit.SECONDS);
        sharedTaskContext.setTimeoutGuardTaskRemoveStrategy(new TaskRemoveStrategy(this.timeoutExecutor, scheduledTimeoutGuardTask, "timeout guard", taskId));
    }
}

