/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.hawaiiframework.async.AsyncPropertiesLoader;
import org.hawaiiframework.async.config.AsyncExecutorFactory;
import org.hawaiiframework.async.config.AsyncExecutorInitializer;
import org.hawaiiframework.async.config.BeanRegistrar;
import org.hawaiiframework.async.config.DelegatingExecutorFactory;
import org.hawaiiframework.async.model.ExecutorConfigurationProperties;
import org.hawaiiframework.async.task.listener.TaskListenerFactoryConfiguration;
import org.hawaiiframework.sql.DataSourceProxyConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.core.task.TaskExecutor;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@ConditionalOnProperty(prefix="hawaii.async", name={"enabled"}, matchIfMissing=true)
@Import(value={DataSourceProxyConfiguration.class, TaskListenerFactoryConfiguration.class})
@EnableAsync
public class AsyncExecutorConfiguration
implements BeanDefinitionRegistryPostProcessor,
AsyncConfigurer,
EnvironmentAware {
    public static final String ASYNC_TIMEOUT_EXECUTOR = "asyncTimeoutExecutor";
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncExecutorConfiguration.class);
    private static final String EXECUTOR_CONFIGURATION_PROPERTIES = "executorConfigurationProperties";
    private ExecutorConfigurationProperties properties;
    private final Set<String> executorNames = new HashSet<String>();
    private TaskExecutor defaultExecutor;
    private AsyncPropertiesLoader asyncPropertiesLoader;
    private BeanRegistrar registrar;

    public void postProcessBeanDefinitionRegistry(@NonNull BeanDefinitionRegistry registry) {
        LOGGER.trace("Creating beans for async executors.");
        this.registrar = new BeanRegistrar(registry);
        this.properties = this.getProperties();
        this.registrar.registerBean(EXECUTOR_CONFIGURATION_PROPERTIES, ExecutorConfigurationProperties.class);
        AsyncExecutorFactory factory = new AsyncExecutorFactory(this.registrar, this.properties);
        factory.createExecutors();
        this.executorNames.addAll(factory.getExecutorNames());
    }

    public void postProcessBeanFactory(@NonNull ConfigurableListableBeanFactory beanFactory) {
        LOGGER.trace("Initializing beans for async executors.");
        this.properties = this.getProperties();
        beanFactory.initializeBean((Object)this.properties, EXECUTOR_CONFIGURATION_PROPERTIES);
        AsyncExecutorInitializer executorInitializer = new AsyncExecutorInitializer(beanFactory, this.properties);
        executorInitializer.initializeExecutors();
        this.defaultExecutor = executorInitializer.getDefaultExecutor();
        DelegatingExecutorFactory delegatingExecutorFactory = new DelegatingExecutorFactory(beanFactory, this.registrar, this.properties, this.executorNames);
        delegatingExecutorFactory.createDelegatingExecutors();
    }

    public Executor getAsyncExecutor() {
        return this.defaultExecutor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return null;
    }

    public void setEnvironment(@NonNull Environment environment) {
        this.setAsyncPropertiesLoader(new AsyncPropertiesLoader(environment.getProperty("hawaii.async.configuration")));
    }

    public void setAsyncPropertiesLoader(AsyncPropertiesLoader asyncPropertiesLoader) {
        this.asyncPropertiesLoader = asyncPropertiesLoader;
    }

    private ExecutorConfigurationProperties getProperties() {
        if (this.properties == null) {
            this.properties = this.asyncPropertiesLoader.loadProperties();
        }
        return this.properties;
    }
}

