/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import org.hawaiiframework.async.AsyncExecutorConfiguration;
import org.hawaiiframework.async.YamlJavaBeanPropertyConstructor;
import org.hawaiiframework.async.model.ExecutorConfigurationProperties;
import org.hawaiiframework.exception.HawaiiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;

public class AsyncPropertiesLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncExecutorConfiguration.class);
    private final String configFile;

    public AsyncPropertiesLoader(String configFile) {
        this.configFile = configFile;
    }

    public ExecutorConfigurationProperties loadProperties() {
        try {
            return AsyncPropertiesLoader.loadYamlExecutorConfigurationProperties(new String(Files.readAllBytes(Paths.get(this.configFile, new String[0])), "UTF-8"));
        }
        catch (Exception exception) {
            LOGGER.error("Unable to load async configuration file '{}'.", (Object)this.configFile);
            throw new HawaiiException((Throwable)exception);
        }
    }

    private static ExecutorConfigurationProperties loadYamlExecutorConfigurationProperties(String yaml) {
        Assert.state((yaml != null ? 1 : 0) != 0, (String)"Yaml document should not be null: either set it directly or set the resource to load it from");
        return (ExecutorConfigurationProperties)new Yaml((BaseConstructor)new YamlJavaBeanPropertyConstructor(ExecutorConfigurationProperties.class, Collections.emptyMap())).load(yaml);
    }
}

