/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hawaiiframework.async.AsyncCallable;
import org.hawaiiframework.async.AsyncInvoke;
import org.hawaiiframework.async.exception.HawaiiTaskExecutionException;
import org.hawaiiframework.exception.HawaiiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public final class AsyncUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncUtil.class);

    private AsyncUtil() {
    }

    public static <T> T get(@NonNull CompletableFuture<T> future) {
        Objects.requireNonNull(future);
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            throw AsyncUtil.handleException(exception);
        }
    }

    public static <T> T get(@NonNull CompletableFuture<T> future, @NonNull Long timeout, @NonNull TimeUnit unit) {
        Objects.requireNonNull(future);
        Objects.requireNonNull(timeout);
        Objects.requireNonNull(unit);
        try {
            return future.get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            throw AsyncUtil.handleException(exception);
        }
    }

    public static <T> T getNow(@NonNull CompletableFuture<T> future, T valueIfAbsent) {
        Objects.requireNonNull(future);
        return future.getNow(valueIfAbsent);
    }

    public static <T> CompletableFuture<T> invoke(AsyncCallable<T> body) {
        return AsyncUtil.invoke(false, body);
    }

    public static <T> CompletableFuture<T> invoke(boolean logError, AsyncCallable<T> body) {
        CompletableFuture<T> result = new CompletableFuture<T>();
        try {
            LOGGER.trace("Invoking body");
            T invokeResult = body.invoke();
            LOGGER.trace("Invoking body completed");
            result.complete(invokeResult);
            LOGGER.trace("CompletableFuture completed");
        }
        catch (Throwable exception) {
            if (logError) {
                LOGGER.error("Caught exception.", exception);
            }
            result.completeExceptionally(exception);
        }
        return result;
    }

    public static CompletableFuture<org.hawaiiframework.util.Void> invoke(AsyncInvoke body) {
        return AsyncUtil.invoke(true, () -> {
            body.invoke();
            return new org.hawaiiframework.util.Void();
        });
    }

    public static <T> void waitForCompletion(Long timeout, TimeUnit unit, List<CompletableFuture<T>> futures) {
        AsyncUtil.waitForCompletion(timeout, unit, futures.toArray(new CompletableFuture[0]));
    }

    public static void waitForCompletion(Long timeout, TimeUnit unit, CompletableFuture<?> ... futures) {
        Objects.requireNonNull(futures);
        Objects.requireNonNull(timeout);
        Objects.requireNonNull(unit);
        AsyncUtil.waitForCompletion(timeout, unit, CompletableFuture.allOf(futures));
    }

    public static void waitForCompletion(Long timeout, TimeUnit unit, CompletableFuture<?> future) {
        Objects.requireNonNull(future);
        Objects.requireNonNull(timeout);
        Objects.requireNonNull(unit);
        try {
            future.get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException exception) {
            throw AsyncUtil.handleException(exception);
        }
        catch (TimeoutException exception) {
            LOGGER.debug("Stopped waiting after '{} {}' for task(s) to complete or throw an exception.", (Object)timeout, (Object)unit);
        }
    }

    public static <I, T> List<T> asyncStreamAndMap(Collection<I> inputs, Function<I, CompletableFuture<T>> function) {
        return AsyncUtil.awaitAndGet(AsyncUtil.asyncMap(inputs, function));
    }

    public static <I, T> List<T> asyncStreamAndMapToSingleList(Collection<I> inputs, Function<I, CompletableFuture<List<T>>> function) {
        return AsyncUtil.awaitAndMapToSingleList(AsyncUtil.asyncMap(inputs, function));
    }

    public static <T> List<T> awaitAndMapToSingleList(List<CompletableFuture<List<T>>> futures) {
        return AsyncUtil.awaitAndGet(futures).stream().filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static <I, T> List<CompletableFuture<T>> asyncMap(Collection<I> inputs, Function<I, CompletableFuture<T>> function) {
        if (inputs == null || inputs.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return inputs.stream().map(function).collect(Collectors.toList());
    }

    public static <T> List<T> awaitAndGet(List<CompletableFuture<T>> futures) {
        ArrayList<T> results = new ArrayList<T>();
        if (futures == null || futures.isEmpty()) {
            return results;
        }
        for (CompletableFuture<T> future : futures) {
            results.add(AsyncUtil.get(future));
        }
        return results;
    }

    public static <T> List<CompletableFuture<T>> awaitCompletion(List<CompletableFuture<T>> futures) {
        if (futures == null || futures.isEmpty()) {
            return futures;
        }
        CompletableFuture<Void> combinedFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        AsyncUtil.get(combinedFuture);
        return futures;
    }

    private static HawaiiException handleException(Exception exception) {
        if (exception instanceof ExecutionException) {
            return AsyncUtil.handleExecutionException(exception);
        }
        return new HawaiiTaskExecutionException(exception);
    }

    private static HawaiiException handleExecutionException(Exception exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof HawaiiException) {
            return (HawaiiException)cause;
        }
        return new HawaiiTaskExecutionException(cause);
    }
}

