/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.hawaiiframework.async.model.ExecutorConfigurationProperties;
import org.hawaiiframework.async.statistics.ExecutorStatistics;
import org.hawaiiframework.async.statistics.ExecutorStatisticsView;
import org.hawaiiframework.async.task.listener.TaskListener;
import org.hawaiiframework.async.task.listener.TaskListenerFactory;
import org.hawaiiframework.async.timeout.SharedTaskContext;
import org.hawaiiframework.async.timeout.SharedTaskContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.SchedulingTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class DelegatingExecutor
implements AsyncTaskExecutor,
SchedulingTaskExecutor {
    private static final long serialVersionUID = -8533500008410021569L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatingExecutor.class);
    private final ThreadPoolTaskExecutor delegate;
    private final ExecutorConfigurationProperties executorConfigurationProperties;
    private final String taskName;
    private final ExecutorStatistics executorStatistics;
    private final Collection<TaskListenerFactory> taskListenerFactories;

    public DelegatingExecutor(ThreadPoolTaskExecutor delegate, ExecutorConfigurationProperties executorConfigurationProperties, Collection<TaskListenerFactory> taskListenerFactories, String taskName) {
        this.delegate = delegate;
        this.executorConfigurationProperties = executorConfigurationProperties;
        this.executorStatistics = new ExecutorStatistics(delegate);
        this.taskListenerFactories = taskListenerFactories;
        this.taskName = taskName;
    }

    public void execute(@NonNull Runnable task) {
        this.initializeTask();
        this.delegate.execute(task);
    }

    @Deprecated
    public void execute(@NonNull Runnable task, long startTimeout) {
        this.initializeTask();
        this.delegate.execute(task, startTimeout);
    }

    public Future<?> submit(@NonNull Runnable task) {
        this.initializeTask();
        return this.delegate.submit(task);
    }

    public <T> Future<T> submit(@NonNull Callable<T> task) {
        this.initializeTask();
        return this.delegate.submit(task);
    }

    private void initializeTask() {
        SharedTaskContext sharedTaskContext = new SharedTaskContext(this.taskName, this.executorConfigurationProperties, this.executorStatistics, this.createTaskListeners());
        LOGGER.info("Scheduling task '{}' with id '{}'.", (Object)sharedTaskContext.getTaskName(), (Object)sharedTaskContext.getTaskId());
        LOGGER.info("Executor '{}' has '{}/{}' threads, '{}' queued entries, '{}' total executions and '{}' aborted executions.", new Object[]{this.taskName, this.executorStatistics.getPoolSize(), this.executorStatistics.getMaxPoolSize(), this.executorStatistics.getQueueSize(), this.executorStatistics.getCompletedTaskCount(), this.executorStatistics.getAbortedTaskCount()});
        SharedTaskContextHolder.register(sharedTaskContext);
    }

    private List<TaskListener> createTaskListeners() {
        return this.taskListenerFactories.stream().map(TaskListenerFactory::create).collect(Collectors.toList());
    }

    public ExecutorStatisticsView getExecutorStatistics() {
        return new ExecutorStatisticsView(this.executorStatistics);
    }

    public boolean hasDelegate(ThreadPoolTaskExecutor executor) {
        return this.delegate.equals(executor);
    }

    public int getActiveCount() {
        return this.delegate.getActiveCount();
    }

    public boolean prefersShortLivedTasks() {
        return this.delegate.prefersShortLivedTasks();
    }
}

