/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async.config;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.hawaiiframework.async.config.BeanRegistrar;
import org.hawaiiframework.async.model.ExecutorConfigurationProperties;
import org.hawaiiframework.async.model.ExecutorProperties;
import org.hawaiiframework.exception.HawaiiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class AsyncExecutorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncExecutorFactory.class);
    private final Set<String> executorNames = new HashSet<String>();
    private final BeanRegistrar registrar;
    private final ExecutorConfigurationProperties properties;

    public AsyncExecutorFactory(BeanRegistrar registrar, ExecutorConfigurationProperties properties) {
        this.registrar = registrar;
        this.properties = properties;
    }

    public void createExecutors() {
        ConstructorArgumentValues taskExecutorConstructorValues = new ConstructorArgumentValues();
        taskExecutorConstructorValues.addIndexedArgumentValue(0, (Object)this.properties.getAsyncTimeoutExecutorPoolSize());
        this.registrar.registerBean("asyncTimeoutExecutor", ScheduledThreadPoolExecutor.class, taskExecutorConstructorValues);
        for (ExecutorProperties executorProperties : this.properties.getExecutors()) {
            if (!this.executorNames.add(executorProperties.getName())) {
                throw new HawaiiException(String.format("Configuration contained multiple definitions of '%s'.", executorProperties.getName()));
            }
            LOGGER.info("Registering executor '{}'.", (Object)executorProperties);
            this.registrar.registerBean(executorProperties.getName(), ThreadPoolTaskExecutor.class);
        }
    }

    public Set<String> getExecutorNames() {
        return this.executorNames;
    }
}

