/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async.config;

import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.hawaiiframework.async.AbortableTaskDecorator;
import org.hawaiiframework.async.DelegatingExecutor;
import org.hawaiiframework.async.model.ExecutorConfigurationProperties;
import org.hawaiiframework.async.model.ExecutorProperties;
import org.hawaiiframework.async.task.listener.TaskListenerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.task.TaskDecorator;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class AsyncExecutorInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncExecutorInitializer.class);
    private TaskExecutor defaultExecutor;
    private final ConfigurableListableBeanFactory beanFactory;
    private final ExecutorConfigurationProperties configuration;

    public AsyncExecutorInitializer(ConfigurableListableBeanFactory beanFactory, ExecutorConfigurationProperties configuration) {
        this.beanFactory = beanFactory;
        this.configuration = configuration;
    }

    public void initializeExecutors() {
        ScheduledThreadPoolExecutor asyncTimeoutExecutor = (ScheduledThreadPoolExecutor)this.beanFactory.getBean("asyncTimeoutExecutor");
        asyncTimeoutExecutor.setThreadFactory((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("async-timeout-%d").daemon(true).build());
        this.beanFactory.initializeBean((Object)asyncTimeoutExecutor, "asyncTimeoutExecutor");
        for (ExecutorProperties executorConfiguration : this.configuration.getExecutors()) {
            ThreadPoolTaskExecutor executor = this.initializeExecutor(executorConfiguration, asyncTimeoutExecutor);
            if (!this.isDefaultExecutor(executorConfiguration)) continue;
            this.registerDefaultExecutor(executor);
        }
    }

    private void registerDefaultExecutor(ThreadPoolTaskExecutor executor) {
        Map beansOfType = this.beanFactory.getBeansOfType(TaskListenerFactory.class);
        this.defaultExecutor = new DelegatingExecutor(executor, this.configuration, beansOfType.values(), this.configuration.getDefaultExecutor());
    }

    public TaskExecutor getDefaultExecutor() {
        return this.defaultExecutor;
    }

    private ThreadPoolTaskExecutor initializeExecutor(ExecutorProperties executorConfiguration, ScheduledThreadPoolExecutor timeoutExecutor) {
        LOGGER.info("Creating executor '{}'.", (Object)executorConfiguration);
        ThreadPoolTaskExecutor taskExecutor = (ThreadPoolTaskExecutor)this.beanFactory.getBean(executorConfiguration.getName());
        taskExecutor.setThreadFactory(null);
        taskExecutor.setThreadNamePrefix(executorConfiguration.getName() + "-");
        taskExecutor.setCorePoolSize(executorConfiguration.getCorePoolSize().intValue());
        taskExecutor.setMaxPoolSize(executorConfiguration.getMaxPoolSize().intValue());
        taskExecutor.setQueueCapacity(executorConfiguration.getMaxPendingRequests().intValue());
        taskExecutor.setKeepAliveSeconds(executorConfiguration.getKeepAliveTime().intValue());
        taskExecutor.setTaskDecorator((TaskDecorator)new AbortableTaskDecorator(taskExecutor, timeoutExecutor));
        taskExecutor.initialize();
        return taskExecutor;
    }

    private boolean isDefaultExecutor(ExecutorProperties executorProperties) {
        return this.isDefaultExecutor(executorProperties.getName());
    }

    private boolean isDefaultExecutor(String executorName) {
        return !StringUtils.isBlank((CharSequence)executorName) && executorName.equals(this.configuration.getDefaultExecutor());
    }
}

