/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async.config;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.lang.Nullable;

public class BeanRegistrar {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanRegistrar.class);
    private final BeanDefinitionRegistry registry;

    public BeanRegistrar(BeanDefinitionRegistry registry) {
        this.registry = registry;
    }

    public void registerBean(String beanName, Class<?> clazz) {
        this.registerBean(beanName, clazz, null);
    }

    public void registerBean(String beanName, Class<?> clazz, @Nullable ConstructorArgumentValues constructorArgumentValues) {
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        beanDefinition.setBeanClass(clazz);
        beanDefinition.setAutowireMode(0);
        beanDefinition.setDependencyCheck(0);
        if (constructorArgumentValues != null) {
            beanDefinition.setConstructorArgumentValues(constructorArgumentValues);
        }
        LOGGER.trace("Registering bean '{}' of type '{}'.", (Object)beanName, (Object)clazz.getSimpleName());
        this.registry.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }
}

