/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async.config;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hawaiiframework.async.DelegatingExecutor;
import org.hawaiiframework.async.config.BeanRegistrar;
import org.hawaiiframework.async.model.ExecutorConfigurationProperties;
import org.hawaiiframework.async.model.SystemProperties;
import org.hawaiiframework.async.model.TaskProperties;
import org.hawaiiframework.async.task.listener.TaskListenerFactory;
import org.hawaiiframework.exception.HawaiiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.core.task.TaskExecutor;

public class DelegatingExecutorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelegatingExecutorFactory.class);
    private final ConfigurableListableBeanFactory beanFactory;
    private final BeanRegistrar registrar;
    private final ExecutorConfigurationProperties configuration;
    private final Set<String> executorNames;

    public DelegatingExecutorFactory(ConfigurableListableBeanFactory beanFactory, BeanRegistrar registrar, ExecutorConfigurationProperties configuration, Set<String> executorNames) {
        this.beanFactory = beanFactory;
        this.registrar = registrar;
        this.configuration = configuration;
        this.executorNames = executorNames;
    }

    public void createDelegatingExecutors() {
        for (SystemProperties systemProperties : this.configuration.getSystems()) {
            String systemName = systemProperties.getName();
            String systemExecutor = systemProperties.getDefaultExecutor();
            if (StringUtils.isNotBlank((CharSequence)systemExecutor) && !this.executorNames.contains(systemExecutor)) {
                throw new HawaiiException(String.format("Executor '%s' of system '%s' is not defined.", systemExecutor, systemName));
            }
            for (TaskProperties taskProperties : systemProperties.getTasks()) {
                String executorName = taskProperties.getExecutor();
                String taskName = String.format("%s.%s", systemName, taskProperties.getMethod());
                if (StringUtils.isNotBlank((CharSequence)executorName)) {
                    if (!this.executorNames.contains(executorName)) {
                        throw new HawaiiException(String.format("Executor '%s' of task '%s' is not defined.", executorName, taskName));
                    }
                    LOGGER.debug("Configuring task '{}' to use executor '{}'.", (Object)taskName, (Object)executorName);
                } else {
                    LOGGER.info("No executor defined for task '{}'. Falling back to system executor '{}'.", (Object)taskName, (Object)systemExecutor);
                }
                String executor = (String)StringUtils.defaultIfBlank((CharSequence)executorName, (CharSequence)((String)StringUtils.defaultIfBlank((CharSequence)systemExecutor, (CharSequence)this.configuration.getDefaultExecutor())));
                this.createTaskExecutorDelegate(taskName, executor);
            }
        }
    }

    private void createTaskExecutorDelegate(String taskName, String executor) {
        Map beansOfType = this.beanFactory.getBeansOfType(TaskListenerFactory.class);
        TaskExecutor delegate = (TaskExecutor)this.beanFactory.getBean(executor);
        ConstructorArgumentValues constructorArgumentValues = new ConstructorArgumentValues();
        constructorArgumentValues.addIndexedArgumentValue(0, (Object)delegate);
        constructorArgumentValues.addIndexedArgumentValue(1, (Object)this.configuration);
        constructorArgumentValues.addIndexedArgumentValue(2, beansOfType.values());
        constructorArgumentValues.addIndexedArgumentValue(3, (Object)taskName);
        LOGGER.debug("Registering delegate '{}' to for executor '{}'.", (Object)taskName, (Object)executor);
        this.registrar.registerBean(taskName, DelegatingExecutor.class, constructorArgumentValues);
    }
}

