/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async.http;

import java.util.Objects;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.hawaiiframework.async.timeout.TaskAbortStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class HttpComponentHttpRequestTaskAbortStrategy
implements TaskAbortStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpComponentHttpRequestTaskAbortStrategy.class);
    private final HttpUriRequest request;

    public HttpComponentHttpRequestTaskAbortStrategy(@NonNull HttpUriRequest request) {
        this.request = Objects.requireNonNull(request);
    }

    @Override
    public boolean invoke() {
        try {
            LOGGER.trace("Invoking HttpUriRequest#abort().");
            this.request.abort();
            return true;
        }
        catch (UnsupportedOperationException exception) {
            LOGGER.error("Cannot stop http request.", (Throwable)exception);
            return false;
        }
    }
}

