/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async.http;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.hawaiiframework.async.timeout.SharedTaskContextHolder;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class TaskIdSupplierHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private final String headerName;

    public TaskIdSupplierHttpRequestInterceptor() {
        this("X-Hawaii-Task-Id");
    }

    public TaskIdSupplierHttpRequestInterceptor(String headerName) {
        this.headerName = headerName;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        String taskId = SharedTaskContextHolder.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            request.getHeaders().add(this.headerName, taskId);
        }
        return execution.execute(request, body);
    }
}

