/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async.model;

import java.util.ArrayList;
import java.util.List;
import org.hawaiiframework.async.model.ExecutorProperties;
import org.hawaiiframework.async.model.SystemProperties;
import org.hawaiiframework.async.model.TaskProperties;

public class ExecutorConfigurationProperties {
    private static final String SEPARATOR = "\\.";
    private String defaultExecutor;
    private Integer defaultTimeout = 10;
    private Integer asyncTimeoutExecutorPoolSize = 4;
    private List<ExecutorProperties> executors = new ArrayList<ExecutorProperties>();
    private List<SystemProperties> systems = new ArrayList<SystemProperties>();

    public String getDefaultExecutor() {
        return this.defaultExecutor;
    }

    public void setDefaultExecutor(String defaultExecutor) {
        this.defaultExecutor = defaultExecutor;
    }

    public Integer getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(Integer defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public Integer getAsyncTimeoutExecutorPoolSize() {
        return this.asyncTimeoutExecutorPoolSize;
    }

    public void setAsyncTimeoutExecutorPoolSize(Integer asyncTimeoutExecutorPoolSize) {
        this.asyncTimeoutExecutorPoolSize = asyncTimeoutExecutorPoolSize;
    }

    public List<ExecutorProperties> getExecutors() {
        return this.executors;
    }

    public void setExecutors(List<ExecutorProperties> executors) {
        this.executors = executors;
    }

    public void addExecutor(ExecutorProperties executor) {
        if (this.executors == null) {
            this.executors = new ArrayList<ExecutorProperties>();
        }
        this.executors.add(executor);
    }

    public List<SystemProperties> getSystems() {
        return this.systems;
    }

    public void setSystems(List<SystemProperties> systems) {
        this.systems = systems;
    }

    public void addSystem(SystemProperties system) {
        if (this.systems == null) {
            this.systems = new ArrayList<SystemProperties>();
        }
        this.systems.add(system);
    }

    public Integer getTaskTimeout(String taskName) {
        String[] parts = taskName.split(SEPARATOR);
        SystemProperties systemProperties = this.getSystemPropertiesForName(parts[0]);
        Integer timeout = null;
        if (systemProperties != null) {
            TaskProperties taskProperties = systemProperties.getTaskPropertiesForName(parts[1]);
            if (taskProperties != null) {
                timeout = taskProperties.getTimeout();
            }
            if (timeout == null) {
                timeout = systemProperties.getDefaultTimeout();
            }
        }
        if (timeout == null) {
            timeout = this.getDefaultTimeout();
        }
        return timeout;
    }

    public SystemProperties getSystemPropertiesForName(String systemName) {
        return this.systems.stream().filter(systemProperties -> systemProperties.nameMatches(systemName)).findFirst().orElse(null);
    }
}

