/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async.sql;

import java.util.List;
import net.ttddyy.dsproxy.ExecutionInfo;
import net.ttddyy.dsproxy.QueryInfo;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import org.hawaiiframework.async.sql.QueryTaskAbortStrategy;
import org.hawaiiframework.async.timeout.SharedTaskContextHolder;
import org.hawaiiframework.async.timeout.TaskAbortStrategy;
import org.hawaiiframework.sql.OrderedQueryExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

@ConditionalOnClass(value={QueryExecutionListener.class})
@Component
public class AbortStrategyQueryExecutionListener
implements OrderedQueryExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbortStrategyQueryExecutionListener.class);

    public void beforeQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
        LOGGER.trace("Registering abort strategy.");
        SharedTaskContextHolder.setTaskAbortStrategy(AbortStrategyQueryExecutionListener.createAbortStrategy(execInfo));
    }

    public void afterQuery(ExecutionInfo execInfo, List<QueryInfo> queryInfoList) {
    }

    private static TaskAbortStrategy createAbortStrategy(ExecutionInfo execInfo) {
        return new QueryTaskAbortStrategy(execInfo.getStatement());
    }

    public int getOrder() {
        return 0;
    }
}

