/*
 * Decompiled with CFR 0.152.
 */
package org.hawaiiframework.async.statistics;

import java.util.concurrent.atomic.AtomicLong;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ExecutorStatistics {
    private final ThreadPoolTaskExecutor executor;
    private final AtomicLong abortedTaskCount = new AtomicLong(0L);

    public ExecutorStatistics(ThreadPoolTaskExecutor executor) {
        this.executor = executor;
    }

    public void incrementAbortedTaskCount() {
        this.abortedTaskCount.incrementAndGet();
    }

    public Integer getPoolSize() {
        return this.executor.getPoolSize();
    }

    public Integer getMaxPoolSize() {
        return this.executor.getMaxPoolSize();
    }

    public Integer getQueueSize() {
        return this.executor.getThreadPoolExecutor().getQueue().size();
    }

    public Long getCompletedTaskCount() {
        return this.executor.getThreadPoolExecutor().getCompletedTaskCount();
    }

    public Long getAbortedTaskCount() {
        return this.abortedTaskCount.get();
    }
}

